<?php

/*
  ┌─────────────────────────────────────────────────┐
  │		*クラス名		: layout
  │					　全体コントロール
  │		*概要		：自作テンプレートエンジンのコントローラークラス。
  │					　このクラスを読み込んだら基本的な関数は全部使えるようになる。
  │
  │		*作成者		：shie.plus*2 椎本
  │
  │	***********＜＜記録＞＞***********
  │		2013/02/28	新規作成
  │
  │
  └─────────────────────────────────────────────────┘
 */

class layout {

	var $base_url = 'http://localhost/test/template'; //indexのURLパス。
	var $layout_file = '';
	var $view_ext = 'phtml';   //テンプレートファイルの拡張子。
	var $view_file = '';
	var $view_dir = '/view'; //indexからの相対パス。
	var $view_file_name = ''; //コンパイル前のファイル名
	var $view_file_path = ''; //コンパイル前のファイルのパス　ファイル名月
	var $compile_file_dir = '/compile'; //コンパイル後のphpファイルを保存するパスです。
	var $compile_file_name = ''; //コンパイル後のファイル名
	var $compile_file_path = ''; //コンパイル後のファイルのパス　ファイル名月
	var $view_str;

	public function __construct() {
		include_once dirname(__FILE__) . '/compile.php';
		$this->compile = new compile();
	}

	/*
	  |-----------------------------------------------------------------------------------
	  |	type	:	public
	  |	name	:	layout
	  |	sub		:	viewふぁいるを指定する事で、viewファイルのコンパイルから表示までを行う。
	  |				第３引数にFALSEを指定する事でphp実行後のHTMLを返す。
	  |
	  |	@params	:	$view(str)	　: viewファイル名、$base_url内にある事が条件で、フォルダがあっても/区切りで指定可能とする。
	  |				$data(array)　: viewファイルに使用するデータを収めた連想配列。
	  |								$viewファイル内で、$data['hoge']はviewファイル内では$hogeとして扱える。
	  |				$bool(bool)　 : 実行後のhtmlをどうするかを選ぶ事が出来る。
	  |								初期値はTRUEでそのまま表示する。
	  |								TRUE＝実行後に表示　FALSE＝実行後に文字列として返す。
	  |	@return	:	$html(html) : 第３引数がFALSEの時のみ有る。
	  |							　viewファイル実行後のhtmlを格納する。
	  |-----------------------------------------------------------------------------------
	 */

	public function layout($view, $data, $bool = TRUE) {
		$this->compile->set_param(array(
			'base_url' => $this->base_url, //indexのURLパス。
			'layout_file' => $this->layout_file,
			'view_ext' => $this->view_ext, //テンプレートファイルの拡張子。
			'view_file' => $view,
			'view_dir' => $this->view_dir //indexからの相対パス。
		));
		$this->view_str = $this->compile->do_compile();
		extract($data);
		$code = eval('?> '.$this->view_str.'<?php ');
		if ($bool === FALSE) {
			return $code;
		} else {
			print $code;
		}
	}

	/*	 * **************************************************************
	 * 	@name	set_param 
	 * 
	 * 	@sub	当クラスのユーザー変数を一気に登録する関数。
	 * 	@param	$param = array('ユーザー変数'=>'それぞれに値する文字列')
	 * ************************************************************** */

	public function set_param($param) {
		foreach ($param as $val) {
			switch ($val) {
				case 'layout_file':
					$this->set_layout_file($val);
					break;
				case 'base_url':
					$this->set_base_url($val);
					break;
				case 'view_ext':
					$this->set_view_ext($val);
					break;
				case 'view_dir':
					$this->set_view_dir($val);
					break;
				default :
					break;
			}
		}
	}

	public function set_layout_file($layout_file) {
		$this->layout_file = $layout_file;
	}

	public function set_view_dir($dir_name) {
		$this->view_dir = $dir_name;
	}

	public function set_base_url($base_url) {
		$this->base_url = $base_url;
	}

	public function set_view_ext($view_ext) {
		$this->view_ext = $view_ext;
	}

}

?>