/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CloneableStream;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.SQLBinary;

public class SQLBlob
extends SQLBinary {
    public SQLBlob() {
    }

    public SQLBlob(byte[] byArray) {
        super(byArray);
    }

    public SQLBlob(Blob blob) {
        super(blob);
    }

    @Override
    public String getTypeName() {
        return "BLOB";
    }

    @Override
    int getMaxMemoryUsage() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean hasStream() {
        return this.stream != null;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        SQLBlob sQLBlob = new SQLBlob();
        if (this.isNull()) {
            return sQLBlob;
        }
        if (!bl && this.dataValue == null) {
            if (this.stream != null && this.stream instanceof CloneableStream) {
                sQLBlob.setStream(((CloneableStream)((Object)this.stream)).cloneStream());
                if (this.streamValueLength != -1) {
                    sQLBlob.streamValueLength = this.streamValueLength;
                }
            } else if (this._blobValue != null) {
                sQLBlob.setValue(this._blobValue);
            }
        }
        if (sQLBlob.isNull() || bl) {
            try {
                sQLBlob.setValue(this.getBytes());
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        return sQLBlob;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBlob();
    }

    @Override
    public Object getObject() throws StandardException {
        if (this._blobValue != null) {
            return this._blobValue;
        }
        byte[] byArray = this.getBytes();
        if (byArray == null) {
            return null;
        }
        return new HarmonySerialBlob(byArray);
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor);
        this.setWidth(dataTypeDescriptor.getMaximumWidth(), 0, true);
    }

    @Override
    public void setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (this.isLengthLess()) {
            return;
        }
        int n3 = this.getLength();
        if (n3 > n) {
            if (bl) {
                throw StandardException.newException("22001", this.getTypeName(), "XXXX", String.valueOf(n));
            }
            this.truncate(n3, n, true);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 443;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException, StandardException {
        Blob blob = resultSet.getBlob(n);
        if (blob == null) {
            this.setToNull();
        } else {
            this.setObject(blob);
        }
    }

    @Override
    public int typePrecedence() {
        return 170;
    }

    @Override
    public void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        if (this.isNull()) {
            preparedStatement.setBlob(n, (Blob)null);
            return;
        }
        preparedStatement.setBytes(n, this.getBytes());
    }

    @Override
    final void setObject(Object object) throws StandardException {
        Blob blob = (Blob)object;
        try {
            long l = blob.length();
            if (l < 0L || l > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            this.setValue(new RawToBinaryFormatStream(blob.getBinaryStream(), (int)l), (int)l);
        }
        catch (SQLException sQLException) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }

    private final boolean isLengthLess() {
        return this.stream != null && this.streamValueLength < 0;
    }
}

