package littlemaid.network;

import io.netty.buffer.ByteBuf;
import littlemaid.entity.EntityLittleMaid;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageRequestEquip implements IMessage {

	private int maidId;

	public MessageRequestEquip() {}

	public MessageRequestEquip(EntityLittleMaid maidIn) {
		this.maidId = maidIn.getEntityId();
	}

	@Override
	public void fromBytes(ByteBuf buf) {
		this.maidId = buf.readInt();
	}

	@Override
	public void toBytes(ByteBuf buf) {
		buf.writeInt(this.maidId);
	}

	/**
	 * メイドさんのEntityIDを取得
	 */
	public int getMaidEntityID() {
		return this.maidId;
	}

}
