package littlemaid.network;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessagePlaySoundHandler implements IMessageHandler<MessagePlaySound, IMessage> {

	/**
	 * クライアントからのメッセージを受けてサーバー側で音声再生する。
	 */
	@Override
	public IMessage onMessage(MessagePlaySound message, MessageContext ctx) {

		try {
			World worldIn = ctx.getServerHandler().playerEntity.worldObj;
			if (worldIn == null) return null;

			Entity maid = worldIn.getEntityByID(message.getMaidEntityID());
			if (maid == null) return null;

			// 音声の再生
			maid.playSound(message.getSoundName(), 1.0F, 1.0F);

		} catch (NullPointerException e) {
			//開始直後にgetEntityByID()内でぬるぽが出ることがあるのでもみ消しとく
		}

		return null;
	}

}
