package littlemaid.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

/**
 * 音声再生のための自作メッセージ
 * EntityのplaySoundはサーバー側で実行しないと音声が再生されない（みたいな）ので、
 * クライアント側の処理で音声再生を行いたい場合はこのメッセージを飛ばしてサーバー側で再生してもらう。
 */
public class MessagePlaySound implements IMessage {

	private int entityId;
	private String soundName;

	public MessagePlaySound() {}

	/**
	 * 音声再生のためのメッセージを作成する
	 * @param entity 再生元エンティティ
	 * @param name 再生する音声名
	 */
	public MessagePlaySound(Entity entity, String name) {
		this.entityId = entity.getEntityId();
		this.soundName = name;
	}

	@Override
	public void fromBytes(ByteBuf buf) {
		PacketBuffer pbuf = new PacketBuffer(buf);
		this.entityId = pbuf.readInt();
		this.soundName = pbuf.readStringFromBuffer(256);
	}

	@Override
	public void toBytes(ByteBuf buf) {
		PacketBuffer pbuf = new PacketBuffer(buf);
		pbuf.writeInt(this.entityId);
		pbuf.writeString(this.soundName);
	}

	/**
	 * メイドさんのEntityIDを取得
	 */
	public int getMaidEntityID() {
		return this.entityId;
	}

	/**
	 * 再生する音声名を取得
	 */
	public String getSoundName() {
		return this.soundName;
	}
}
