package littlemaid.entity;

import littlemaid.LittleMaidCore;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerLittleMaidArmor extends LayerArmorBase {

	public LayerLittleMaidArmor(RendererLivingEntity p_i46125_1_) {
		super(p_i46125_1_);
		// 受け取ったRendererは、メンバ変数"this.field_177190_a"に入る
	}

	/**
	 * コンストラクタから呼び出される初期化メソッド
	 */
	@Override
	protected void func_177177_a() {
		// 体装備のレイヤー部分に使うモデル？（2の時使われる）
		this.field_177189_c = new ModelLittleMaid(0.2F);
		// 体以外の装備に使うモデル
		this.field_177186_d = new ModelLittleMaid(0.2F);
	}

	@Override
	protected void func_177179_a(ModelBase model, int slot) {
		ModelLittleMaid bipedModel = (ModelLittleMaid) model;

		bipedModel.setInvisible(false);

		// 1-Shoes 2-leggings 3-armor 4-helmet
		switch (slot)
		{
		case 1:
			bipedModel.bipedRightLeg.showModel = true;
			bipedModel.bipedLeftLeg.showModel = true;
			break;
		case 2:
			bipedModel.skirt.showModel = true;
			bipedModel.landingSkirt.showModel = true;
			break;
		case 3:
			bipedModel.bipedBody.showModel = true;
			bipedModel.bipedRightArm.showModel = true;
			bipedModel.bipedLeftArm.showModel = true;
			break;
		case 4:
			bipedModel.bipedHead.showModel = true;
			bipedModel.bipedHeadwear.showModel = true;
		}
	}

	@Override
	public ResourceLocation getArmorResource(Entity entity, ItemStack stack, int slot, String type) {
		String texture = ((ItemArmor) stack.getItem()).getArmorMaterial().getName();
		int idx = texture.indexOf(':');
		if (idx != -1)
		{
			texture = texture.substring(idx + 1);
		}
		String s1 = String.format("%s:textures/models/armor/original/%s_layer_1.png", LittleMaidCore.MODID, texture);

		return new ResourceLocation(s1);
	}

}
