	.list ON, EXP
	
; Parser definitions for fig-FORTH for SH-3
; Joel Matthew Rees, Hyougo Polytec Center
; 2014.03.01

; Licensed extended under GPL v. 2 or 3, or per the following:
; ------------------------------------LICENSE-------------------------------------
;
; Copyright (c) 2009, 2010, 2011 Joel Matthew Rees
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
; THE SOFTWARE.
;
; --------------------------------END-OF-LICENSE----------------------------------


; Monolithic, not separate assembly:
; context.inc must be included before this file.
;	.include	"context.inc"
;
;	.section	parser, code


; DIGIT   ( c base --- ff )
;         ( c base --- n tf )
;         Translate C in base, yielding a translation valid flag.  If the
;         translation is not valid in the specified base, only the false
;         flag is returned.
;
	HEADER	DIGIT, DIGIT
	mov.l	@(NATURAL_SIZE,fSP), r0	; Vrbg
	mov.b	#"0", r1
	cmp/ge	r1, r0 		; character (r0) >= "0"
	bf	DIGITno
	add 	#-"0", r0
	mov.b	#9, r1
	cmp/gt	r1, r0		; digit (r0) > 9
	bf	DIGITbase
	mov.b	#"A"-"0", r1
	cmp/ge	r1, r0		; was it between "9" and "A"?
	bf	DIGITno
	add 	#"9"-"A"+1, r0
DIGITbase:
	mov.l	@fSP, r1
	cmp/ge	r1, r0		; digit (r0) >= base
	bt DIGITno
	mov.l	r0, @(NATURAL_SIZE,fSP)
	mov.b	#-1, r0 	; store the converted digit
	rts
	mov.l	r0, @fSP	; set the flag on our way out
;
DIGITno:
	mov.b	#0, r0
	add 	#NATURAL_SIZE, fSP
	rts
	mov.l	r0, @fSP	; set the flag on our way out


; ENCLOSE ( buffer c --- buffer off1 off2 off3 )
;         Scan buffer for a symbol delimited by c or ASCII NUL; 
;         return the offsets to the first character of the symbol,
;         the last character of the symbol,
;         and the next character after the symbol.
;         Walks all over r0-r3 and fW.
;
	HEADER	ENCLOSE, ENCLOS
	mov.l	@fSP, r2	; delimiter
	mov.l	@(NATURAL_SIZE,fSP), r1		; point to start in the buffer
	mov 	#0, r3		; count
ENCLOSleadloop:
	mov.b	@r1+, r0
	cmp/eq	#0, r0		; NUL character before symbol?
	bt  	ENCLOSnone
	cmp/eq	r2, r0		; leading delimiter? (Usually SPACE.)
	bt  	ENCLOSword
	bra 	ENCLOSleadloop
	add 	#1, r1		; Count it as we go.
;
ENCLOSword:
	mov.l	r3, @fSP	; Save offset to symbol or NUL.
	mov.l	@r1+, r0	; get the next one
ENCLOSwordloop:
	cmp/eq	#0, r0		; NUL?
	bt/s  	ENCLOSnulterm
	add 	#1, r3		; count the one before
	cmp/eq	r2, r0		; delimiter
	bf/s  	ENCLOSwordloop
	mov.l	@r1+, r0	; Get the next one, but not beyond NUL.
;
; The pointer and character don't matter, just the count.
	mov.l	r3, @-fSP	; Count to non-NUL delimiter.
	add 	#1, r3		; Next character that might be part of a symbol.
	rts
	mov.l	r3, @-fSP	; Save it as we go.
	
; found NUL before non-delimiter, therefore there is no word
ENCLOSnone:
	mov.l	r3, @fSP	; Save offset to NUL.
	add 	#1, r3
	mov.l	r3, @-fSP	; Make the symbol at least one char long.
	add 	#-1, r3
	rts
	mov.l	r3, @-fSP	; But keep us stopped at the NUL.
; delimited by NUL
ENCLOSnulterm:
	mov.l	r3, @-fSP	; Delimiter is NUL.
	rts
	mov.l	r3, @-fSP	; No next character included, keep us at the NUL.



