class TreeNode
  include Enumerable

  attr_reader :parent

  def initialize(childs = nil)
    @parent = nil
    @childs = Array.new

    if childs != nil
      childs.each { |child|
        append_child child
      }
    end
  end

  def each
    return to_enum(__method__) unless block_given?

    yield self
    @childs.each do |child|
      child.each do |descendant|
        yield descendant
      end
    end
  end

  def each_child
    return to_enum(__method__) unless block_given?

    @childs.each do |child|
      yield child
    end
  end

  def ancestral_each
    return to_enum(__method__) unless block_given?

    n = self
    until n.is_root?
      yield n
      n = n.parent
    end
    yield n # root node
  end

  def root
    self.enum_for(:ancestral_each).to_a.last
  end

  def is_root?
    @parent == nil
  end

  def has_child?
    @childs.empty?
  end

  def append_child(child)
    child.set_parent self
    @childs.push child
  end

  def set_parent(parent)
    @parent = parent
  end
  protected :set_parent
end
