//
//  MSTypesetter.h
//  Okusa
//
//  Created by 木谷 洋 on 12/03/11.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "_GlyphLocator.h"
#import "_GlyphMetricsLoader.h"
#import "VerticalGlyphLocator.h"
#import "CompiledAttributedString.h"

@interface MSTypesetter : NSObject <_GlyphBufferSpaceDelegate>
{
    __strong _GlyphBufferSpace *bufferSpace;
    VerticalGlyphLocator *glyphLocator;
    
    CGFloat boxSize;
    CFIndex boxCount;
}

@property (readwrite,assign) CFIndex boxCount; // 行辺りの箱数
@property (readwrite,assign) CGFloat boxSize;  // 箱の大きさ

- (NSArray*)linesFromString:(CompiledAttributedString*)aString;
@end
