/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package geom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import arithmetic.BitOperator;

/**
 *
 * @author mtomono
 */
public enum Compass {
    RIGHT,
    LEFT,
    STRAIGHT;

    final static BitOperator op = new BitOperator(4);
    final static int WEST =  1 << 0;
    final static int SOUTH = 1 << 1;
    final static int EAST =  1 << 2;
    final static int NORTH = 1 << 3;
    
    static public Iterable<Integer> clockwise4dirs(int start) {
        return dirs(start, 3);
    }
    
    static public Iterable<Integer> counterclockwise4dirs(int start) {
        return dirs(start, 1);
    }
    
    static Iterable<Integer> dirs(final int start, final int step) {
        assert start < op.max;
        return () -> new Iterator<Integer>() {
            int count = 0;
            int dir = start;
            @Override
            public boolean hasNext() {
                return count < op.range;
            }
            @Override
            public Integer next() {
                if (!hasNext())
                    throw new NoSuchElementException("Dir#fourDirs: gone over the end of iterator");
                int retval = dir;
                dir = rotRightAngles(dir, step);
                count++;
                return retval;
            }
            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
            }
        };
    }
    
    static int x(int dir) {
        return dir & 5; //0101
    }
    
    static int y(int dir) {
        return dir & 10; //1010
    }
    
    static int rotRightAngles(int dir, int n) {
        assert dir < op.max;
        return op.rot(dir, n);
    }
    
    /**
     * when dir is in right angle
     * @param dir
     * @return
     */
    public static int left45(int dir) {
        assert dir < op.max;
        return rot90(dir) | dir;
    }
    
    /**
     * when dir is in between right angle
     * @param dir
     * @return
     */
    public static int left45dash(int dir) {
        assert dir < op.max;
        return rot90(dir) & dir;
    }
    
    static int right45(int dir) {
        assert dir < op.max;
        return rot270(dir) | dir;
    }
    
    static int right45dash(int dir) {
        assert dir < op.max;
        return rot270(dir) & dir;
    }
    
    static public int rot180(int dir) {
        return rotRightAngles(dir, 2);
    }
    
    static public int rot90(int dir) {
        return rotRightAngles(dir, 1);
    }
    
    static public int rot270(int dir) {
        return rotRightAngles(dir, 3);
    }
    
    static public boolean isIn(int criterion, int target) {
        assert criterion < 16;
        assert target < 16;
        return (target & ~criterion) == 0;
    }
}
