﻿using System;
using System.Collections.Generic;
using System.IO;

using Vintagestory.API.Client;
using Vintagestory.API.Common;
using Vintagestory.API.Common.Entities;
using Vintagestory.API.Config;
using Vintagestory.API.MathTools;
using Vintagestory.API.Server;

namespace CarbonCopy
{
	public class CarbonCopyMod : ModSystem
	{

		private ICoreAPI API { get; set; }
		private ICoreServerAPI ServerAPI { get; set; }
		private ICoreClientAPI ClientAPI { get; set; }



		public override bool ShouldLoad(EnumAppSide forSide)
		{
		return forSide.IsClient( );
		}

		public override void StartClientSide(ICoreClientAPI api)
		{
		this.API = api;
		this.ClientAPI = api as ICoreClientAPI;

		if (api.Side == EnumAppSide.Client) {

		ClientAPI.RegisterCommand(new CarbonCopyCommand(ClientAPI));
		Mod.Logger.Notification("Registered Carbon Copy command (export)");
		}

		base.StartClientSide(api);
		}
	}
}


