//
//  KanColleLevelManagerTests.m
//  KanColleLevelManagerTests
//
//  Created by Hori,Masaki on 2013/10/14.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import <XCTest/XCTest.h>

@interface KanColleLevelManagerTests : XCTestCase

@end

@implementation KanColleLevelManagerTests

- (void)setUp
{
    [super setUp];
    // Put setup code here. This method is called before the invocation of each test method in the class.
}

- (void)tearDown
{
    // Put teardown code here. This method is called after the invocation of each test method in the class.
    [super tearDown];
}

//- (void)testExample
//{
//    XCTFail(@"No implementation for \"%s\"", __PRETTY_FUNCTION__);
//}

- (void)testLevel
{
	NSManagedObjectContext *moc = [[NSApp delegate] managedObjectContext];
	XCTAssertNotNil(moc, @"moc is nil");
	
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"Ship"];
	XCTAssertNotNil(req, @"req is nil");
	
	NSPredicate *predicate = [NSPredicate predicateWithFormat:@"number = 1"];
	XCTAssertNotNil(predicate, @"predicate is nil");
	
	[req setPredicate:predicate];
	
	NSArray *fetched = [moc executeFetchRequest:req error:nil];
	XCTAssertNotNil(fetched, @"fetched is nil");
	XCTAssertTrue([fetched count] != 0, @"fetched count is 0");
	
	id ship = [fetched objectAtIndex:0];
	XCTAssertNotNil(ship, @"ship is nil");
	
	id obj = [NSEntityDescription insertNewObjectForEntityForName:@"CollectedShip"
										   inManagedObjectContext:moc];
	XCTAssertNotNil(obj, @"fail insert CollectedShip");
	[obj setValue:[fetched objectAtIndex:0] forKey:@"ship"];
	
	NSNumber *level = nil;
	level = [obj valueForKey:@"level"];
	XCTAssertTrue([level integerValue] == 1, @"level is %@, not is 1 for exp 0", level);
	[obj setValue:[NSNumber numberWithInteger:1]
		   forKey:@"exp"];
	level = [obj valueForKey:@"level"];
	XCTAssertTrue([level integerValue] == 1, @"level is %@, not is 1 for exp 1", level);
	
	[obj setValue:[NSNumber numberWithInteger:205]
		   forKey:@"exp"];
	level = [obj valueForKey:@"level"];
	XCTAssertTrue([level integerValue] == 2, @"level is %@, not is 2 for exp 205", level);
	
	[obj setValue:[NSNumber numberWithInteger:1000]
		   forKey:@"exp"];
	level = [obj valueForKey:@"level"];
	XCTAssertTrue([level integerValue] == 5, @"level is %@, not is 5 for exp 1000", level);
	[obj setValue:[NSNumber numberWithInteger:1001]
		   forKey:@"exp"];
	level = [obj valueForKey:@"level"];
	XCTAssertTrue([level integerValue] == 5, @"level is %@, not is 5 for exp 1001", level);
	
	
	[obj setValue:[NSNumber numberWithInteger:122499]
		   forKey:@"exp"];
	level = [obj valueForKey:@"level"];
	XCTAssertTrue([level integerValue] == 49, @"level is %@, not is 49 for exp 122499", level);
	
	[obj setValue:[NSNumber numberWithInteger:122500]
		   forKey:@"exp"];
	level = [obj valueForKey:@"level"];
	XCTAssertTrue([level integerValue] == 50, @"level is %@, not is 50 for exp 122500", level);
	
	[obj setValue:[NSNumber numberWithInteger:122501]
		   forKey:@"exp"];
	level = [obj valueForKey:@"level"];
	XCTAssertTrue([level integerValue] == 50, @"level is %@, not is 50 for exp 4901", level);
	
	
}


- (void)testResentExp
{
	NSManagedObjectContext *moc = [[NSApp delegate] managedObjectContext];
	XCTAssertNotNil(moc, @"moc is nil");
	
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"Ship"];
	XCTAssertNotNil(req, @"req is nil");
	
	NSPredicate *predicate = [NSPredicate predicateWithFormat:@"number = 1"];
	XCTAssertNotNil(predicate, @"predicate is nil");
	
	[req setPredicate:predicate];
	
	NSArray *fetched = [moc executeFetchRequest:req error:nil];
	XCTAssertNotNil(fetched, @"fetched is nil");
	XCTAssertTrue([fetched count] != 0, @"fetched count is 0");
	
	id ship = [fetched objectAtIndex:0];
	XCTAssertNotNil(ship, @"ship is nil");
	
	id obj = [NSEntityDescription insertNewObjectForEntityForName:@"CollectedShip"
										   inManagedObjectContext:moc];
	XCTAssertNotNil(obj, @"fail insert CollectedShip");
	[obj setValue:[fetched objectAtIndex:0] forKey:@"ship"];
	
	
	//
	NSNumber *resentExp = nil;
	[obj setValue:[NSNumber numberWithInteger:90]
		   forKey:@"exp"];
	resentExp = [obj valueForKey:@"nextLevelExp"];
	XCTAssertTrue([resentExp integerValue] == 10, @"resent Exp is %@, not is 10 for exp 90", resentExp);
	
	[obj setValue:[NSNumber numberWithInteger:122499]
		   forKey:@"exp"];
	resentExp = [obj valueForKey:@"nextLevelExp"];
	XCTAssertTrue([resentExp integerValue] == 1, @"resent Exp is %@, not is 1 for exp 122499", resentExp);
}

@end
