//
//  KCStatusCheckWindowController.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2014/02/02.
//  Copyright (c) 2014年 Hori,Masaki. All rights reserved.
//

#import "KCStatusCheckWindowController.h"

#import "HMAppDelegate.h"


@interface KCStatusCheckWindowController ()


@property (retain) NSDictionary *categoryList;

@end

@implementation KCStatusCheckWindowController

- (id)init
{
    self = [super initWithWindowNibName:NSStringFromClass([self class])];
    if (self) {
        // Initialization code here.
		
		NSString *path = [[NSBundle mainBundle] pathForResource:@"Category" ofType:@"plist"];
		_categoryList = [NSDictionary dictionaryWithContentsOfFile:path];
		
	}
    return self;
}

- (NSUndoManager *)windowWillReturnUndoManager:(NSWindow *)window
{
	return self.managedObjectContext.undoManager;
}

- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}

- (IBAction)selectCategory:(id)sender
{
	NSPredicate *predicate = nil;
	NSInteger segment = [sender selectedSegment];
	NSString *label = [sender labelForSegment:segment];
	
	NSDictionary *types = [self.categoryList objectForKey:label];
	if(types) {
		predicate = [NSPredicate predicateWithFormat:@"ship.type.name IN %@", types];
	}
	
	[self.collectionShip setFetchPredicate:predicate];
}

@end
