/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka & Katsumi
   http://www.ze.em-net.ne.jp/~kenken/index.html
   http://hp.vector.co.jp/authors/VA016157/
*/

#include <xc.h>
#include "./main.h"
#include "./compiler.h"

void _general_exception_handler (void){
	g_ex_data[0]=1;                 // Exception occured
	g_ex_data[1]=g_s6;              // g_s6
	asm volatile("la $v0,%0"::"i"(&g_ex_data));
	asm volatile("lw $v1,0($v0)");  // $s6
	asm volatile("sw $s6,8($v1)");  // $s6
	asm volatile("mfc0 $v0,$13");
	asm volatile("sw $v0,12($v1)"); // Cause
	asm volatile("mfc0 $v0,$14");
	asm volatile("sw $v0,16($v1)"); // EPC
	asm volatile("j 0x9D007000");
}

void blue_screen(void){
	int i,j,s6,s6g;
	unsigned int* opos;
	if (RCONbits.POR || RCONbits.EXTR) {
		// After power on or reset. Reset flags and return.
		RCONbits.POR=0;
		RCONbits.EXTR=0;
		g_ex_data[0]=0;
		return;
	} else if (g_ex_data[0]==0) {
		// No exception found.
		return;
	}
	// Exception occured before SoftReset().
	// Prepare data
	s6=g_ex_data[2];
	s6g=g_ex_data[1];
	if (s6<0) s6=0-s6;
	if (s6g<0) s6g=0-s6g;
	opos=(int*)g_ex_data[4];
	//set_bgcolor(255,0,0);
	printstr("STOP");
	printstr("\nException at ");
	printhex32(g_ex_data[4]);
	printstr("\n      Cause: ");
	printhex32(g_ex_data[3]);
	printstr("\n ");
	switch((g_ex_data[3]>>2)&0x1f){
		case 0:  printstr("(Interrupt)"); break;
		case 1:  printstr("(TLB modification)"); break;
		case 2:  printstr("(TLB load/fetch)"); break;
		case 3:  printstr("(TLB store)"); break;
		case 4:  printstr("(Address load/fetch error )"); break;
		case 5:  printstr("(Address store error)"); break;
		case 6:  printstr("(Bus fetch error)"); break;
		case 7:  printstr("(Bus load/store error)"); break;
		case 8:  printstr("(Syscall)"); break;
		case 9:  printstr("(Breakpoint)"); break;
		case 10: printstr("(Reserved instruction)"); break;
		case 11: printstr("(Coprocessor Unusable)"); break;
		case 12: printstr("(Integer Overflow)"); break;
		case 13: printstr("(Trap)"); break;
		case 23: printstr("(Reference to Watch address)"); break;
		case 24: printstr("(Machine check)"); break;
		default: printstr("(Unknown)"); break;
	}
	printstr("\n         s6: ");
	printstr(resolve_label(s6));
	printstr("\n       g_s6: ");
	printstr(resolve_label(s6g));
	printstr("\n");
	printstr("Reset MachiKania to contine.\n\n");
	// Show code where the exception happened.
	for(i=-3;i<=3;i++){
		printstr("\n ");
		printhex32((unsigned int)&opos[i]);
		printstr("  ");
		if (   0xA0000000<=(unsigned int)&opos[i] && (unsigned int)&opos[i]<0xA0000000+PIC32MX_RAMSIZE
			|| 0x9D000000<=(unsigned int)&opos[i] && (unsigned int)&opos[i]<=0x9D000000+PIC32MX_FLASHSIZE) {
			printhex32(opos[i]);
		} else {
			printstr("********");
		}
	}
	printstr("\n");
	while(1);
}
