﻿Imports Microsoft.VisualBasic
Imports System
Imports System.Collections
Imports SFDCService

Public Class Client
    Private _binding As SforceServiceCompressed
    Private _username As String
    Private _password As String
    Private _host As String
    Private _querySize As Integer
    Private _sessionlength As Integer
    Private _sessionId As String
    Private _serverURL As String
    Private _nextLoginTime As DateTime
    'プライベートクラス変数を初期化する 
    Sub New()
        Me._binding = New SforceServiceCompressed
        Me._querySize = 500
        Me._sessionlength = 29
        Me._host = "https://www.salesforce.com/services/Soap/u/10.0"
    End Sub

    '呼び出し関数に対して変数を公開する
    Public Property username() As String
        '呼び出しクラスに対して値の取得を許可する
        Get
            Return Me._username
        End Get
        '呼び出しクラスに対して値の設定を許可する
        Set(ByVal Value As String)
            Me._username = Value
        End Set
    End Property

    Public Property password() As String
        Get
            Return Me._password
        End Get
        Set(ByVal Value As String)
            Me._password = Value
        End Set
    End Property

    Public Property host() As String
        Get
            Return Me._host
        End Get
        Set(ByVal Value As String)
            Me._host = Value
        End Set
    End Property

    Public ReadOnly Property serverURL() As String
        Get
            Return Me._serverURL
        End Get
    End Property

    Public Property querySize() As Integer
        Get
            Return Me._querySize
        End Get
        Set(ByVal Value As Integer)
            Me._querySize = Value
        End Set
    End Property

    Public Property sessionlength() As Integer
        Get
            Return Me._sessionlength
        End Get
        Set(ByVal Value As Integer)
            Me._sessionlength = Value
        End Set
    End Property

    'プロキシサーバの場合...
    Public Property proxy() As System.Net.WebProxy
        Get
            Return Me._binding.Proxy
        End Get
        Set(ByVal Value As System.Net.WebProxy)
            Me._binding.Proxy = Value
        End Set
    End Property
    ' SOAP メッセージを圧縮する
    Public Property useCompression() As Boolean
        Get
            Return Me._binding.AcceptCompressedResponse()
        End Get
        Set(ByVal Value As Boolean)
            Me._binding.AcceptCompressedResponse = Value
            Me._binding.SendCompressedRequest = Value
        End Set
    End Property

    Public Sub Login()
        Dim lr As LoginResult
        Me._binding.Url = Me._host
        lr = Me._binding.login(username, password)
        Me._nextLoginTime = Now().AddMinutes(Me.sessionlength)
        'SOAP エンドポイントを返されたサーバ URL にリセットする
        Me._binding.Url = lr.serverUrl
        Me._binding.SessionHeaderValue = New SFDCService.SessionHeader
        Me._binding.SessionHeaderValue.sessionId = lr.sessionId
        Me._sessionId = lr.sessionId
        Me._serverURL = lr.serverUrl
    End Sub

    Public Sub loginBySessionId(ByVal sid As String,
    ByVal sURL As String)
        Me._nextLoginTime = Now().AddMinutes(Me.sessionlength)
        Me._binding.Url = sURL
        Me._binding.SessionHeaderValue = New SFDCService.SessionHeader
        Me._binding.SessionHeaderValue.sessionId = sid
        Me._sessionId = sid
        Me._serverURL = sURL
    End Sub

    Public Function isConnected() As Boolean
        If _sessionId <> "" And _sessionId <> Nothing Then
            If Now() > Me._nextLoginTime Then
                isConnected = False
            End If
            isConnected = True
        Else
            isConnected = False
        End If
    End Function

    Private Function loginRequired() As Boolean
        loginRequired = Not (isConnected())
    End Function

    Public Function executeQuery(ByVal strSOQLStmt As String, Optional ByVal queryBatchSize As Integer = -1) As sForce.QueryResult
        If queryBatchSize = -1 Then
            queryBatchSize = _querySize
        End If
        If (Me.loginRequired()) Then
            Login()
        End If
        _binding.QueryOptionsValue = New SFDCService.QueryOptions
        _binding.QueryOptionsValue.batchSizeSpecified = True
        _binding.QueryOptionsValue.batchSize = queryBatchSize
        '       executeQuery = _binding.query(strSOQLStmt)
    End Function

    'Public Function executeQueryMore(ByVal queryLocator As String) As sForce.QueryResult
    '    If loginRequired() Then Login()
    '    Return _binding.queryMore(queryLocator)
    'End Function

    Public Sub setAssignmentRuleHeaderId(ByVal ruleId As String)
        _binding.AssignmentRuleHeaderValue =
        New AssignmentRuleHeader
        _binding.AssignmentRuleHeaderValue.assignmentRuleId = ruleId
    End Sub
    Public Sub setAssignmentRuleHeaderToDefault(
    ByVal runDefaultRule As Boolean)
        _binding.AssignmentRuleHeaderValue = New AssignmentRuleHeader
        _binding.AssignmentRuleHeaderValue.useDefaultRule =
        runDefaultRule
    End Sub

    Public ReadOnly Property Binding() As SFDCService.SforceService
        Get
            Return _binding
        End Get
    End Property

    Public Function create(ByVal records() As sForce.sObject, Optional ByVal batchSize As Integer = 200) As sForce.SaveResult()
        Return batch(records, batchSize, New CreateBatcher)
    End Function
    Public Function update(ByVal records() As sForce.sObject, Optional ByVal batchSize As Integer = 200) As sForce.SaveResult()
        Return batch(records, batchSize, New UpdateBatcher)
    End Function

    Private Function batch(ByVal records() As sForce.sObject, ByVal batchSize As Integer, ByVal oper As Batcher) As sForce.SaveResult()
        If (records.Length <= batchSize) Then
            batch = oper.perform(Binding, records)
            Exit Function
        End If


        Dim saveResults(records.Length - 1) As sForce.SaveResult
        Dim thisBatch As sForce.sObject()
        Dim pos As Integer = 0
        Dim thisBatchSize As Integer
        While (pos < records.Length)
            thisBatchSize = Math.Min(batchSize,
            records.Length - pos)
            ReDim thisBatch(thisBatchSize)
            System.Array.Copy(records, pos, thisBatch,
            0, thisBatchSize)
            Dim sr As sForce.SaveResult() =
            oper.perform(Binding, thisBatch)
            System.Array.Copy(sr, 0, saveResults, pos, thisBatchSize)
            pos += sr.Length
        End While
        batch = saveResults
    End Function

    Private Class Batcher
        Public Function perform(ByVal binding As SFDCService.SforceService, ByVal records As sForce.sObject()) As sForce.SaveResult()
            perform = Nothing
        End Function
    End Class

    Private Class CreateBatcher
        Inherits Batcher
        Public Overloads Function perform(ByVal binding As SFDCService.SforceService, ByVal records As sForce.sObject()) As sForce.SaveResult()
            '          perform = binding.create(records)
        End Function
    End Class

    Private Class UpdateBatcher
        Inherits Batcher
        Public Overloads Function perform(ByVal binding As SFDCService.SforceService, ByVal records As sForce.sObject()) As sForce.SaveResult()
            '           perform = binding.update(records)
        End Function
    End Class
End Class
