﻿Imports System.Text

Public Class FrmKarty
    Public sDtKart As DataTable
    Public id As String
    Public sBinding As SoapCliantControl
    Public LocalPosition As Point

    Private DsListdata As DataSet

    Private Sub BtnCan_Click(sender As System.Object, e As System.EventArgs) Handles BtnCan.Click
        Dim Drv As DataRowView = CType(Me.BindingContext(sDtKart).Current, DataRowView)
        Dim dr As DataRow = Drv.Row
        If dr.RowState <> DataRowState.Unchanged Then
            If MessageBox.Show("案件が更新されています。破棄しますか？", "確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = Windows.Forms.DialogResult.Yes Then
                '変更を破棄します
                Me.BindingContext(sDtKart).CancelCurrentEdit()
                '新規作成したものはキャンセルできないので、自前で削除する
                'Dim Drv As DataRowView = CType(Me.BindingContext(sDtKart).Current, DataRowView)
                '前画面から指定ないなら新規行なので削除
                'If id = "" Then
                '    Me.BindingContext(sDtKart).RemoveAt(Me.BindingContext(sDtKart).Position)
                'End If
                Me.DialogResult = Windows.Forms.DialogResult.Cancel
            End If
        Else
            Me.DialogResult = Windows.Forms.DialogResult.Cancel
        End If
    End Sub

    Private Sub BtnOK_Click(sender As System.Object, e As System.EventArgs) Handles BtnOK.Click
        '変更を確定します
        Dim id As String
        ShowFrmProginfo()
        Application.UseWaitCursor = True
        Me.BindingContext(sDtKart).EndCurrentEdit()
        ' sDtKart.WriteXml("test.xml", XmlWriteMode.WriteSchema)
        id = Save(sDtKart, sBinding)
        If Not id = "" Then
            sDtKart.AcceptChanges()
        Else
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            Me.DialogResult = Windows.Forms.DialogResult.Abort
            Exit Sub
        End If
        Application.UseWaitCursor = False
        FrmProgInfo.Close()
        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub ControlBind()
        Try
            '------------コントロールバインド情報の消去
            DTPIrai.DataBindings.Clear()
            txtCustName.DataBindings.Clear()
            txtID.DataBindings.Clear()
            txtLot.DataBindings.Clear()
            txtIrai_Staff.DataBindings.Clear()
            txtCnt.DataBindings.Clear()
            txtOneTime.DataBindings.Clear()
            CbType.DataBindings.Clear()
            CbKind.DataBindings.Clear()
            CkRental.DataBindings.Clear()
            CbAppleID.DataBindings.Clear()
            CbFraud.DataBindings.Clear()
            CbSTS.DataBindings.Clear()
            TxtMemo.DataBindings.Clear()
            CkHold.DataBindings.Clear()
            DTPAu.DataBindings.Clear()
            DTPDelivaly.DataBindings.Clear()
            TxtStaff.DataBindings.Clear()
            CbPlace.DataBindings.Clear()
            CkStore.DataBindings.Clear()
            CkTssc.DataBindings.Clear()
            TxtWorkMemo.DataBindings.Clear()
            TxtControl_staff.DataBindings.Clear()
            cbmithumori.DataBindings.Clear()
            cbmothikomi.DataBindings.Clear()

            txtsetCnt.DataBindings.Clear()
            txtErrorhour.DataBindings.Clear()
            txtVerifyhour.DataBindings.Clear()
            cbDifficalRank.DataBindings.Clear()
            DTPyotei.DataBindings.Clear()
            txtyoteihour.DataBindings.Clear()
            DTPworkStartDay.DataBindings.Clear()
            'txtresultshour.DataBindings.Clear()
            'DsList.Clear()
            '---------コントロールバインド
            txtCustName.DataBindings.Add(New Binding("text", sDtKart, "name"))   '案件
            txtID.DataBindings.Add(New Binding("text", sDtKart, "id")) 'ID(SalesForce PK)
            txtLot.DataBindings.Add(New Binding("text", sDtKart, "LOT__c"))   'ロット
            txtIrai_Staff.DataBindings.Add(New Binding("text", sDtKart, "irai_staff__c"))    '依頼者
            txtCnt.DataBindings.Add(New Binding("text", sDtKart, "Cnt__c"))  '台数
            txtOneTime.DataBindings.Add(New Binding("text", sDtKart, "onePermin__c"))   '工数
            TxtControl_staff.DataBindings.Add(New Binding("text", sDtKart, "operate_t_staff__c"))   '手順書担当者
            TxtMemo.DataBindings.Add(New Binding("text", sDtKart, "memo__c"))    '特記事項
            TxtStaff.DataBindings.Add(New Binding("text", sDtKart, "anken_staff__c"))  '案件担当
            txtsetCnt.DataBindings.Add(New Binding("text", sDtKart, "setcnt__c"))  '設定数
            txtErrorhour.DataBindings.Add(New Binding("text", sDtKart, "errorhour__c"))  'エラー工数
            txtVerifyhour.DataBindings.Add(New Binding("text", sDtKart, "verifyhour__c"))  '検証工数
            txtyoteihour.DataBindings.Add(New Binding("text", sDtKart, "yoteihour__c"))  '予定工数
            'txtresultshour.DataBindings.Add(New Binding("text", sDtKart, "resultshour__c"))  '実績工数
            TxtWorkMemo.DataBindings.Add(New Binding("text", sDtKart, "workmemo__c")) '作業メモ

            CkRental.DataBindings.Add(New Binding("checked", sDtKart, "rental_flg__c"))    'レンタル
            'CbFraud.DataBindings.Add(New Binding("text", sDtKart, "Fraud_Check__c")) 'フラウド
            CkHold.DataBindings.Add(New Binding("checked", sDtKart, "plan_hold__c"))    '日程確保
            CkStore.DataBindings.Add(New Binding("checked", sDtKart, "store_flg__c"))   '手順書格納
            CkTssc.DataBindings.Add(New Binding("checked", sDtKart, "TSSC_store_flg__c")) 'TSSC格納
            chkAM.DataBindings.Add(New Binding("checked", sDtKart, "AM__c")) 'AM指定
            CKYet.DataBindings.Add(New Binding("checked", sDtKart, "Delivery_Day_yet__c")) '納品日未定
            CKFin.DataBindings.Add(New Binding("checked", sDtKart, "fin_flg__c")) '調整完了
            CKError.DataBindings.Add(New Binding("checked", sDtKart, "error_exists_flg__c")) 'エラー有
            Ckigure.DataBindings.Add(New Binding("checked", sDtKart, "irregular_exists_flg__c")) '例外定

            '日付型にNULLがあるとバインドエラー
            DTPIrai.DataBindings.Add(New Binding("text", sDtKart, "irai__c"))    '依頼日
            DTPAu.DataBindings.Add(New Binding("text", sDtKart, "auEntry_Day__c"))  'AU登録日
            DTPDelivaly.DataBindings.Add(New Binding("text", sDtKart, "Delivery_Day__c"))    '納品日
            DTPyotei.DataBindings.Add(New Binding("text", sDtKart, "work_Day__c"))   '作業予定日
            DTPworkStartDay.DataBindings.Add(New Binding("text", sDtKart, "resultsDay__c")) '作業開始

            '------コンボリストのバインド
            '作業場所
            CbPlace.DataSource = DsListdata.Tables("WORK")
            CbPlace.DisplayMember = "label"
            CbPlace.ValueMember = "val"
            CbPlace.DataBindings.Add("selectedvalue", sDtKart, "work_place_Team__c")

            '状態
            CbSTS.DataSource = DsListdata.Tables("ST")
            CbSTS.DisplayMember = "label"
            CbSTS.ValueMember = "val"
            CbSTS.DataBindings.Add("selectedvalue", sDtKart, "Status__c")
            'CbSTS.DataBindings.Add("text", sDtKart, "lot")

            'AppleID種別
            CbAppleID.DataSource = DsListdata.Tables("APP")
            CbAppleID.DisplayMember = "label"
            CbAppleID.ValueMember = "val"
            CbAppleID.DataBindings.Add("selectedvalue", sDtKart, "AppleID_kind__c")

            '機種
            CbType.DataSource = DsListdata.Tables("TYPE")
            CbType.DisplayMember = "label"
            CbType.ValueMember = "val"
            CbType.DataBindings.Add("selectedvalue", sDtKart, "Type__c")

            '契約種別
            CbKind.DataSource = DsListdata.Tables("KIND")
            CbKind.DisplayMember = "label"
            CbKind.ValueMember = "val"
            CbKind.DataBindings.Add("selectedvalue", sDtKart, "contract_kind__c")

            'フラウド
            CbFraud.DataSource = DsListdata.Tables("FD")
            CbFraud.DisplayMember = "label"
            CbFraud.ValueMember = "val"
            CbFraud.DataBindings.Add("selectedvalue", sDtKart, "Fraud_Check__c")

            '持込/留置
            cbmothikomi.DataSource = DsListdata.Tables("A")
            cbmothikomi.DisplayMember = "label"
            cbmothikomi.ValueMember = "val"
            cbmothikomi.DataBindings.Add("selectedvalue", sDtKart, "motikomi_tomeoki_flg__c")

            '見積
            cbmithumori.DataSource = DsListdata.Tables("FD").Copy
            cbmithumori.DisplayMember = "label"
            cbmithumori.ValueMember = "val"
            cbmithumori.DataBindings.Add("selectedvalue", sDtKart, "mitumori__c")

            '難易度
            cbDifficalRank.DataSource = DsListdata.Tables("DIFF")
            cbDifficalRank.DisplayMember = "label"
            cbDifficalRank.ValueMember = "val"
            cbDifficalRank.DataBindings.Add("selectedvalue", sDtKart, "difficalRank__c")

        Catch ex As Exception
            MessageBox.Show(ex.Message, "ControlBind", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    Private Sub FrmKarty_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        Dim DB As New CustDB
        'Dim Dr As DataRow()
        Dim bind As BindingManagerBase = Me.BindingContext(sDtKart)
        AddHandler bind.DataError, AddressOf Bind_dataerror

        DsListdata = DB.GetListData()
        DsListdata = MakeListData(DsListdata)

        If LocalPosition.IsEmpty Then
            Me.StartPosition = FormStartPosition.CenterParent
        Else
            Me.StartPosition = FormStartPosition.Manual
            Me.Location = LocalPosition
        End If

        ControlBind()
        '新規か変更か
        If id <> "" Then
            'Dr = sDtKart.Select("id = '" & id & "'")
            'データテーブル内とBindingContextの位置が異なる対応
            'BindingContext内を走査してみる
            For i As Integer = 0 To bind.Count - 1
                bind.Position = i
                Dim drv As DataRowView = CType(bind.Current, DataRowView)
                Dim bdr As DataRow = drv.Row
                '同じならそこを位置
                If id = bdr("id") Then
                    Exit For
                End If
            Next
            'bind.Position = sDtKart.Rows.IndexOf(Dr(0))
        Else
        End If
    End Sub


    Private Sub Bind_dataerror(sender As Object, e As BindingManagerDataErrorEventArgs)

        MessageBox.Show(e.Exception.Message, "バインドエラー", MessageBoxButtons.OK, MessageBoxIcon.Error)

    End Sub


    '数値のみの入力制御
    Private Sub Text_KeyPress(sender As Object, e As System.Windows.Forms.KeyPressEventArgs) Handles txtCnt.KeyPress, _
                                                                                                txtOneTime.KeyPress, _
                                                                                                txtsetCnt.KeyPress, _
 _
                                                                                                txtVerifyhour.KeyPress, _
                                                                                                txtyoteihour.KeyPress
        '数値と「.」のみ
        If (Not (Char.IsDigit(e.KeyChar) Or Char.IsControl(e.KeyChar) Or (e.KeyChar = Chr(46)))) Then

            e.Handled = True
        End If
    End Sub

End Class