﻿Imports System.Windows.Forms.WebBrowser
Imports Microsoft.VisualBasic.FileIO

Public Class Main
    Public StopFlg As Boolean '停止用フラグ
    Dim DtCSv As New DataTable  'CSV読み込み用データテーブル
    Dim idx As Integer  'データテーブルの現在idx
    Dim MAXidx As Integer   '取得最大件数（表示用）
    Dim rowidx As Integer
    'WEBページ非同期処理待機用フラグ
    Dim ContOK As Boolean = False
 

    Private Sub Main_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '組み込みブラウザのIEバージョン変更
        Dim myreg As New RegistryControl
        myreg.SetBrowberChange("AAE")

        'ヴァージョンを表示
        LblVer.Text = Application.ProductVersion
        Me.Text = Me.Text & "(Ver." & Application.ProductVersion & ")"

    End Sub

    Private Sub main()
        '読み込んだCSVの全行を対象にする
        'ただし途中で再開をさせるため、msgがNULLのものだけ

        For Each row As DataRow In DtCSv.Rows
            '中止おされたか？
            If Not StopFlg Then
                ContOK = False
                idx += 1
                rowidx = row(16) '行番号取り出し
                DisplayControl(Trim(row(0).ToString), Trim(row(2).ToString))
                DisplayCnt(idx.ToString)
                AppleLogin_main()
                'End If
            Else
                MessageBox.Show("処理を中止しました。" & vbCrLf & "再開を行うには、再開を押してください", "中止しました", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                BtnRun.Enabled = True
                BtnRun.Text = "再開"
                Exit Sub
            End If
        Next
        MessageBox.Show("終了しました" & vbCrLf & Now.ToString, "終了しました", MessageBoxButtons.OK, MessageBoxIcon.Information)
        BtnRun.Enabled = True
        BtnRun.Text = "実行"
        PicLoad.Visible = False
    End Sub

    Private Sub AppleLogin_main()
        'Dim AppleIDURL As String = "https://appleid.apple.com/cgi-bin/WebObjects/MyAppleId.woa/wa/directToSignIn?localang=ja_JP"
        Dim AppleIDURL As String = "https://appleid.apple.com/"
        'Dim AppleIDURL As String = "https://appleid.apple.com/cgi-bin/WebObjects/MyAppleId.woa/198/wa/directToSignIn?wosid=eHKH3b53hLcMJI47Xs6gDM&localang=ja_JP"

        Dim elem As HtmlElement
        '--DEBUG--
        'HTTPSなのでプロキシ経由できない（＞＜）
        'Dim Proxy As New useProxy
        'Proxy.InternetOptionProxy(useProxy.InternetOpenType.INTERNET_OPEN_TYPE_PROXY, Proxy.getProxyAddress, "")
        '--DEBUG--

        WebBrowser1.Navigate(AppleIDURL)
        Application.DoEvents()
        '読み込み終了になるまで監視する
        'ページ遷移を待機
        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            Application.DoEvents()
        End While

        For Each elem In WebBrowser1.Document.GetElementsByTagName("A")
            If elem.GetAttribute("className") = "bigblue full-width-button" Then
                elem.InvokeMember("click")
                Application.DoEvents()
                Exit For
            End If
        Next

        'ページ遷移を待機
        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            Application.DoEvents()
        End While
        WebBrowser1_AppleIDLoginPageDocumentCompleted()
    End Sub

    '現在のメールボックスとアップルIDの表示
    Private Sub DisplayControl(ByVal argMailId As String, ByVal argAppleId As String)
        'LblAppleID.Text = argAppleId
        LblMailID.Text = argMailId
    End Sub

    Private Sub DisplayCnt(ByVal nowcnt As String)
        txtNowCnt.Text = nowcnt & "/" & MAXidx.ToString
    End Sub


    'AppleID確認ページ
    Private Sub WebBrowser1_AppleIDLoginPageDocumentCompleted()
        '正常の場合AppleID、とパスワードの入力が可能なので「GetElementsByID」でエレメントを取り出してみる
        'もし、エレメントが取り出せない場合は、異常なので、エラーを取り出すことを試みる
        'ページの構造が変わったら、その都度解析しなければならない
        Dim elem As HtmlElement
        Dim str As String
        Dim chk2 As String = "Apple ID またはパスワード"
        Const AppleIDERR As String = "入力された Apple ID またはパスワードが正しくありません。"
        Dim chk3 As String = "Apple ID は無効になっています"
        Const AppleIDCLOSE As String = "この Apple ID は無効になっています"

        '■AppleIDログインページ
        elem = WebBrowser1.Document.GetElementById("accountname")
        If Not IsNothing(elem) Then
            Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)

            'AppleID
            elem.SetAttribute("value", Trim(drCsv(0).ToString))
            Application.DoEvents()

            Try
                'AppleIDパスワード
                elem = WebBrowser1.Document.GetElementById("accountpassword")
                elem.SetAttribute("value", Trim(drCsv(1).ToString))
                Application.DoEvents()
            Catch ex As Exception
                drCsv(14) = "ページ遷移が不安定のためスキップ"
                drCsv(15) = 1
                Exit Sub
            End Try

            elem = WebBrowser1.Document.GetElementById("bot-nav").Children(0)

            If elem.TagName = "A" Then
                AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted
                elem.InvokeMember("click")
                Application.DoEvents()

            End If

            Application.DoEvents()

            While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                Application.DoEvents()
            End While

            ' AppleIDかパスワードがエラーの場合の対応()
            'エラーがあるならエラーテキストを取り出して終了()
            If InStr(WebBrowser1.Document.Body.InnerText, chk2) > 0 Then
                drCsv(14) = AppleIDERR
                drCsv(15) = 1
            ElseIf InStr(WebBrowser1.Document.Body.InnerText, chk3) > 0 Then
                drCsv(14) = AppleIDCLOSE
                drCsv(15) = 1
            Else
                '正常終了→次ページへ
                ' WebBrowser1_GetAppleIDLastPageDocumentCompleted()
            End If
            ContOK = True
            DtCSv.AcceptChanges()

            'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted
            'Application.DoEvents()
        Else
            'エラー
            Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
            'Dim drCsv As DataRow = DtCSv.Select("msg=''")(idx - 1)
            Try
                str = WebBrowser1.Document.GetElementById("intro").InnerText
                drCsv(14) = str
                drCsv(15) = 1
                ContOK = True
                DtCSv.AcceptChanges()
            Catch ex As Exception
                MessageBox.Show("セッションが期限切れです。画面内の右下から再送ボタンを押してください", "セッション期限切れ", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                StopFlg = True
            End Try
            'MessageBox.Show(str)
            'エラーならここで終了
        End If

        '永久ループ
        Do Until ContOK
            Application.DoEvents()
        Loop

    End Sub

    'AppleID確認ページ専用
    Private Sub WebBrowser1_GetAppleIDLastPageDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
        '2014/07/07 MyAppleIDの内部タグ変更に伴う修正
        'Private Sub WebBrowser1_GetAppleIDLastPageDocumentCompleted()
        'MessageBox.Show("Webページの読み込みが完了しました！")

        Dim elem As HtmlElement
        'Dim elemLogout As HtmlElement
        Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
        Dim chk2 As String = "Apple ID またはパスワード"
        Const AppleIDERR As String = "入力された Apple ID またはパスワードが正しくありません。"
        Dim chk3 As String = "Apple ID は無効になっています"
        Const AppleIDCLOSE As String = "この Apple ID は無効になっています"

        RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted

        'AppleIDかパスワードがエラーの場合の対応
        'エラーがあるならエラーテキストを取り出して終了
        If InStr(WebBrowser1.Document.Body.InnerText, chk2) > 0 Then
            drCsv(14) = AppleIDERR
            drCsv(15) = 1
        ElseIf InStr(WebBrowser1.Document.Body.InnerText, chk3) > 0 Then
            drCsv(14) = AppleIDCLOSE
            drCsv(15) = 1

        End If
        DtCSv.AcceptChanges()

        Try
            '名前 姓（漢字）
            drCsv(2) = WebBrowser1.Document.GetElementById("lastName").GetAttribute("value")
            '名（漢字）
            drCsv(3) = WebBrowser1.Document.GetElementById("firstName").GetAttribute("value")
            '姓（カタカナ）
            drCsv(4) = WebBrowser1.Document.GetElementById("lastNamePronounce").GetAttribute("value")
            '名（カタカナ）
            drCsv(5) = WebBrowser1.Document.GetElementById("firstNamePronounce").GetAttribute("value")


            '請求先
            'リンクをクリックしてページ解析で取得
            '        elem = WebBrowser1.Document.GetElementById("addressLink")
            Dim elemchild As HtmlElement = Nothing
            '住所をクリック
            elem = WebBrowser1.Document.GetElementById("add")
            elemchild = elem.Children.Item(0)
            AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDAddressPageDocumentCompleted
            elemchild.InvokeMember("click")

            ''    Application.DoEvents()
            ''    'ページ遷移を待機
            ''    While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            ''        Application.DoEvents()
            ''    End While

            ''    '先に都道府県だけを取り出す
            ''    Dim elemAddr As HtmlElement = Nothing
            ''    Dim elemstr As String
            ''    Dim prefname As String

            ''    '県
            ''    For Each elemAddr In WebBrowser1.Document.GetElementsByTagName("DIV")
            ''        'If elemAddr.GetAttribute("className") = "address-info" Then
            ''        If elemAddr.GetAttribute("className") = "left" Then
            ''            '最初の「P」
            ''            elemchild = elemAddr.Children.Item(1)
            ''            elemstr = elemchild.Children.Item(2).InnerHtml
            ''            'elemstr = elemAddr.Children.Item(2).InnerText
            ''            prefname = elemstr.Substring(elemstr.IndexOf(" "))
            ''            drCsv(8) = prefname

            ''            '編集モードにするために、リンクを探す
            ''            '上記「県」の子エレメント内に存在するので、再度、走査してみる
            ''            'pill-buttons
            ''            elemchild = elemAddr.Children.Item(2)
            ''            elemchild.Children(0).InvokeMember("click")

            ''            Exit For
            ''            'ログアウトエレメントを取り出しておく
            ''            'ElseIf elemAddr.GetAttribute("className") = "logo" Then
            ''            '    elemLogout = elemAddr.Children.Item(0)
            ''        End If
            ''    Next

            ''    Application.DoEvents()
            ''    'ページ遷移を待機
            ''    While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            ''        Application.DoEvents()
            ''    End While
            ''    '国籍
            ''    drCsv(6) = WebBrowser1.Document.GetElementById("co-reg").GetAttribute("Value")
            ''    'drCsv(7) = WebBrowser1.Document.GetElementById("company-institution").GetAttribute("Value")
            ''    '郵便番号
            ''    drCsv(7) = WebBrowser1.Document.GetElementById("zip").GetAttribute("Value")
            ''    'drCsv(7) = WebBrowser1.Document.GetElementById("postal-code").GetAttribute("Value")
            ''    '都市
            ''    drCsv(9) = WebBrowser1.Document.GetElementById("to-ci").GetAttribute("Value")
            ''    'drCsv(9) = WebBrowser1.Document.GetElementById("town-city").GetAttribute("Value")
            ''    '住所１
            ''    'drCsv(10) = WebBrowser1.Document.GetElementById("address-1").GetAttribute("Value")
            ''    drCsv(10) = WebBrowser1.Document.GetElementById("addr-l-1").GetAttribute("Value")
            ''    '住所２
            ''    '        drCsv(11) = WebBrowser1.Document.GetElementById("address-2").GetAttribute("Value")
            ''    drCsv(11) = WebBrowser1.Document.GetElementById("addr-l-2").GetAttribute("Value")

            ''    '電話番号をクリック
            ''    '        elem = WebBrowser1.Document.GetElementById("phoneNoLink")
            ''    elem = WebBrowser1.Document.GetElementById("phone-no")
            ''    '        elem.InvokeMember("click")
            ''    elemchild = elem.Children.Item(0)
            ''    elemchild.InvokeMember("click")
            ''    'Application.DoEvents()

            ''    'Application.DoEvents()
            ''    'ページ遷移を待機

            ''    While (WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete)
            ''        Application.DoEvents()
            ''    End While

            ''    '電話１
            ''    ' drCsv(12) = WebBrowser1.Document.GetElementById("dayText1-three").GetAttribute("Value")
            ''    drCsv(12) = WebBrowser1.Document.GetElementById("day-ph").GetAttribute("Value")
            ''    '電話２
            ''    '        drCsv(13) = WebBrowser1.Document.GetElementById("dayText2-three").GetAttribute("Value")
            ''    drCsv(13) = ""

            ''    '一旦住所に戻す
            ''    elem = WebBrowser1.Document.GetElementById("name-email")
            ''    elemchild = elem.Children.Item(0)
            ''    elemchild.InvokeMember("click")
            ''    Application.DoEvents()

            ''    'ページ遷移を待機
            ''    While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            ''        Application.DoEvents()
            ''    End While
        Catch ex As Exception
            drCsv(14) = "未承認の可能性あり。確認してください"
            drCsv(15) = 1
            ContOK = True
        End Try

        ' ''ログアウトしないと途中でURL変更を許可してくれない
        ' ''エレメントを探す
        ''Try

        ''    ''For Each elemAddr In WebBrowser1.Document.GetElementsByTagName("DIV")
        ''    ''    If elemAddr.GetAttribute("className") = "logo" Then
        ''    ''        'elemLogout = DirectCast(elemAddr.Children.Item(0), System.Windows.Forms.HtmlElement).Children(0)
        ''    ''        elemLogout = DirectCast(elemAddr.Children.Item(1), System.Windows.Forms.HtmlElement).Children(1)
        ''    ''        ' elemLogout = elemAddr.Children.Item(0)
        ''    ''        'ログアウト
        ''    ''        If elemLogout.TagName = "A" Then
        ''    ''            elemLogout.InvokeMember("click")
        ''    ''            Application.DoEvents()
        ''    ''            Exit For
        ''    ''        End If
        ''    ''    End If
        ''    ''Next

        ''Catch ex As Exception
        ''    'トップページの場合、エレメントが異なるのでその対応

        ''    'For Each elemAddr In WebBrowser1.Document.GetElementsByTagName("DIV")
        ''    '    If elemAddr.GetAttribute("className") = "logo" Then
        ''    '        elemLogout = DirectCast(elemAddr.Children.Item(0), System.Windows.Forms.HtmlElement).Children(0)
        ''    '        'ログアウト
        ''    '        If elemLogout.TagName = "A" Then
        ''    '            elemLogout.InvokeMember("click")
        ''    '            Application.DoEvents()
        ''    '            Exit For
        ''    '        End If
        ''    '    End If
        ''    'Next
        ''End Try

        'elem = WebBrowser1.Document.GetElementById("signOutLinkID")
        'elem.InvokeMember("click")

        'ページ遷移を待機
        ''While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
        ''    Application.DoEvents()
        ''End While

        'drCsv(2) = str
        'DtCSv.AcceptChanges()
        ' MessageBox.Show(str)
        'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted
    End Sub

    Private Sub WebBrowser1_GetAppleIDAddressPageDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
        RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDAddressPageDocumentCompleted

        '先に都道府県だけを取り出す
        Dim elemAddr As HtmlElement = Nothing
        Dim elemstr As String
        Dim prefname As String
        Dim elemchild As HtmlElement = Nothing
        Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)

        '県
        For Each elemAddr In WebBrowser1.Document.GetElementsByTagName("DIV")
            'If elemAddr.GetAttribute("className") = "address-info" Then
            If elemAddr.GetAttribute("className") = "left" Then
                '最初の「P」
                elemchild = elemAddr.Children.Item(1)
                elemstr = elemchild.Children.Item(2).InnerHtml
                'elemstr = elemAddr.Children.Item(2).InnerText
                prefname = elemstr.Substring(elemstr.IndexOf(" "))
                drCsv(8) = prefname

                '編集モードにするために、リンクを探す
                '上記「県」の子エレメント内に存在するので、再度、走査してみる
                'pill-buttons
                AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDAddress2PageDocumentCompleted
                elemchild = elemAddr.Children.Item(2)
                elemchild.Children(0).InvokeMember("click")

                Exit For
            End If
        Next
        drCsv.AcceptChanges()

        Application.DoEvents()
        'ページ遷移を待機
        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            Application.DoEvents()
        End While
    End Sub

    Private Sub WebBrowser1_GetAppleIDAddress2PageDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
        RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDAddress2PageDocumentCompleted

        Dim elemchild As HtmlElement = Nothing
        Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
        Dim elem As HtmlElement

        '国籍
        drCsv(6) = WebBrowser1.Document.GetElementById("co-reg").GetAttribute("Value")
        '郵便番号
        drCsv(7) = WebBrowser1.Document.GetElementById("zip").GetAttribute("Value")
        '都市
        drCsv(9) = WebBrowser1.Document.GetElementById("to-ci").GetAttribute("Value")
        '住所１
        drCsv(10) = WebBrowser1.Document.GetElementById("addr-l-1").GetAttribute("Value")
        '住所２
        drCsv(11) = WebBrowser1.Document.GetElementById("addr-l-2").GetAttribute("Value")

        '電話番号をクリック
        elem = WebBrowser1.Document.GetElementById("phone-no")
        elemchild = elem.Children.Item(0)
        AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDTELPageDocumentCompleted
        elemchild.InvokeMember("click")
        drCsv.AcceptChanges()
    End Sub

    Private Sub WebBrowser1_GetAppleIDTELPageDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
        RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDTELPageDocumentCompleted
        Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
        Dim elemchild As HtmlElement = Nothing
        Dim elem As HtmlElement
        Dim elemLogout As HtmlElement

        '電話１
        drCsv(12) = WebBrowser1.Document.GetElementById("day-ph").GetAttribute("Value")
        '電話２
        drCsv(13) = ""
        drCsv.AcceptChanges()

        '一旦住所に戻す
        elem = WebBrowser1.Document.GetElementById("name-email")
        elemchild = elem.Children.Item(0)
        elemchild.InvokeMember("click")
        Application.DoEvents()

        'ページ遷移を待機
        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            Application.DoEvents()
        End While

        'ログアウト
        For Each elemAddr In WebBrowser1.Document.GetElementsByTagName("DIV")
            'If elemAddr.GetAttribute("className") = "logo" Then
            If elemAddr.GetAttribute("className") = "logo middle-body" Then
                'elemLogout = DirectCast(elemAddr.Children.Item(0), System.Windows.Forms.HtmlElement).Children(0)
                elemLogout = DirectCast(elemAddr.Children.Item(1), System.Windows.Forms.HtmlElement).Children(1)
                ' elemLogout = elemAddr.Children.Item(0)
                'ログアウト
                If elemLogout.TagName = "A" Then
                    AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLogOutCompleted
                    elemLogout.InvokeMember("click")
                    Application.DoEvents()
                    Exit For
                End If
            End If
        Next

    End Sub

    'ログアウト
    Private Sub WebBrowser1_GetAppleIDLogOutCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
        RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLogOutCompleted
        ContOK = True
    End Sub


    Private Sub BtnRun_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnRun.Click
        'CSV読み込んでいるかチェック
        If DtCSv.Rows.Count = 0 Then
            MessageBox.Show("先に認証用CSVを読み込んでください", "CSVを読み込んでください", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            TabControl1.SelectTab(0)
            Exit Sub
        End If
        '再開か否かの判断
        'メッセージがNULLの件数が０なら初期、それ以外は空白件数
        'If DtCSv.Select("msg<>''").Length = 0 Then
        '    idx = 0
        '    'インデックスの初期値の設定
        MAXidx = DtCSv.Rows.Count
        'MAXidx = DtCSv.Select("msg=''").Length
        'Else
        '    idx = DtCSv.Select("msg<>''").Length
        'End If
        StopFlg = False
        BtnRun.Enabled = False
        BtnStop.Enabled = True
        PicLoad.Visible = True

        main()
    End Sub

    Private Sub BtnStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnStop.Click
        StopFlg = True  '停止フラグ更新
        BtnRun.Enabled = True   '実行ボタンを有効に
        PicLoad.Visible = False '右上画像を非表示に
    End Sub

    'ファイル読み込みボタン
    'すべてを初期化する
    Private Sub btnChoiceFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnChoiceFile.Click
        Dim cnt As Integer
        'ファイルオープンダイアログ表示
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            TxtFilePath.Text = OpenFileDialog1.FileName
            BtnRun.Enabled = True
            BtnRun.Text = "開始"
        Else
            Exit Sub
        End If

        'ファイルをセパレートで一度全部読み込み、データセットへ展開する
        'データテーブルチェック
        If DtCSv.TableName <> "CSV" Then
            DtCSv = CSVtype()
        Else
            DtCSv.Rows.Clear()  'CSV内容全消去
        End If

        Dim drCsv As DataRow
        Dim parser As New TextFieldParser(TxtFilePath.Text)
        parser.TextFieldType = FieldType.Delimited
        parser.SetDelimiters(",") ' 区切り文字はコンマ
        While Not parser.EndOfData
            Dim row As String() = parser.ReadFields() ' 1行読み込み
            cnt += 1
            drCsv = DtCSv.NewRow()  '新規行
            'AppleID
            If row(0) <> "" Then
                drCsv(0) = row(0) 'AppleID
            Else
                cnt = DtCSv.Rows.Count + 1
                MessageBox.Show(cnt.ToString & " 行目のAppleIDが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                TxtFilePath.Text = ""
                Exit Sub
            End If
            'AppleIDパスワード
            If row(1) <> "" Then
                drCsv(1) = row(1) 'AppleIDパスワード
            Else
                cnt = DtCSv.Rows.Count + 1
                MessageBox.Show(cnt.ToString & " 行目のAppleIDパスワードが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                TxtFilePath.Text = ""
                Exit Sub
            End If
            'drCsv(2) = "" 'AppleID認証後のメッセージ格納
            drCsv(16) = cnt    '行数
            DtCSv.Rows.Add(drCsv)   '行追加
        End While
        DtCSv.AcceptChanges()

        'データビューへ設定
        'バインディングは自動
        DGCSV.DataSource = DtCSv
        'DGCSV.DataMember = "CSV"

        '各カラムに対して幅を指定する
        For Each c As DataGridViewColumn In DGCSV.Columns
            Select Case c.Index
                Case 0   'メールアドレス
                    c.Width = 125
                Case 1   'パスワード
                    c.Width = 80
                    c.HeaderText = "パスワード"
                Case 2  '姓（漢字）
                    c.Width = 80
                    c.HeaderText = "姓（漢字）"
                Case 3  '名（漢字）
                    c.Width = 80
                    c.HeaderText = "名（漢字）"
                Case 4  '姓（カタカナ）
                    c.Width = 80
                    c.HeaderText = "姓（カタカナ）"
                Case 5  '名（カタカナ）
                    c.Width = 80
                    c.HeaderText = "名（カタカナ）"
                Case 6  '国籍
                    c.Width = 50
                    c.HeaderText = "国"
                Case 7  '郵便番号
                    c.Width = 75
                    c.HeaderText = "〒"
                Case 8  '県
                    c.Width = 75
                    c.HeaderText = "都道府県"
                Case 9  '都市
                    c.Width = 75
                    c.HeaderText = "市区町村"
                Case 10  '住所１
                    c.Width = 200
                    c.HeaderText = "住所１"
                Case 11  '住所２
                    c.Width = 75
                    c.HeaderText = "住所２"
                Case 12  '電話１
                    c.Width = 50
                    c.HeaderText = "電話１"
                Case 13  '電話２
                    c.Width = 75
                    c.HeaderText = "電話２"
                Case 14  'メッセージ
                    c.Width = 200
                Case 15  'フラグ
                    c.Width = 27
                Case 16  '行数
                    c.Width = 27
            End Select
            'ソートを不可にする
            c.SortMode = DataGridViewColumnSortMode.NotSortable
        Next c

        'ループ用インデックスを初期化
        idx = 0
    End Sub

    'CSV取り込み用データテーブル定義
    Public Function CSVtype() As DataTable
        Dim dtCSV As New DataTable
        With dtCSV
            .Columns.Add("AppleID")         'AppleID0
            .Columns.Add("AppleIDPassword") 'AppleIDパスワード1
            .Columns.Add("lastname")    '姓（漢字）2
            .Columns.Add("firstname")   '名（漢字）3
            .Columns.Add("lastnameProun") '姓（カタカナ）4
            .Columns.Add("firstnameProun") '名（カタカナ）5
            .Columns.Add("countryText") '国籍6
            .Columns.Add("postal") '郵便番号7
            .Columns.Add("state") '県8
            .Columns.Add("city") '市9
            .Columns.Add("address1") '住所１10
            .Columns.Add("address2") '住所２11
            .Columns.Add("tel1") '電話１12
            .Columns.Add("tel2") '電話２13
            .Columns.Add("msg") '14
            .Columns.Add("Error").DefaultValue = 0  'エラー行は１ 15
            .Columns.Add("No")  '行数 16
            .TableName = "CSV"
        End With
        Return dtCSV.Clone
    End Function

    'CSV出力ボタン
    Private Sub BtnOutPut_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnOutPut.Click
        SaveToCsv(DGCSV)
    End Sub

    '保存したいDataGridViewコントロールの名前を引数として
    '設定します。
    Public Sub SaveToCsv(ByVal tempDgv As DataGridView)

        '1行もデータが無い場合は、保存を中止します。
        If tempDgv.Rows.Count = 0 Then
            Exit Sub
        End If

        '変数を定義します。
        Dim i As Integer
        Dim j As Integer
        Dim strFileName As String
        Dim strResult As New System.Text.StringBuilder

        '保存ダイアログでファイル名を設定した場合に処理を実行します。
        If Me.sfdCsvFile.ShowDialog = _
          Windows.Forms.DialogResult.OK Then

            'コラムヘッダを1行目に列記します。
            '※ヘッダ行が不要な場合は削除可能です。
            For i = 0 To tempDgv.Columns.Count - 1
                Select Case i
                    Case 0
                        strResult.Append("""" & _
                        tempDgv.Columns(i).HeaderText.ToString & """")

                    Case tempDgv.Columns.Count - 1
                        strResult.Append("," & """" & _
                        tempDgv.Columns(i).HeaderText.ToString & _
                        """" & vbCrLf)

                    Case Else
                        strResult.Append("," & """" & _
                        tempDgv.Columns(i).HeaderText.ToString & """")
                End Select

            Next

            'データを保存します。
            '※新規行の追加を認めている場合は、次行の「tempDgv.Columns.Count - 1」を
            '「tempDgv.Columns.Count - 2」としてください。
            For i = 0 To tempDgv.Rows.Count - 1
                For j = 0 To tempDgv.Columns.Count - 1
                    Select Case j
                        Case 0
                            strResult.Append("""" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """")

                        Case tempDgv.Columns.Count - 1
                            strResult.Append("," & """" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """" & vbCrLf)

                        Case Else
                            strResult.Append("," & """" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """")
                    End Select

                Next
            Next

            'ファイル名を保存ダイアログで指定した値に設定します。
            strFileName = Me.sfdCsvFile.FileName

            'Shift-JISで保存します。
            Dim swText As New System.IO.StreamWriter(strFileName, _
              False, System.Text.Encoding.GetEncoding(932))
            swText.Write(strResult.ToString)
            swText.Dispose()

        End If

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If DtCSv.TableName <> "CSV" Then
            Exit Sub
        Else
            DtCSv.WriteXml("debug_output.xml", XmlWriteMode.WriteSchema)
            MessageBox.Show("デバック用XML出力した！！")
        End If
    End Sub


End Class

