package jp.co.jmas.pdfviewer.kaito;

import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicLong;
import android.util.Log;

import java.io.IOException;
import java.io.InputStream;

import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;

public class MuPDFTimer {
    private static LocalSocket mLocalSocket = null;

    private Thread looper=null;
    private long interval=0;
	private boolean onPauseFlag = false;
	private long interval_time = 0;
    private AtomicLong updated = new AtomicLong();
	private int i = 0;
    private class Looper implements Runnable{
		public void run() {
			updated.set(System.currentTimeMillis());
			while(true){
				try{
					long lastUpdated = updated.get();
					
					long current = System.currentTimeMillis();
					//String dateTimeStrc = new SimpleDateFormat("HH:mm:ss.S").format(current);
					//String dateTimeStrl = new SimpleDateFormat("HH:mm:ss.S").format(lastUpdated + interval);

					if(lastUpdated != 0 && current >= lastUpdated + interval){
						MuPDFActivity.getInstance().moveTaskToBack(true);
						System.exit(0);
						return;
					}

					interval_time = interval - ( current - lastUpdated);

					if(!onPauseFlag) {
						// 通常動作時
						// interval_timeをそのまま使用する。
						;
					} else {
						//スリープ状態時
						
						if(interval_time <= 1 * 60 * 1000) {
							// 残り時間が1分以内なら0.25秒間隔で確認する。
							interval_time = 250;
						} else if(interval_time > (1 * 60 * 1000)  && interval_time <= (10 * 60 * 1000)) {
							// 残り時間が１分～１０分なら１秒間隔で確認する。
							interval_time = 1000;
						} else if(interval_time > (10 * 60 * 1000)  && interval_time <= (30 * 60 * 1000)) {
							// 残り時間が１０分～３０分なら１０秒間隔で確認する。
							interval_time = 10000;
						} else {
							// 残り時間が３０分～６０分なら３０秒間隔で確認する。
							interval_time = 30000;
						}
					}

					if( interval_time > 0 ) {
						sleep(interval_time);
					}
				} catch (Exception ex){
					MuPDFActivity.getInstance().moveTaskToBack(true);
					System.exit(0);
				}
			}
		}
		
	}
    
    private synchronized static void setInterval(long interval) {
		getInstance().interval = interval;
	}
    
	public synchronized static void updateTimer(){
		if(getInstance().looper != null) {
			getInstance().updated.set(System.currentTimeMillis());
		}

		if(mLocalSocket != null){
			try {
				int data1 = 0x00;

				mLocalSocket.getOutputStream().write(data1);
			} catch (IOException e) {
				Log.e("KAITO_PDF_VIEWER", e.toString());
			}
		}
	}

	// minute : 0    監視なし
	//          -1   不明
	//          >0   分指定
	//
	public void start(int minute, String scName){
		if(minute > 0) {
			if(looper == null || looper.getState() == Thread.State.TERMINATED){
				setInterval(1000 * 60 * minute);
				looper = new Thread(new Looper());
				looper.start();
			}
		}

		if( minute != 0) {
			try {
				Log.e("KAITO_PDF_VIEWER", "XXX socket start ");
				mLocalSocket = new LocalSocket();
				LocalSocketAddress addr = new LocalSocketAddress(scName);
 
				mLocalSocket.connect(addr);
            
				Log.e("KAITO_PDF_VIEWER", "XXX socket OK");
				
			} catch (IOException e) {
				mLocalSocket = null;
				Log.e("KAITO_PDF_VIEWER", "XXX socket error = " + e.toString());
			}
		}
 
	}
	
	private static MuPDFTimer watcher = null;
	public static MuPDFTimer getInstance(){
		if(watcher == null){
			watcher = new MuPDFTimer();
		}
		return watcher;
	}

	public synchronized void sleep(long msec)
	{
		try{
			wait(msec);
		}catch(InterruptedException e){
		}
	}

	public synchronized void setOnPauseFlag(boolean flag) {
		getInstance().onPauseFlag = flag;

		try {
			notify();
		} catch(Exception e) {
			;
		}
	}
}