#
# -*- coding:utf-8 -*-

lexi = {
    "blockDevider": '\n',
    "globalIdentifier": ur'^☆([_A-Za-z0-9]+?):\s*(.*)$',
    "globalVariables": [
        "image_dir", "."
        ], #TODO
    "modes": {
        "code": {
            "begin": ur'^☆\+---\s*$',
            "end": ur'^☆\+---\s*$',
            "onFinished": {
                "insert": "</pre>",
                "replace": ""
                },
            "rules": {
                "start": {
                    "priority": 101,
                    "regexp": ur'^☆\+---$',
                    "replace": ur'<pre>',
                    "continue": False
                    },
                "bold1": {
                    "priority": 100,
                    "regexp": ur'\*b\[(.*?)]',
                    "replace": ur'<strong>\1</strong>',
                    },
                "red1": {
                    "priority": 100,
                    "regexp": ur'\*g[(.*?)]',
                    "replace": ur'<span class="red-text">\1</span>',
                    },
                "bold2": {
                    "priority": 100,
                    "regexp": ur'\*b\{(.*?)}',
                    "replace": ur'<strong>\1</strong>',
                    },
                "red2": {
                    "priority": 100,
                    "regexp": ur'\*g{(.*?)}',
                    "replace": ur'<span class="red-text">\1</span>',
                    },
                },
            },
        "table": {
            "begin": ur'^☆表.*',
            "end": ur'^\s*$',
            "onFinished": {
                "insert": "</table>"
                },
            "rules": {
                "caption": {
                    "priority": 110,
                    "regexp": ur'^☆表([0-9]+)\s+(.*)$',
                    "replace": ur'<table>\n<caption>表\1 \2</caption>',
                    "store": ["ref", "caption"],
                    "continue": False
                    },
                "tableHeaderRow": {
                    "priority": 103,
                    "regexp": ur'^〓(.*)$',
                    "replace": ur'<tr>\n  <th>\1</th>\n</tr>',
                    "set": ["isHeader", "yes"]
                    },
                "tableRow": {
                    "priority": 102,
                    "regexp": ur'^(.*)$',
                    "replace": ur'<tr>\n  <td>\1</td>\n</tr>',
                    },
                "tableCell": {
                    "priority": 103,
                    "regexp": ur'\t',
                    "replace": ur'</td><td>',
                    "switch": {
                        "isHeader" : {
                            "yes": {
                                "replace": ur'</th><th>',
                                "unset": "isHeader"
                                }
                            }
                        },
                    },
                },
            },
        "figure": {
            "begin": ur'^☆図.*$',
            "end": ur'^\s*$',
            "onFinished": {
                "insert": "</div>"
                },
            "rules": {
                "imageFile": {
                    "priority": 101,
                    "regexp": ur'^<(.*)>$',
                    "replace": ur'<img src="${image_dir}/\1" alt="図$ref $caption" width="480"><span class="caption">図$ref $caption</span>',
                    "continue": False
                    },
                "caption": {
                    "priority": 100,
                    "regexp": ur'^^☆図([0-9]+)\s+(.*)$',
                    "replace": ur'<div class="figure" width="480">',
                    "store": ["ref", "caption"],
                    "continue": False
                    },
                },
            },
        "global": {
            "transitions": ["figure", "code", "table"],
            "rules": {
                "paragraph": {
                    "priority": 100,
                    "regexp": ur'^(　.*)$',
                    "replace": ur'<p>\1</p>',
                    "apply": "inline",
                    },
                "header1": {
                    "priority": 101,
                    "regexp": ur'^●(.*)$',
                    "replace": ur'<h3>\1</h3>'
                    },
                "header2": {
                    "priority": 102,
                    "regexp": ur'^○(.*)$',
                    "replace": ur'<h4>\1</h4>'
                    },
                },
            },
        "inline": {
            "rules": {
                "textLink": {
                    "priority": 100,
                    "regexp": ur'\*\[(https?:/[^ ]*?)\s+(.*?)]',
                    "replace": ur'<a href="\1">\2</a>',
                    },
                "rawLink": {
                    "priority": 101,
                    "regexp": ur'\*\[(https?:/[^ ]*?)]',
                    "replace": ur'<a href="\1">\1</a>',
                    },
                "refference": {
                    "priority": 102,
                    "regexp": ur'\*(図|表|リスト|実行例)([0-9A-Za-z])',
                    "replace": ur'<strong>\1\2</strong>',
                    },
                },
            },
        }
    }

