// make_index.js

var config = require('../../config');
var path = require('path');
var fs = require('fs');
var util = require('util');

var tocParser = require('../export/toc-parser');

var usage = 'node make_index.js <output_file>';

function getSectionTitle(filename) {
  var content = fs.readFileSync(filename, {encoding: 'utf8'});
  var rex = /■(.*)/g;
  var matches = rex.exec(content);
  if (matches === null) {
    rex = /●(.*)/;
    matches = rex.exec(content);
    if (matches === null) {
      return '';
    }
    return [ matches[1] ];
  }

  var titles = [];
  while (matches !== null) {
    titles.push(matches[1]);
    matches = rex.exec(content);
  }
  return titles;
}

function titleToPath(title, directory) {
  var basePath = path.join(config.rootDir, directory, title);
  return basePath + '.txt';
}

function makeIndex(output) {
  var toc = readToc();
  toc.forEachDirectories(function (directory) {
    var pageNum = directory.pageStart;
    directory.contents.forEach(function (content) {
      var pagePath = titleToPath(content.title, directory.name);
      var pages = content.pages;
      var pageTitle = getSectionTitle(pagePath);
      console.log(pageNum, pageTitle);
      pageNum += pages;
    });
  });
}

function readToc() {
  var tocPath = path.join(config.rootDir, 'index.toc');
  var text = fs.readFileSync(tocPath, {encoding: 'utf8'});
  var toc = tocParser.parseToc(text);
  return toc;
}

// main action
if (require.main == module) {
  if (process.argv.length < 3) {
    process.stdout.write(usage + '\n');
    process.exit(1);
  }
  var output = process.argv[2];
  makeIndex(output);
}


