set :sshkit_backend, SSHKit::Backend::Docker
set :stage, :production
set :branch, 'release'
set :deploy_to, '/app'
fetch(:default_env).merge!(rails_env: :production, RAILS_SERVE_STATIC_FILES: 1,
                           SECRET_KEY_BASE: 'dummy', DEVISE_SECRET_KEY: 'dummy',
                           DATABASE_URL: 'mysql2://0/change-this-in-real-production')
#set :linked_dirs, %w()
set :linked_files, %w()
Rake::Task["deploy:set_linked_dirs"].clear # Save assets on each releases dir (not under shared)

server docker: {
  image: 'nvc-base',
  commit: 'nvc',
  env: {RAILS_SERVE_STATIC_FILES: 1},
}, user: 'rails:rails', roles: %w{web app}

Rake::Task["passenger:restart"].clear

before 'deploy:starting', 'docker:build_image'
