# MMDAI2 の操作マニュアル

これは MMDAI2 の操作マニュアルです。MMDAI Project Portal では画像つきの解説がありますが、最新の情報に更新されないことが多いです。
https://sites.google.com/sites/mmdaiproject/

解説対象は 0.26.0 をベースにしています。

# プロジェクト

プロジェクトはモデル、モーション、アクセサリをひとつにまとめて管理する情報のことです。MMDAI2 は基本的にプロジェクト単位で行い、保存するときはプロジェクトにまとめます。プロジェクトファイルは MMD のような pmm 形式ではなく xml 形式で保存されます。

プロジェクトファイルは xml 形式であるため、zip や 7z などで圧縮すると大幅にファイルサイズを小さくすることができます。また、定期的にバックアップをとってください。

## プロジェクトを新しく作る方法

メニューから「ファイル」の「新規プロジェクト作成」で新しくプロジェクトを作成することができます。変更点がある場合「変更しますか」のダイアログが出ます。最初に立ち上げた状態は常に新規にプロジェクトが作成されている状態になります。

プロジェクトの新規作成を行うとそれまでの全てのモデルやモーションやアクセサリが全て破棄されるため、プロジェクトを破棄する場合はプロジェクトの新規作成を行ってください。この処理は巻き戻すことが出来ません。

## プロジェクトの読み込み方法

方法は以下の３つあります。

 * メニューから「ファイル」の「プロジェクト読み込み」からプロジェクトのファイルを指定する
 * アプリケーションのウィンドウにプロジェクトのファイルに直接ドラッグ・アンド・ドロップする
 * アプリケーションのアイコンにプロジェクトのファイルを直接ドラッグ・アンド・ドロップする

いずれも変更点がある場合「変更しますか」のダイアログが出ます。また、読み込めない場合は警告ダイアログが表示されます。読み込めない場合は以下を確認してください。もし MMDAI2 で保存したのに読み込めない場合は開発者に連絡してください。

* xml 形式のファイルであり、かつ MMDAI2 で保存した xml ファイルであるかどうか?
* 重複した UUID がないかどうか?

プロジェクトを読み込むと「新規プロジェクト作成」と同じように前回のプロジェクトは破棄され、読み込まれたプロジェクトに上書きされます。この処理は巻き戻すことが出来ません。

## プロジェクトの保存方法

メニューから「ファイル」の「プロジェクトを保存」または「プロジェクトを別名で保存」で保存できます。前者は前回のファイル名で、後者はダイアログが開いて新しいファイル名を指定して保存します。もし「プロジェクトの保存」で前回のファイル名がない場合は「プロジェクトを別名で保存」と同じです。

## プロジェクトの設定

プロジェクトの設定はメニューから「プロジェクト」で行うことが出来ます。これらの情報はプロジェクトファイルに保存されます。

### 再生設定

再生の設定を行います。メニューの「プロジェクト」の「再生」または「再生設定」にある「再生」ボタンで再生設定に従って場面を再生します。「音声のファイル名」が指定されている場合は音声を再生し、出力します。

#### 音声のファイル名

再生時に再生される音声ファイルを指定します。「開く(Open)」ボタンでファイルダイアログが表示され、ファイルを指定すると左側のテキストボックスにダイアログで指定したパス名が表示されます。このパス名は直接編集することができます。

音声ファイルは以下の条件を「全て」満たす必要があります。ひとつでも満たさないと再生しても音声が流れません。

 * 音声ファイルが存在すること
 * 音声ファイルのフォーマットが WAV 形式 (拡張子は .wav) であること
 * 音声ファイルのコーデックが PCM 16bit Little Endian であること
 * 音声ファイルの周波数が 44KHz (44100Hz) であること
 
普通音声ファイルは MP3 や AAC などでエンコードされるため、MMDAI2 で使う際は上記の条件に合致するようにデコードを行う必要があります。MP3 や AAC のような不可逆形式の場合は仕様上エンコード前の元の音質と同じ (厳密に言うと近くなるだけ) にすることは出来ません。

#### フレーム開始位置

再生時のフレームの開始位置を指定します。途中から再生したい場合はこの値を変更してください。デフォルトでは 0 が指定されます。

#### フレーム終了位置

再生時のフレームの終了位置を指定します。通常はモーションの終了位置を指定しますが、途中で終了したい場合はこの値を変更してください。デフォルトではモーションの終了位置が指定されます。

#### 場面の FPS

再生時の FPS (Frame Per Second) の「限度」を指定します。モデルやアクセサリによっては描画負荷の影響で「場面の FPS」で指定した値を下回ることがあります。場面の FPS は 30FPS / 60FPS / 120FPS の3つから選択します。デフォルトでは 60 FPS が指定されます。

#### 繰り返し再生

「フレームの終了位置」に到達したら「フレームの開始位置」に戻って再び再生するかを指定します。「繰り返し再生」を有効にした場合進捗ダイアログの「キャンセル」で終了する必要があります。デフォルトでは無効です。

#### 選択状態にする

モデルを選択状態のままにし、タイムラインと同期するかを指定します。「選択状態にする」を有効にした場合負荷が高くなるため、FPS が落ちます。デフォルトでは無効です。

#### ボーンの接続状態を表示する

モデルのボーンの接続状態を表示したまま再生するかを指定します。ボーンの動きを確認する場合は有効にしてください。負荷は小さいため、基本的に「選択状態にする」程 FPS が下がることはありません。デフォルトでは無効です。

### 重力設定

物理シミュレーションで用いられる重力の設定を行います。値を負にすると重力と同じ方向を、正にすると逆に常に浮いているようなフワフワする表現をすることができます。負の値を大きくしすぎるとモデルがつぶれてしまいますのでご注意ください。デフォルトでは (X=0.0, Y=-9.8, Z=0.0) です。

#### シード値

Bullet Physics に渡すシード値を渡します。デフォルトは 0 です。0.25.0 から導入されました。

### 描画順設定 (Render order setting)

モデルまたはアクセサリの描画順を設定します。描画順は上にいくほど先に、下にいくほど後に描画されます。ボタンで上下を変更できる他、モデル名またはアクセサリ名をドラッグ・アンド・ドロップによって変更することが出来ます。

### アクセラレーションの設定

PMD/PMX で行う頂点スキニングに対する処理方法の設定を行います。うまくいけば高速化が期待できますが、場合によっては正しくレンダリングできなくなるかもしれません。

#### ソフトウェアスキニング

デフォルトのスキニング方法であり、CPU のみで頂点スキニングを行います。最も遅いですが、確実にレンダリング出来ます。

#### OpenCL スキニング (GPU)

OpenCL を用いて頂点スキニングを行います。場合によっては最も高速に処理出来ますが、場合によっては正しくレンダリングされないことがあります。

GPU か CPU かどちらが選択されるかはマシンに依存します。また、(GPU) とありますが、実際には GPU がない場合「OpenCL スキニング (CPU)」と同じ処理が行われます。

バイナリ配布されるものでは MacOSX でのみ利用可能です。Linux の場合はソースビルドで明示的に指定した場合のみ利用可能です。

#### OpenCL スキニング (CPU)

強制的に CPU が使用されることを除けば「OpenCL スキニング (GPU)」と同じようにOpenCL を用いて頂点スキニングを行います。GPU を使う場合に比べると遅いですが、ソフトウェアスキニングより高速に処理出来ます。

バイナリ配布されるものでは MacOSX でのみ利用可能です。Linux の場合はソースビルドで明示的に指定した場合のみ利用可能です。0.25.0 から導入されました。

#### 頂点シェーダスキニング

頂点シェーダを用いて頂点スキニングを行います。OpenCL と異なりソフトウェアスキニングと同じように選択可能であり、「OpenCL スキニング (GPU)」とほぼ同等な速度を得られますが、あまり正しくレンダリング出来ないかもしれません。

### 物理シミュレーションの有効化

Bullet Physics を使って物理シミュレーションを有効にします。物理シミュレーションは再生またはエンコード時のみ有効になり、編集中は常に無効の状態になります。デフォルトでは有効です。

### グリッドの表示

位置調整の参考として地面に 5.0 単位で 20x20 の格子状のグリッドが描画されます。デフォルトでは有効です。

### 背景色設定

背景色を任意の色に設定するためのダイアログを開きます。例えばクロマキー表示をしたい時に便利です。ダイアログの表示方法は OS に依存します。

### シャドウマップ設定

シャドウマップの設定を行うためのダイアログを開きます。

#### 大きさ

シャドウマップで使用するテクスチャの大きさを設定します。小さくすると描画負荷が下がりますが、影のジャギー(影が荒くなる)が目立つようになります。大きくすると影のジャギーを減らせますが、描画負荷が上がります。

デフォルトは 1024x1024 です。設定可能な最大の大きさはマシンに依存します。(内部的には GL_MAX_TEXTURE_SIZE の値を取得しています)

#### ソフトシャドウを有効にする

ソフトシャドウは影のぼかし処理を入れて影のジャギーを減らす処理です。かなり大きな負荷の処理のため、重い場合は無効にしてください。デフォルトは有効です。

#### 光源を自動的に計算する

光源を自動的に計算するかあるいは任意の中心点と半径を元に計算するかを設定します。光源は基本的にモデルの大きさと中心点と光源方向に基づいてバウンディングスフィアを作成し、バウンディングスフィア内にある場面をシャドウマップを生成します。モデルによっては正しく算出出来無いことがあるため、これを任意の値に変更することが可能です。

中心点はバウンディングスフィアの中心点を設定し、半径はバウンディングスフィアの半径を設定します。半径は大きければ大きいほどカバー出来る範囲が広がりますが、影が荒くなります。

デフォルトは有効です。

### 背景画像の読み込み

場面の背景に表示する画像を設定します。BMP/JPG/GIF/PNG の画像が読み込み可能です。MacOSX の場合はさらに動画 (AVI/M4V/MP4/MOV) を読み込むことが可能です。ファイルを指定して読み込むと画面の中央に画像が表示されます。動画の場合はフレームの位置の更新に従って動画も相当する位置にシークされます。

### 背景画像の消去

場面の背景画像を消去します。消去時の背景画像の設定はリセットされずに残ります。

### 背景画像の設定

背景画像の位置と背景画像の表示方法を設定するためのダイアログが開きます。背景画像の位置は場面中央の位置からの相対位置となります。

「背景画像を場面の大きさに合わせる」を有効にすると場面の大きさに応じて自動的に背景画像の大きさが調整されます。そのため、背景画像の大きさが場面より小さいと引き伸ばし表示になり、逆に場面より大きいと縮小表示になります。

# モデル

モデルは MMD で利用される PMD または PMX 形式で読み込み可能なファイルのことです。PMX 形式のモデルは現在完全に対応出来ているわけではなく、いくつか未実装があります。例えば SDEF 変形には対応せず、BDEF2 変形にフォールバックします。

## モデルの読み込み方法

モデルの追加方法は５つあります。

 * ウィンドウ上部の「モデルを追加」からモデルのファイルを指定する
 * メニューから「ファイル」の「モデルを追加」からモデルのファイルを指定する
 * 右側の描画ウィンドウを右クリックし、「モデルを追加」からモデルのファイルを指定する
 * アプリケーションのウィンドウにモデルのファイルに直接ドラッグ・アンド・ドロップする
 * アプリケーションのアイコンにモデルのファイルを直接ドラッグ・アンド・ドロップする

モデルを読み込むとモデルの説明のダイアログが表示され、「OK」で実際にモデルが読み込まれます。「キャンセル」でモデルの読み込みを行わず、描画もされません。モデルが読み込まれると左上の情報パネルの「Model:」にモデル名が表示され、センターボーンが指定されます。

0.20.0 から zip 形式のファイルの読み込みに対応しています。注意点として zip ひとつにつきひとつのモデルしか読みこむことが出来ません。そのため、複数のモデルがある場合は最初のモデルが読み込まれます。複数のモデルを読みこませる場合は一度解凍して pmd/pmx で読み込ませてください。

## モデルの操作

モデルの操作は主に３つの方法があります。いずれも予めモデルを選択する必要があります。

 * 右下のスクリーンハンドルから操作
 * モデルに表示される回転ハンドルまたは移動ハンドルから操作
 * モデルタブを選択してモーフタブからモーフスライダーを操作

前者２つはボーン、後者はモーフを操作する方法で、これらを使ってモデルを動かしていきます。モーフは「モーフ」の項目で解説します。

### 場面右下のスクリーンハンドル

スクリーンハンドルは上から Global/Local/View の文字表示、回転を示すマークを含んだ X/Y/Z のハンドル、移動を示すマークを含んだ X/Y/Z のハンドルの７つで構成されます。

Global/Local/View の文字表示はマウスカーソルをあててクリックすることによって切り替えることが出来ます。クリックすると Local => Global => View => Local の順で切り替えることができます。

 * Global はボーン及びカメラの状態に依存しない絶対基準の移動及び回転を行います
 * Local はボーンの変形状態に基づいた相対基準の移動及び回転を行います
   * ボーン（例：指、ひじ、腕、手首）によっては独自のローカル軸を用いて変形を行います
 * View はカメラ視点に基づいた移動及び回転を行います

X/Y/Z のハンドルはマウスカーソルをあてて上下にドラッグすることによってボーン動かすことができます。X/Y/Z のハンドルは操作可能である場合はそれぞれ赤、緑、青で色付けされます。灰色で表示されている場合はそのハンドルから操作することが出来ません。

### 回転ハンドルと移動ハンドル

「タイムライン」の「ボーン」の下にある「選択」、「回転」、「移動」のうち「回転」をクリックすると選択されたボーンに回転ハンドルが、同様に「移動」をクリックすると選択されたボーンに移動ハンドルがそれぞれ表示されます。

回転ハンドルは３つのドーナツで表示され、なぞるようにドラッグするとボーンを回転することができます。移動ハンドルは軸と矢印で表示され、矢印をドラッグすることで指定方向にボーンを移動することができます。

回転及び移動ハンドルはボーンが移動可能な場合は中央に水色の球体が表示され、それをドラッグすることによってボーンをカメラ視点に基づいて任意に移動することができます。使用する際はカメラのプリセットを用いて動かすことを推奨します。

## モデルメニューからの操作

モデルの操作は上記以外にメニューの「モデル」からモデルの選択及びモデルの位置を変えることができます。ただしこちらの方法は情報がプロジェクトに保存されるにとどまり、モーションには含まれません。

以下のモデルの位置と回転の設定はキーフレームとは独立して設定されます。モデルの位置及び回転はプロジェクトに保存されます。

### モデルを選択

プロジェクト内にあるモデルをの一覧からモデルを選択します。選択されたモデルは右側のウィンドウの左上の「Model:」に選択されたモデル名が表示されます。

### 次のモデルを選択

現在選択されているモデルの次のモデルを選択します。現在選択されているモデルが最後の場合、最初のモデルが選択されます。「モデルを選択」で現在のモデルのすぐ下(または最初)を選択することと同じです。

### 前のモデルを選択

現在選択されているモデルの前のモデルを選択します。現在選択されているモデルが最初の場合、最後のモデルが選択されます。「モデルを選択」で現在のモデルのすぐ上(または最後)を選択することと同じです。

### 選択されたモデルを上に移動

現在選択されているモデルを移動量 1.0 固定で Y 軸にそって上に移動します。これによって処理されたモデル位置はキーフレームとは独立して設定されます。

### 選択されたモデルを下に移動

現在選択されているモデルを移動量 1.0 固定で Y 軸にそって下に移動します。これによって処理されたモデル位置はキーフレームとは独立して設定されます。

### 選択されたモデルを左に移動

現在選択されているモデルを移動量 1.0 固定で X 軸にそって左に移動します。これによって処理されたモデル位置はキーフレームとは独立して設定されます。

### 選択されたモデルを右に移動

現在選択されているモデルを移動量 1.0 固定で X 軸にそって右に移動します。これによって処理されたモデル位置はキーフレームとは独立して設定されます。

### モデルの位置を戻す

現在選択されているモデルを初期状態の位置 (X=0.0, Y=0.0, Z=0.0) に戻します。これによって処理されたモデル位置はキーフレームとは独立して設定されます。

## モデルの削除

現在選択されているモデルを削除します。削除前にダイアログを表示して OK で削除します。キャンセルした場合モデルは削除されません。削除するとひもづけられているモーションのキーフレーム操作の巻き戻しが出来なくなります。

## モデルタブ

ウィンドウ左側の下のタブにある「モデル」は「情報」、「設定」、「モーフ」のタブがあります。

### 情報

情報は読み込まれた情報のモデルの情報を表示とエッジ幅及び色、投影影の設定が出来ます。モデルの情報は以下の情報が表示されます。モデルが選択されていない、またはモデルが何もない場合は名前とコメントが「N/A」に、それ以外は 0 に設定されます。

 * 名前
 * コメント
 * 頂点数
 * インデックス数
 * 材質マテリアル数
 * ボーン数
 * IK 数
 * モーフ数 (頂点モーフ)
 * 剛体数
 * ジョイント(拘束条件)数

### 設定

個々のモデルに適用される設定を行います。設定はプロジェクトファイルに保存されます。

#### 不透明度

モデルの不透明度を設定することが出来ます。百分率で決定され、100 にするとモデルが完全に表示され、0 にするとモデルが完全に透明になり、非表示扱いになります。50 で MMD における半透明表示に相当する表示を行います。

#### エッジ幅

モデルのエッジ幅を設定することが出来ます。0.0 から 2.0 の間で設定することが出来ます。0.0 にするとエッジを一切描画しなくなるため、わずかに描画負荷が軽くなります。エッジ幅の設定はプロジェクトに保存されます。

#### エッジ色

モデルのエッジ色を設定することが出来ます。エッジ色の設定はプロジェクトに保存されます。

#### 影設定

 * 影を無効にする
  * 影の表示を無効にします。描画負荷が下がります。
 * 投影影を有効にする
  * 投影影を表示します。簡易的な影を表示しますが、若干描画負荷が上がります。
 * セルフシャドウを有効にする
  * セルフシャドウを表示します。よりディティールな影を表示しますが、それなりに描画負荷が上がります。

個々のモデルの影設定はプロジェクトに保存されます。デフォルトでは影表示は無効です。

#### 位置

モデルの絶対位置を設定します。モーションはこの位置を加算して処理されます。

#### 回転

モデルの回転量を設定します。モーションはこの回転量を結合して処理されます。

### モーフ

モーフはモデルの頂点モーフ(または表情とも呼ばれる)を操作します。PMD では頂点モーフのみですが、PMX ではそれ以外にボーン、材質、グループ、拡張頂点モーフが存在します。モーフは４つのカテゴリに分かれて操作します

 * 目 (Eye)
 * 口唇 (Lip)
 * 眉毛 (Eyeblow)
 * その他 (Other)
 
スライダーでモーフの値を変更することにより、モデルの頂点がそれに合わせて変化します。「登録」で現在のフレーム位置にキーフレームが登録されます。「登録」を忘れるとフレームの位置変更によってそれまで設定したモーフの値が破棄されるため、注意が必要です。

「全てのモーフをリセット」はモデル内の全てのモーフをリセットします。

0.26.0 からはモーフのタイムラインの下にスライダーがあり、それを使って選択中のモーフの値を変更することが可能です。また、左上に現在選択されているモーフ名が表示されます。

# 補間

補間はキーフレームとキーフレームの間にあるフレームに対して値を自動的に算出して設定する処理です。基本的に何も設定しなければ線形補間で処理されますが、ボーンとカメラのキーフレームの補間は設定で変更することが可能です。モーフは設定から変更できず、常に線形補間で行います。

補間設定を行うには以下の２つの方法があります。

 * キーフレーム (黒または白のダイアモンド状のマーク) をダブルクリックする
  * 何も設定されていない箇所にクリックすると警告ダイアログを表示します
 * キーフレームを選択してメニューの「キーフレーム」の「補間ダイアログを表示する」をクリックする

１つのキーフレームの補間曲線を変更します。X1/Y1 が開始位置、X2/Y2 が終了位置を示します。スピンボックスの値を直接変更するか、あるいはグラフの赤丸をドラッグすることによって補間曲線の値を変更することが出来ます。

ボーンの場合は以下の4項目のパラメータタイプで設定します。

 * X 軸
 * Y 軸
 * Z 軸
 * 回転

カメラの場合は以下の6項目のパラメータタイプで設定します。

 * X 軸
 * Y 軸
 * Z 軸
 * 回転
 * 視野角 (fov)
 * 距離 (distance)

 - 「プリセット」は予め設定された値があり、選択すると自動的に値が設定されます。
 - 「全てのパラメータに適用」は上記の全てのパラメータにタイプに値を適用する処理です。
 - 「リセット」はダイアログを開いた時のパラメータに戻す処理です。
 
# アクセサリ
 
アクセサリは X 形式で読み込み可能なファイルのことです。アクセサリによっては正しく描画出来ないことがあります。

## アクセサリの読み込み方法

アクセサリの追加方法は５つあります。

 * ウィンドウ上部の「アクセサリを追加」からアクセサリのファイルを指定する
 * メニューから「ファイル」の「アクセサリを追加」からアクセサリのファイルを指定する
 * 右側の描画ウィンドウを右クリックし、「アクセサリ」からアクセサリのファイルを指定する
 * アプリケーションのウィンドウにアクセサリのファイルに直接ドラッグ・アンド・ドロップする
 * アプリケーションのアイコンにアクセサリのファイルを直接ドラッグ・アンド・ドロップする

アクセサリを読み込むとウィンドウ左側の「場面」タブの「アクセサリ」にアクセサリの情報が追加されます。0.26.0 ではモデルと同等に扱われ、モデルと同じように自動的に追加されるボーンまたはモーフを操作することが可能です。自動的に追加されるボーン及びモーフは以下です。

 - ボーン
  - 全ての親 (アクセサリの位置または回転を決定する)
  - 拡大率 (アクセサリの拡大率を決定する。個々の軸に値が独立しており、X/Y/Z 軸の値の平均が拡大率になる)
 - モーフ
  - 不透明度 (アクセサリの不透明度を決定する。デフォルトでは 1.0 になっており、0.0 にすると完全に透明になる)

0.20.0 から zip 形式のファイルの読み込みに対応しています。注意点として zip ひとつにつきひとつのアクセサリしか読みこむことが出来ません。そのため、複数のアクセサリがある場合は最初に見つかったアクセサリが読みこまれます。

アプリケーションに zip ファイルをドラッグ・アンド・ドロップされた場合モデルとして扱われるため、zip をアクセサリとして追加したい場合は上３つの方法でおこなってください。

## アクセサリの操作

アクセサリの操作はウィンドウ左側の「場面」タブの「アクセサリ」で行います。

### アクセサリの選択と削除

一番上にアクセサリの一覧を示すプルダウンリストと「削除」ボタンがあります。「削除」はプルダウンで指定されたアクセサリを削除します。この処理は巻き戻すことが出来ません。

### 割り当て

アクセサリの割り当てはアクセサリの表示基準を設定します。モデルが読み込まれていない場合は地面のみ選択することが出来ます。モデルが読み込まれている場合は左側にモデルのプルダウンリスト、右側にその選択されたモデルのボーンのプルダウンリストが表示されます。

モデルとボーンを指定するとそのボーンを基準にアクセサリが動きを追従します。これはアクセサリをモデルの持ち物として扱う場合に利用します。

デフォルトは地面で、この場合アクセサリは不動となります。ステージ用のアクセサリで使います。

### 位置

アクセサリの相対位置を決定します。「割り当て」の位置に足す形で計算されます。デフォルトは (X=0.0, Y=0.0, Z=0.0) です。

### 回転

アクセサリの相対回転値を決定します。X/Y/Z 軸を基準に回転し、「割り当て」の回転に結合する形で計算されます。デフォルトは無回転 (X=0.0, Y=0.0, Z=0.0) です。

### 拡大率

アクセサリの拡大率を指定します。デフォルトは MMD と同じ 10 (=10.0) 倍です。

### 不透明度

アクセサリの不透明度を指定します。0.0 で完全に透明、1.0 で完全に不透明二することが出来ます。この値を指定する場合描画順の変更が必要になることがあります。デフォルトは完全に不透明 (=1.0) です。

# モーション

モーションは MMD で使用される VMD 形式またはその互換である MMM (MikuMikuMoving) で使用される MVD 形式で読み込み可能なファイルのことです。モーションは場面またはモデルに対して用いられ、以下の５つに分けられます。

 * ボーン
 * モーフ
 * カメラ
 * 照明
 * セルフシャドウ
 
このうち対応しているのはボーンとモーフとカメラです。照明は現在内部的に利用可能にとどまり、セルフシャドウは対応していません。ボーンとモーフはモデルに対して、カメラと照明は場面に対して用いられます。

0.25.0 から MikuMikuMoving が新しいモーション形式として採用している MVD 形式の読み込み及び書き出しに試験的に対応しています。こちらは以下の要素を読み込みます。

 * ボーン
 * モーフ
 * カメラ

新規作成は現状 MVD ではなく VMD しか出来ません（出力では MVD の選択が可能だが基本的に VMD 形式と同じデータが出力される）。その際ボーン及びカメラのレイヤーは 0 番目しか書き込まれず、モーフの補間設定は無視され線形補間として出力されます。

## モーションを新しく作る方法

メニューから「ファイル」の「新規モーション」で新しくモーションを作成することができます。変更点がある場合「変更しますか」のダイアログが出ます。最初に立ち上げた状態は常に新規にモーションが作成されている状態になります。

モーションの新規作成は場面及びモデル両方に適用される点にご注意ください。

## モーションを読み込む方法

方法は適用先がモデルか場面かによって方法によって分かれます。

モデルに対して適用されるモーションは以下の４つあります。全てあらかじめモデルを選択する必要があります。また、モデルを選択しないままモーションの追加を行おうとすると警告ダイアログが表示されます。

 * ウィンドウ上部の「モーションを追加」からモーションのファイルを指定する
 * メニューから「ファイル」の「モーションを選択されたモデルに追加」からモーションのファイルを指定する
 * 右側の描画ウィンドウを右クリックし、「モーションを選択されたモデルに追加」からモーションのファイルを指定する
 * アプリケーションのウィンドウにモーションのファイルに直接ドラッグ・アンド・ドロップする

モデルの場合モーションデータ内にある適用先モデルと選択したモデルが違う場合は警告ダイアログ表示を出します。「はい」で強制的にモーションを読みこませることが出来ます。
 
カメラの場合はメニューの「ファイル」の「カメラモーションの設定」でモーションのファイルを指定すると場面のカメラモーションが適用されます。ただし、カメラのキーフレームがひとつもないと読み込まれません。
 
どちらも読み込む前に変更点がある場合「変更しますか」のダイアログが出ます。モーションのファイルを指定せずキャンセルした場合は読み込まれません。

## モーションを保存する方法

モーションはモデル及び場面両方共全てのキーフレームがプロジェクトに保存されます。以下はプロジェクトではなく、VMD として保存する方法です。

モデルに対して適用されるモーションの場合はメニューから「ファイル」の「モデルモーションを保存」または「モデルモーションを別名で保存」で保存できます。前者は前回のファイル名で、後者はダイアログが開いて新しいファイル名を指定して保存します。もし「モデルモーションを保存」で前回のファイル名がない場合は「モデルモーションを別名で保存」と同じです。

保存時ファイのダイアログが開くので、ファイル名を指定します。指定後、全てのボーンとモーフのキーフレームが出力され、 VMD として保存されます。それ以外のキーフレームは含まれません。

カメラに対して適用されるモーションの場合はメニューの「カメラモーションを別名で保存」で保存できます。保存時ファイルのダイアログが開くので、ファイル名を指定します。指定後、全てのカメラのキーフレームが出力され、VMD として保存されます。それ以外のキーフレームは含まれません。

# 場面

場面はウィンドウ右側に描写される画面のことです。場面は基本的にカメラの操作がメインです。

## 場面の操作

場面の操作はマウスか、メニューの「場面」、もしくは「場面」タブの「カメラ」タブで変更することが出来ます。

## マウスでの操作

ウィンドウ右側の場面描写にカーソルを合わせてマウス操作を行うことで場面の操作を行うことができます。

 * マウスホイールを前に転がす
   * カメラ視点の拡大
 * マウスホイールを後ろに転がす
   * カメラ視点の縮小
 * 左クリックをしながら上下左右に動かす
   * カメラアングルの変更
 * SHIFT 押しつつ左クリックしながら上下左右に動かす
   * カメラの目標点の変更

MMD ではカメラアングルの変更は右クリックですが、こちらは左クリックな点にご注意ください。

### 拡大

カメラ視点の拡大を行います。内部的には視野距離を -4.0 することと同等です。

### 縮小

カメラ視点の拡大を行います。内部的には視野距離を +4.0 することと同等です。

### 上に回転

カメラアングルを正面から見て上方向に回転します。内部的にはカメラの X 軸に沿って +10.0 度することと同等です。

### 下に回転

カメラアングルを正面から見て下方向に回転します。内部的にはカメラの X 軸に沿って -10.0 度することと同等です。

### 左に回転

カメラアングルを正面から見て左方向に回転します。内部的にはカメラの Y 軸に沿って +10.0 度することと同等です。

### 右に回転

カメラアングルを正面から見て右方向に回転します。内部的にはカメラの Y 軸に沿って -10.0 度することと同等です。

### 上に移動

カメラの目標点を正面から見て上方向に移動します。内部的にはカメラの目標点を Y 軸に沿って +1.0 することと同等です。

### 下に移動

カメラの目標点を正面から見て下方向に移動します。内部的にはカメラの目標点を Y 軸に沿って -1.0 することと同等です。

### 左に移動

カメラの目標点を正面から見て左方向に移動します。内部的にはカメラの目標点を X 軸に沿って -1.0 することと同等です。

### 右に移動

カメラの目標点を正面から見て右方向に移動します。内部的にはカメラの目標点を X 軸に沿って +1.0 することと同等です。

### カメラ視点をリセット

カメラを初期状態にリセットします。内部的には目標点を (X=0.0, Y=10.0, 0.0) に移動し、カメラアングルをゼロにした上で視野角を 30 度に、視野距離を 50.0 にすることと同等です。

## カメラタブ

カメラタブではプリセットからの選択とカメラを数値指定で変更することができます。

### プリセット

プリセットでは６つのボタンがあり、プリセットの値に従ってカメラアングルを変更します。このうち「カメラ」のみは現在のカメラのキーフレームの値に変更し、それ以外はカメラアングルのみを変更します。

 * 前面
 * 背面
 * トップ
 * 左
 * 右
 * カメラ

### 数値指定

数値指定ではカメラ操作を数値に従って直接変更できる機能です。回転は度数単位で変更します。

 * 位置
 * 回転
 * 視野角 (fov)
 * 視野距離 (distance)

### 追従

追従は指定されたモデルまたはボーンの位置をカメラの注視点としてもっていく処理です。モデルまたはボーンを選択するとカメラの「位置」が自動的にモデルの位置またはボーンの位置に変更されます。

### 初期化

カメラのパラメータ(位置/回転/視野角/視野距離)を全て初期値に戻す処理です。

## 照明光タブ

照明光タブでは光源の色と方向を変更することが出来ます。

### 照明光色

照明光色を数値指定で変更します。0 から 255 の値の範囲で設定できます。もしくは下のボタンから開く色設定ダイアログからも設定可能です。これを変更するとモデルが光にあたるときの色が変化します。

デフォルトは 全て 153 です。

### 方向

照明の方向を数値指定で変更します。これを変更するとモデルの光のあたり方と影の表示方向が変わります。

デフォルトは (-0.5, -1.0, -0.5) です。
 
# キーフレーム

キーフレームはモーションの最小単位です。複数のキーフレームによって、モーションが成立します。キーフレームの操作はメニューの「編集」と「キーフレーム」で行うことが出来ます。キーフレームは場面、ボーン、モーフの３種類あり、「タイムライン」タブの上部の「場面」、「ボーン」、「モーフ」がそれぞれ対応します。

キーフレームを編集するにはモデルが読み込まれ、かつモーションを編集する対象のモデルが選択状態にある必要があります。

## キーフレームの登録

モデルを動かしたらキーフレームを登録する必要があります。キーフレームの登録方法は２つあります。どちらの方法も現在選択中のタブのタイムライン中の選択された範囲に対してキーフレームが登録されます。

 * 「フレームの位置」横による「登録」を押す
 * メニューの「キーフレーム」の「キーフレームを登録」を選択
 
キーフレームを登録しないままフレームの位置を移動すると前のキーフレームの位置で編集した内容が破棄されます。編集した内容をモーションに反映させる場合は必ずキーフレームの登録を行ってください。

キーフレームの登録はメニューの「編集」にある「元に戻す」を選択することによって前の状態に巻き戻すことが出来ます。また、「やり直す」を選択すると「元に戻す」で行った状態を破棄してキーフレームを登録した状態に戻すことができます。
 
## キーフレームの削除

キーフレームの削除方法は２つあります。どちらの方法も選択されたキーフレームを削除します。仕様上０番目のキーフレームは編集出来ても削除することができません。

 * メニューの「キーフレーム」の「選択されたキーフレームを削除」を選択
 * タイムラインを右クリックすることによって表示されるメニューの「選択されたキーフレームを削除」を選択
 
キーフレームの削除はメニューの「編集」にある「元に戻す」を選択することによって前の状態に巻き戻すことが出来ます。また、「やり直す」を選択すると「元に戻す」で行った状態を破棄してキーフレームを削除した状態に戻すことができます。

## キーフレームの編集（「編集」メニューにあるもの）

以下はメニューの「編集」にあるものです。

### コピー

現在の「フレームの位置」にあるキーフレームをコピーします。前回コピーされたキーフレームは破棄されます。

### ペースト

「コピー」でコピーしたキーフレームを現在の「フレームの位置」にペーストします。すでに登録されているキーフレームがある場合は上書きされます。

### 反転ペースト

「ペースト」に加えて、ボーン名に「左」または「右」が含まれている場合位置と回転を反転させてペーストします。

### 元に戻す (アンドゥ)

前回の処理に戻します。ボーンやモーフの変更を行うと実行できます。元に戻す回数に制限はついていません。

### やり直す (リドゥ)

「元に戻す」前の処理に戻します。「元に戻す」処理の逆を行います。

## キーフレームの編集（「キーフレーム」メニューにあるもの）

以下はメニューの「キーフレーム」にあるものです。

### キーフレームの登録

タイムライン上で選択されたフレーム（※キーフレームではないです！）をキーフレームとして登録します。

### キーフレームの削除

タイムライン上で選択されたキーフレームを削除します。

### すべてのキーフレームを選択

タイムライン中にある登録済みの全てのキーフレームを選択します。

### キーフレーム範囲選択ダイアログを開く

登録されたキーフレームを範囲選択するためのダイアログを開きます。

### キーフレームの重み係数設定ダイアログを開く

選択されたキーフレームに対して重みをつけて登録するためのダイアログを開きます。これは現在選択されているタブによって設定項目が変わります。

#### ボーン

ボーンの場合は以下の６項目を設定することが出来ます。デフォルトはいずれも 1.0 です。

 * 位置X軸
 * 位置Y軸
 * 位置Z軸
 * 回転X軸
 * 回転Y軸
 * 回転Z軸

#### モーフ

モーフの場合は重み係数のみ設定できます。デフォルトは 1.0 です。

 * 重み係数

#### 場面

現在この操作はサポートされていません。

### ボーンの X 位置を 0 にする

選択されたボーンの X 軸の位置を 0 にリセットします。それ以外の軸 (Y/Z) は変更されません。

### ボーンの Y 位置を 0 にする

選択されたボーンの Y 軸の位置を 0 にリセットします。それ以外の軸 (X/Z) は変更されません。

### ボーンの Z 位置を 0 にする

選択されたボーンの Z 軸の位置を 0 にリセットします。それ以外の軸 (X/Y) は変更されません。

### 全てのボーンの位置と回転をリセットする

「全ての」ボーンの位置と回転をゼロにリセットし、モデル追加時の状態に戻します。

### ボーンダイアログを開く

選択されたボーンの位置と回転量を数値指定するためのダイアログを開きます。位置と回転量いずれもグローバル変形として処理されます。0.26.0 では値の増加単位量を変更するための数値指定が新たに追加されています。

# ポーズ

ポーズは拡張子 vpd がつくファイルのことです。ポーズはキーフレームのまとまりでもあります。

## ポーズを読み込む方法

ポーズファイルを読み込むにはまず対象のモデルを予め選択しておく必要があります。次にメニューの「ファイル」の「モデルのポーズ読み込み」を選択し、vpd ファイルを指定して読み込みます。

ポーズファイルはポーズファイルにあるボーン名とモデルにあるボーン名と一致したものだけが設定されます。一致しないものは無視され、設定されません。また、現時点で拡張形式に対応していないため、モーフは読み込まれません。

## ポーズを保存する方法

ポーズファイルを保存するにはまず対象のモデルを予め選択し、保存したいフレーム位置を指定する必要があります。次にメニューの「ファイル」の「モデルのポーズ保存」を選択し、書き出し先のパスを指定します。

ポーズ保存される際現在のフレーム位置にある全ての登録されたキーフレームが書き出されます。

# エフェクト

エフェクトは拡張子 cgfx がつくファイルのことです。この機能は NVIDIA の Cg (CgFX) ライブラリを用いおり、MME (SAS 含む) と互換性がありますが、技術的仕様上同様に取り扱うことは出来ず、ある程度書き換えが必要です。現在試験運用段階であり、機能も有効無効を切り替えられることのみに留まっています。また、セルフシャドウに対応していません。

エフェクトはコンパイルに時間がかかるため、一度コンパイルしたらエフェクトはキャッシュされます。そのため、同じパスのエフェクトファイルが参照された場合はそのキャッシュからエフェクトを適用します。モデルを削除してもエフェクトの依存関係の問題からエフェクトのキャッシュは削除されません。エフェクトのキャッシュを削除したい場合は新規にプロジェクトを作成し直すか、あるいは読み込み直す必要があります。

## エフェクトを有効にする

エフェクト機能を有効または無効にします。無効にした場合現状エフェクト適用済みのモデルのエフェクトは解除されない仕様になっています。また、無効にしてもエフェクトのキャッシュが残り続けるため、削除したい場合は上記のようにプロジェクトを作成し直すかあるいは読み込み直す必要があります。

# ファイル出力

ファイル出力は場面を静止画または動画として出力する機能です。

## 静止画出力

静止画出力はメニューの「ファイル」の「場面を画像として出力」で行うことができます。選択すると動画出力と同じように設定ダイアログが表示され、大きさを設定してからダイアログが表示されます。基本的に拡張子は png が指定されますが、bmp でも jpg でも可能です。設定では縦と横のピクセルサイズのみ設定可能です。それ以外は設定できません。

実行すると指定された大きさにウィンドウの大きさを変更して現在のフレーム位置の場面を静止画として出力します。出力後は動画出力と同じように元の大きさに戻ります。

## 動画出力

動画出力はメニューの「ファイル」の「場面を動画として出力」で行うことができます。実行するとまず動画出力設定のダイアログ、次にファイルダイアログが出て動画出力が開始されます。

一度動画出力処理が実行されると、キャンセルが行われるまで終了せず、操作を行うことが出来ません。また、途中でキャンセルすると途中まで出力した動画が書きだされます。

出力される動画の特性は以下のとおりです。

 * フォーマットは MOV で出力される
 * コーデックは PNG で出力される
 * 音声を含む場合は音声コーデックに PCM (2ch/44KHz) が使用される
 * ほぼ生で出力されるため、ファイルサイズが非常に大きい
   * 数十秒であっても設定次第では1GB弱の容量を食う
   * そのままでは大きすぎるので、動画のエンコード必須

出力された動画は MacOSX では iMovie や Motion などで扱うことができます。また、Linux では OpenShot などで扱うことができます。

### 動画出力設定

動画出力設定は再生設定と以下の点で共通なため、説明を割愛します。

 * 音声ファイル指定
 * フレーム開始位置
 * フレーム終了位置
 * 場面の FPS

#### 横(px)

出力する動画の横幅をピクセル単位で指定します。最小は 160px です。

#### 縦(px)

出力する動画の縦幅をピクセル単位で指定します。最小は 160px です。

#### グリッドを含める

動画出力時にグリッドを含めるかどうかを指定します。デフォルトは無効です。

# アプリケーションの TIPS 集

MMDAI2 にまつわる TIPS 集です。

## MMDAI2 を使用しない間に CPU/GPU 負荷を下げる方法 

0.24.1 よりウィンドウを最小化することによってレンダリングを停止する処理を持っているため、一時的に使用しない場合はウィンドウを最小化してください。ウィンドウを復元するとレンダリングが再開されます。ただし動画出力中時は例外で最小化しても常に動画出力のためのレンダリング処理が行われるため、負荷を下げることは出来ません。

