/**

 Copyright (c) 2010-2014  hkrn

 All rights reserved.

 Redistribution and use in source and binary forms, with or
 without modification, are permitted provided that the following
 conditions are met:

 - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
 - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.
 - Neither the name of the MMDAI project team nor the names of
   its contributors may be used to endorse or promote products
   derived from this software without specific prior written
   permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE.

*/

#include "Application.h"

#include <QtCore>
#include <QFileOpenEvent>
#include <vpvl2/vpvl2.h>

Application::Application(QCommandLineParser *parser, int argc, char **argv)
    : QApplication(argc, argv),
      m_parser(parser),
      m_json(QStringList() << "j" << "json", "Configuration JSON from <file> to load at startup.", "file")
{
    parser->addHelpOption();
    parser->addVersionOption();
    parser->addOption(m_json);
    parser->process(*this);
}

Application::~Application()
{
}

QString Application::commitRevision() const
{
    return vpvl2::libraryCommitRevisionString();
}

QUrl Application::requestedFileUrl() const
{
    return m_requestedFileUrl;
}

QUrl Application::json() const
{
    return QUrl::fromLocalFile(m_parser->value(m_json));
}

bool Application::hasJson() const
{
    return m_parser->isSet(m_json);
}

bool Application::event(QEvent *event)
{
    if (event->type() == QEvent::FileOpen) {
        QFileOpenEvent *fileOpenEvent = static_cast<QFileOpenEvent *>(event);
        m_requestedFileUrl = QUrl::fromLocalFile(fileOpenEvent->file());
        emit requestedFileUrlChanged();
    }
    return QApplication::event(event);
}
