/*!
 * @file Species.cpp
 * @brief Q[̃N[`[ʂ`
 * @date 2014/02/01
 * @author Deskull
 * 2014 Sikabane Works.
 */

#include "stdafx.h"
#include "Species.h"

Species::Species(ID id, TAG tag, GameWorld *gameWorld) : GameElement(id, tag, gameWorld)
{
	Species();
	return;
}

Species::Species(void)
{
	this->name = "_~[";
	this->baseSoul = 100;
	this->baseFeed = 20000;

	this->averageHeight = 160;
	this->averageWeight = 50;

	this->baseStatus.Set(8, 8, 8, 8, 8, 8);
}

Species::~Species(void)
{
}

const string Species::GetName(void)
{
	return this->name;
}

const SOUL Species::GetBaseSoul(void)
{
	return this->baseSoul;
}

const HEIGHT Species::GetAverageHeight(void)
{
	return this->averageHeight;
}

const WEIGHT Species::GetAverageWeight(void)
{
	return this->averageWeight;
}

const FEED Species::GetBaseFeed(void)
{
	return this->baseFeed;
}
