/*!
 * @file GameWorld.cpp
 * @brief Q[E`
 * @date 2013/12/22
 * @author Deskull
 * 2013 Sikabane Works.
 */

#include "stdafx.h"
#include "GameWorld.h"
#include "Deeangband.h"

GameWorld::GameWorld(GameSurface *gSurface)
{
	Dice::Initialize();

	gameSurface = gSurface;
	authorityList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Authority>(0, SPECIAL_TAG_UNKNOWN, this));
	creatureTraitList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<CreatureTrait>(0, SPECIAL_TAG_UNKNOWN, this));
	effectList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Effect>(0, SPECIAL_TAG_UNKNOWN, this));
	fixedArtifactList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<FixedArtifact>(0, SPECIAL_TAG_UNKNOWN, this));
	featureList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Feature>(0, SPECIAL_TAG_UNKNOWN, this));
	itemBaseList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<ItemBase>(0, SPECIAL_TAG_UNKNOWN, this));
	itemEgoList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<ItemEgo>(0, SPECIAL_TAG_UNKNOWN, this));
	itemTraitList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<ItemTrait>(0, SPECIAL_TAG_UNKNOWN, this));
	karmaList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Karma>(0, SPECIAL_TAG_UNKNOWN, this));
	skillList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Skill>(0, SPECIAL_TAG_UNKNOWN, this));
	speciesList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Species>(0, SPECIAL_TAG_UNKNOWN, this));
	trapBaseList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<TrapBase>(0, SPECIAL_TAG_UNKNOWN, this));
	buildingList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Building>(0, SPECIAL_TAG_UNKNOWN, this));
	campList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Camp>(0, SPECIAL_TAG_UNKNOWN, this));
	dungeonList.emplace(SPECIAL_TAG_UNKNOWN, make_shared<Dungeon>(0, SPECIAL_TAG_UNKNOWN, this));

	trapList.emplace(0, make_shared<Trap>(0, SPECIAL_TAG_UNKNOWN, this));
	itemList.emplace(0, make_shared<Item>(0, SPECIAL_TAG_UNKNOWN, this));
	floorList.emplace(0, make_shared<Floor>(0, SPECIAL_TAG_UNKNOWN, this));
	creatureList.emplace(0, make_shared<Creature>(0, SPECIAL_TAG_UNKNOWN, this));

	gSurface->SetFloor(&(*floorList[0]));
}

GameWorld::~GameWorld(void)
{
}

PLAY_EXIT_CODE GameWorld::PlayLoop(void)
{
	GAME_COMMAND commandID;
	PLAY_EXIT_CODE code = PLAY_EXIT_NONE;
	gameSurface->Redraw();

	while(code == PLAY_EXIT_NONE)
	{
		commandID = gameSurface->GetCommand();
		code = DoGameCommand(commandID);
	}

	return PLAY_EXIT_QUIT;
}

PLAY_EXIT_CODE GameWorld::DoGameCommand(GAME_COMMAND command)
{
	Creature dammy;
	switch(command)
	{
		case GAME_COMMAND_VIEW_PLAYER_STATUS:
			gameSurface->ViewCreatureStatus(&dammy);
			break;
		case GAME_COMMAND_REDRAW:
			gameSurface->Redraw();
			break;
		case GAME_COMMAND_EXIT:
			return PLAY_EXIT_QUIT;
			break;
	}
	return PLAY_EXIT_NONE;
}

Authority *GameWorld::GetAuthority(TAG tag)
{
	return &(*authorityList[tag]);
}

CreatureTrait *GameWorld::GetCreatureTrait(TAG tag)
{
	return &(*creatureTraitList[tag]);
}

Effect *GameWorld::GetEffect(TAG tag)
{
	return &(*effectList[tag]);
}

FixedArtifact *GameWorld::GetFixedArtifact(TAG tag)
{
	return &(*fixedArtifactList[tag]);
}

Feature *GameWorld::GetFeature(TAG tag)
{
	return &(*featureList[tag]);
}

ItemBase *GameWorld::GetItemBase(TAG tag)
{
	return &(*itemBaseList[tag]);
}

ItemEgo *GameWorld::GetItemEgo(TAG tag)
{
	return &(*itemEgoList[tag]);
}

ItemTrait *GameWorld::GetItemTrait(TAG tag)
{
	return &(*itemTraitList[tag]);
}

Karma *GameWorld::GetKarma(TAG tag)
{
	return &(*karmaList[tag]);
}

Skill *GameWorld::GetSkill(TAG tag)
{
	return &(*skillList[tag]);
}

Species *GameWorld::GetSpecies(TAG tag)
{
	return &(*speciesList[tag]);
}

TrapBase *GameWorld::GetTrapBase(TAG tag)
{
	return &(*trapBaseList[tag]);
}

Building *GameWorld::GetBuilding(TAG tag)
{
	return &(*buildingList[tag]);
}

Camp *GameWorld::GetCamp(TAG tag)
{
	return &(*campList[tag]);
}

Dungeon *GameWorld::GetDungeon(TAG tag)
{
	return &(*dungeonList[tag]);
}

Item *GameWorld::GetItem(ID id)
{
	return &(*itemList[id]);
}

Floor *GameWorld::GetFloor(ID id)
{
	return &(*floorList[id]);
}

Creature *GameWorld::GetCreature(ID id)
{
	return &(*creatureList[id]);
}
