/*!
 * @file Discipline.cpp
 * @brief Q[̏C{`
 * @date 2014/03/04
 * @author Deskull
 * 2014 Sikabane Works.
 */

#include "stdafx.h"
#include "Discipline.h"

Discipline::Discipline(int good, int evil, int order, int chaos, int balance)
{
	this->disciplinePoint[DISCIPLINE_TYPE_GOOD] = good;
	this->disciplinePoint[DISCIPLINE_TYPE_EVIL] = evil;
	this->disciplinePoint[DISCIPLINE_TYPE_ORDER] = order;
	this->disciplinePoint[DISCIPLINE_TYPE_CHAOS] = chaos;
	this->disciplinePoint[DISCIPLINE_TYPE_BALANCE] = balance;
}

Discipline::Discipline(void)
{
	this->disciplinePoint[DISCIPLINE_TYPE_GOOD] = 0;
	this->disciplinePoint[DISCIPLINE_TYPE_EVIL] = 0;
	this->disciplinePoint[DISCIPLINE_TYPE_ORDER] = 0;
	this->disciplinePoint[DISCIPLINE_TYPE_CHAOS] = 0;
	this->disciplinePoint[DISCIPLINE_TYPE_BALANCE] = 0;
}

Discipline::~Discipline(void)
{
}

void Discipline::SetPoint(DISCIPLINE_TYPE typ, int point)
{
	this->disciplinePoint[typ] = point;
}

void Discipline::SetPoint(int good, int evil, int order, int chaos, int balance)
{
	this->disciplinePoint[DISCIPLINE_TYPE_GOOD] = good;
	this->disciplinePoint[DISCIPLINE_TYPE_EVIL] = evil;
	this->disciplinePoint[DISCIPLINE_TYPE_ORDER] = order;
	this->disciplinePoint[DISCIPLINE_TYPE_CHAOS] = chaos;
	this->disciplinePoint[DISCIPLINE_TYPE_BALANCE] = balance;
}

void Discipline::PlusPoint(DISCIPLINE_TYPE typ, int point)
{
	this->disciplinePoint[typ] += point;
}

const DISCIPLINE_POINT Discipline::GetPoint(DISCIPLINE_TYPE typ)
{
	return this->disciplinePoint[typ];
}

const DISCIPLINE_POINT Discipline::GetRank(DISCIPLINE_TYPE typ)
{
	return (int)(sqrt(abs(this->disciplinePoint[typ]) / 250.0f) * (this->disciplinePoint[typ] > 0 ? 1 : -1));
}

Discipline Discipline::operator+(const Discipline& plus)
{
	this->disciplinePoint[DISCIPLINE_TYPE_GOOD] += plus.disciplinePoint[DISCIPLINE_TYPE_GOOD];
	this->disciplinePoint[DISCIPLINE_TYPE_EVIL] += plus.disciplinePoint[DISCIPLINE_TYPE_EVIL];
	this->disciplinePoint[DISCIPLINE_TYPE_ORDER] += plus.disciplinePoint[DISCIPLINE_TYPE_ORDER];
	this->disciplinePoint[DISCIPLINE_TYPE_CHAOS] += plus.disciplinePoint[DISCIPLINE_TYPE_CHAOS];
	this->disciplinePoint[DISCIPLINE_TYPE_BALANCE] += plus.disciplinePoint[DISCIPLINE_TYPE_BALANCE];
	return *this;
}

Discipline& Discipline::operator+=(const Discipline& plus)
{
	this->disciplinePoint[DISCIPLINE_TYPE_GOOD] += plus.disciplinePoint[DISCIPLINE_TYPE_GOOD];
	this->disciplinePoint[DISCIPLINE_TYPE_EVIL] += plus.disciplinePoint[DISCIPLINE_TYPE_EVIL];
	this->disciplinePoint[DISCIPLINE_TYPE_ORDER] += plus.disciplinePoint[DISCIPLINE_TYPE_ORDER];
	this->disciplinePoint[DISCIPLINE_TYPE_CHAOS] += plus.disciplinePoint[DISCIPLINE_TYPE_CHAOS];
	this->disciplinePoint[DISCIPLINE_TYPE_BALANCE] += plus.disciplinePoint[DISCIPLINE_TYPE_BALANCE];
	return *this;
}
