#include "MyTorpedo.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChipDepository.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"
#include "MyTorpedoBlast.h"
#include "jp/gecchi/VioletVreath/actor/my/MyTorpedoController.h"
#include "MyTorpedoTail.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

MyTorpedo::MyTorpedo(const char* prm_name, MyTorpedoController* prm_pOptionTorpedoController)
               : DefaultMeshSetActor(prm_name, "EffectLaserRefraction001", STATUS(MyTorpedo)) {
    _class_name = "MyTorpedo";
    pScaler_ = NEW GgafDxScaler(this);
    pOptionTorpedoCtrler_ = prm_pOptionTorpedoController;
    length_TailEffect_ = 8;
    begin_x_ = _x;
    begin_y_ = _y;
    begin_z_ = _z;

    pTailEffectDepository_ = NEW LaserChipDepository("Depo_TorpedoTailEffect");
    pTailEffectDepository_->config(length_TailEffect_, 0, nullptr);
    for (int i = 0; i < length_TailEffect_; i++) {
        std::string name = std::string(getName())+"'s Tail("+XTOS(i)+")";
        pTailEffectDepository_->put(NEW MyTorpedoTail(name.c_str(), this));
    }
    move_section_ = 0;
    addSubGroup(pTailEffectDepository_);
    effectBlendOne(); //ZTechniquew
    setZEnable(true);        //Zobt@͍lL
    setZWriteEnable(false);  //Zobt@͏ݖ
    pTarget_ = nullptr;
    useProgress(10);
    trz_ = try_ = 0;
    GgafDxSeTransmitterForActor* pSeTx = getSeTx();
    pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_TORPEDO");
}

void MyTorpedo::initialize() {
    CollisionChecker3D* pChecker = getCollisionChecker();
    pChecker->makeCollision(1);
    pChecker->setColliAAB_Cube(0, 70000);
}

void MyTorpedo::onReset() {
    pTarget_ = nullptr;
}

void MyTorpedo::onActive() {
    getStatus()->reset();
    setAlpha(0.3);
    _sx = _sy = _sz = 100;
    setScale(100);
    pScaler_->transitionLinerStep(7000, 500);
    GgafDxKuroko* pKuroko = getKuroko();
    pKuroko->setFaceAngVelo(D_ANG(3), D_ANG(5), D_ANG(7));
    if (pTarget_) {
        pKuroko->forceMvVeloRange(4000, 100000);
        pKuroko->setMvVelo(20000);
        pKuroko->setMvAcce(-600); //ŏ
    } else {
        pKuroko->forceMvVeloRange(4000, 70000);
        pKuroko->setMvVelo(10000);
        pKuroko->setMvAcce(-500); //ŏ
    }

    pKuroko->forceRzRyMvAngVeloRange(-40000, 40000);
    pKuroko->setRzRyMvAngVelo(0,0);
    pKuroko->setRzRyMvAngAcce(0,0);
    pKuroko->stopTurnMvAng();
    begin_x_ = _x;
    begin_y_ = _y;
    begin_z_ = _z;
    setHitAble(true);
    getProgress()->reset(MyTorpedo_IN_FIRE);
    move_section_ = 0;
    //^[Qbg̕AIvV̌Ăɔ΂
    trz_ = pOptionTorpedoCtrler_->pOrg_->_rz;
    try_ = pOptionTorpedoCtrler_->pOrg_->_ry;
}

void MyTorpedo::processBehavior() {
    GgafDxKuroko* pKuroko = getKuroko();
    GgafProgress* pProg = getProgress();
    if (pProg->get() == MyTorpedo_RELEASE) {
        if (pTailEffectDepository_->_num_chip_active == 0) {
            //OՃGtFNgSĔ񊈓ɂȂꍇ
            inactivate(); //gŌinactivate()
        } else {
            addAlpha(-0.05);
        }
    }

    if (pProg->get() == MyTorpedo_IN_FIRE) {
        //ۃGtFNgǉ
        if (pTailEffectDepository_->_num_chip_active < length_TailEffect_) {
            MyTorpedoTail* pTailEffect = (MyTorpedoTail*)pTailEffectDepository_->dispatch();
            if (pTailEffect) {
                pTailEffect->position(begin_x_,begin_y_,begin_z_);
            }
        }
        //̃[u
        if (move_section_ == 0) { //ˊJn`܂
            if (pKuroko->_velo_mv == pKuroko->_bottom_velo_mv) { //I
                pKuroko->setMvAcce(500);
                if (pTarget_) {
                    //^[QbeBÓATURN_ANTICLOSE_TO œă^[Qbg
                    pKuroko->turnMvAngTwd(pTarget_,
                                          2000, 200,
                                          TURN_ANTICLOSE_TO, false);
                } else {
                    pKuroko->turnRzRyMvAngTo(
                                trz_, try_,
                                1000, 100,
                                TURN_CLOSE_TO, false);
                }
                move_section_++;
            }
        }

        //[uP `]
        if (move_section_ == 1) {
            if (pKuroko->isTurningMvAng()) {
                //TURN_ANTICLOSE_TO^[Qbg҂
            } else {
                //TURN_ANTICLOSE_TO^[Qbg
                move_section_++;
            }
        }
        //[uQ ]`120t[Ԃ͂⋭pxŃ^[Qbg␳
        if (move_section_ == 2) {
            if (getActiveFrame() < 120) {
                if (getActiveFrame() % 16U == 0) {
                    if (pTarget_) {
                        if (pTarget_->isActiveInTheTree())  {
                            //^[QbgL
                            pKuroko->turnMvAngTwd(pTarget_,
                                                  1000, 200,
                                                  TURN_CLOSE_TO, false);

                        } else {
                            //^[QbgÂ܂܂܂
                            pKuroko->setRzRyMvAngVelo(0, 0);
                            pKuroko->setRzRyMvAngAcce(0, 0);
                        }
                    } else {
                        //^[QbgiIvV̌Ăցj
                        pKuroko->turnRzRyMvAngTo(
                                    trz_, try_,
                                    1000, 200,
                                    TURN_CLOSE_TO, false);
                    }
                } else {
                   //
                }
            } else {
                move_section_++;
            }
        }
        //[uR `300t[Ԃ͊ɂ₩ȊpxŃ^[Qbg␳
        if (move_section_ == 3) {
            if (getActiveFrame() < 300) {
                if (getActiveFrame() % 16U == 0) {
                    if (pTarget_) {
                        if (pTarget_->isActiveInTheTree())  {
                            //^[QbgL
                            pKuroko->turnMvAngTwd(pTarget_,
                                                  500, 0,
                                                  TURN_CLOSE_TO, false);
                        } else {
                            //^[QbgÂ܂܂܂
                            pKuroko->setRzRyMvAngVelo(0,0);
                            pKuroko->setRzRyMvAngAcce(0,0);
                        }
                    } else {
                        //^[QbgiIvV̌Ăցj
                        pKuroko->turnRzRyMvAngTo(
                                    trz_, try_,
                                    300, 0,
                                    TURN_CLOSE_TO, false);

                    }
                } else {
                   //
                }
            } else {
                move_section_++;
            }
        }
        //[uS
        if (move_section_ == 4) {
            pKuroko->setRzRyMvAngVelo(0,0);
            pKuroko->setRzRyMvAngAcce(0,0);
        }
        pKuroko->behave();
        pScaler_->behave();
    }
}

void MyTorpedo::processJudgement() {
    GgafProgress* pProg = getProgress();
    if (isOutOfUniverse() && pProg->get() == MyTorpedo_IN_FIRE) {
        setHitAble(false);
        pProg->change(MyTorpedo_RELEASE);
        GgafMainActor* pTailEffect = (GgafMainActor*)pTailEffectDepository_->getSubFirst();
        for (int i = 0; i < length_TailEffect_; i++) {
            pTailEffect->inactivateDelay(i+1); //OՃGtFNgXɏ悤ɗ\
            pTailEffect = pTailEffect->getNext();
        }
        getKuroko()->setMvVelo(0);
        //ginactive()processBehavior()ōs
        //̈ړGtFNgSinactive()ɂȂۂɎginactive()
    }

}

void MyTorpedo::onInactive() {
}

void MyTorpedo::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    //qbgʊт͂܂
    int sta = UTIL::calcMyStamina(this, pOther);
    setHitAble(false);

    GgafProgress* pProg = getProgress();
    pProg->change(MyTorpedo_RELEASE);
    GgafMainActor* pTailEffect = (GgafMainActor*)pTailEffectDepository_->getSubFirst();
    for (int i = 0; i < length_TailEffect_; i++) {
        pTailEffect->inactivateDelay(i+1); //OՃGtFNgXɏ悤ɗ\
        pTailEffect = pTailEffect->getNext();
    }
    getKuroko()->setMvVelo(0);
    //ginactive()processBehavior()ōs
    //̈ړGtFNgSinactive()ɂȂۂɎginactive()

    //
    MyTorpedoBlast* pBlast = (MyTorpedoBlast*)(pOptionTorpedoCtrler_->pDepo_TorpedoBlast_->dispatchForce());
    getSeTx()->play3D(SE_EXPLOSION);
    pBlast->reset();
    pBlast->positionAs(this);
}

MyTorpedo::~MyTorpedo() {
    GGAF_DELETE(pScaler_);
}
