#include "GgafEffectConst.fxh"
/**
 * @author Masatoshi Tsuge
 * @since 2010/12/21
 */
//G[̂߂ɂƂ肠ǉłƂ
float3 g_posCam_World;
float g_reflectance;
float g_specular;
float g_specular_power;

/** JWorldʒu */
float3 pos_camera;



/** fWorldϊs */
float4x4 g_matWorld;
/** fViewϊs */
float4x4 g_matView;
/** f̎ˉeϊs */
float4x4 g_matProj;
/** fWorldϊs̋ts */
float4x4 g_matInvWorld;
/** Cg̕ */
float3 g_vecLightFrom_World;
/** FiːFj*/
float4 g_colLightAmbient;
/** gUFiːFj*/
float4 g_colLightDiffuse;
/** f̃}eAFi\ʐFjBgUːFŊːF˂ */
float4 g_colMaterialDiffuse;
/** f̃eNX`_ŋ@\(GgafDxTextureBlinkerQ)̓_ŋx */
float g_tex_blink_power;
/** f̃eNX`_ŋ@\(GgafDxTextureBlinkerQ)̑ΏۂƂȂRGB̂l(0.0`1.0) */
float g_tex_blink_threshold;
/** At@J[e(tF[hCEAEg)@\(GgafDxAlphaCurtainQ)̃}X^[At@l(0.0`1.0) */
float g_alpha_master;
/** ݂̎ˉeϊsvfzfBJ牓̃Nbvʂ܂ł̋(ǂ܂ł̋\Ώۂj> zn */
float g_zf;
/** eNX`̃Tv[(s0 WX^ɃZbgꂽeNX`g) */
sampler MyTextureSampler : register(s0);
sampler CubeMapTextureSampler : register(s1);
sampler BumpMapTextureSampler : register(s2);

/** _VF[_[Ao͍\ */
struct OUT_VS {
    float4 posModel_Proj   : POSITION;    //ŏIIȒ_W([hEr[Eˉeϊς)
    float2 uv              : TEXCOORD0;   //_eNX`UV
    float4 color           : COLOR0;      //_J[
    float3 vecNormal_World : TEXCOORD1;   //_̖@xNg([hWn)
    float3 vecEye_World    : TEXCOORD2;   //_̎(_->_)xNg([hWn)
};

/** ov}bsOp_VF[_[Ao͍\ */
struct OUT_VS_BM {
    float4 posModel_Proj    : POSITION;    //ŏIIȒ_W([hEr[Eˉeϊς)
    float2 uv               : TEXCOORD0;   //_eNX`UV
    float4 color            : COLOR0;      //_J[
    float3 vecNormal_World  : TEXCOORD1;   //_̖@xNg([hWn)
    float3 vecEye_World    : TEXCOORD2;   //_̎(_->_)xNg([hWn)    
    //float3 vecEye_Tangent   : TEXCOORD2;   //_̎(_->_)xNg([J̐ڋԍWn)
    float4 vecLight_Tangent : TEXCOORD3;   //_̃CgxNg([J̐ڋԍWn)
    float4 vecHarf_Tangent  : TEXCOORD4;   //_̃n[txNg([J̐ڋԍWn)
};

/**
 * WIȒ_VF[_[ .
 * _obt@ɂ́A
 * _ World > View > ˉe ϊA_J[̐ݒsĂB
 * f̃}eAFtA܂
 * gUFAgUːFAFA}X^[At@AtHOA
 * xd̂߃sNZVF[_[ōs킸A_J[ŎĂB
 * @param prm_posModel_Local    f_̃[JW
 * @param prm_vecNormal_Local f_̖@
 * @param prm_vecNormal_Local f_UVW
 */
OUT_VS GgafDxVS_CubeMapMesh(
      float4 prm_posModel_Local  : POSITION,
      float3 prm_vecNormal_Local : NORMAL,
      float2 prm_uv              : TEXCOORD0
) {
    OUT_VS out_vs = (OUT_VS)0;

    //_vZ
    float4 posModel_World = mul(prm_posModel_Local, g_matWorld);
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //World*View*ˉe
    //UVvZ
    out_vs.uv = prm_uv;  //̂܂
    //_J[vZ
    //@ World ϊĐK
    out_vs.vecNormal_World = normalize(mul(prm_vecNormal_Local, g_matWorld));
    //@ƁAgU̓ς烉Cgˊp߁Aʂɑ΂gǓ߂B
    float power = max(dot(out_vs.vecNormal_World, -g_vecLightFrom_World ), 0);
    //gUFɌ悶AFZAŜ}eAF|B
    out_vs.color = (g_colLightAmbient + (g_colLightDiffuse*power)) * g_colMaterialDiffuse;
    //u_J_vxNg
    out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);
    //̓}eAŗDƂi㏑j
    out_vs.color.a = g_colMaterialDiffuse.a;
    //tHO
    if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
        out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
    }
//    if (out_vs.posModel_Proj.z > g_zf*0.98) {
//        out_vs.posModel_Proj.z = g_zf*0.98; //{OZłA`邽0.9ȓɏ㏑A
//    }
    return out_vs;
}

/**
 * ʏsNZVF[_[ieNX`Lj
 */
float4 GgafDxPS_CubeMapMesh(
    float2 prm_uv     : TEXCOORD0,
    float4 prm_color    : COLOR0,
    float3 prm_vecNormal_World : TEXCOORD1,
    float3 prm_vecEye_World    : TEXCOORD2   //_ -> _ xNg
) : COLOR  {
    float4 colTexCube = texCUBE(CubeMapTextureSampler, reflect(-prm_vecEye_World, prm_vecNormal_World));
    float4 colTex2D   = tex2D( MyTextureSampler, prm_uv);

    float s = 0.0f; //XyL
    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        float3 vecHarf = normalize(prm_vecEye_World + (-g_vecLightFrom_World));
        //n[txNgƖ@̓ςXyLvZ
        s = pow( max(0.0f, dot(prm_vecNormal_World, vecHarf)), g_specular ) * g_specular_power;
    }

    float4 colOut = (colTex2D * prm_color) + (colTexCube*g_reflectance) + s;
    //Blinkerl
    if (colTex2D.r >= g_tex_blink_threshold || colTex2D.g >= g_tex_blink_threshold || colTex2D.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //+ (colTex2D * g_tex_blink_power);
    }

    colOut.a = prm_color.a * colTex2D.a * colTexCube.a * g_alpha_master;
    return colOut;
}

/**
 * [Jڋԕϊ sԂ .
 * ڋԂƂ̓bVT[tFCX̂_ɂāA
 * eNX`uxNg, eNX`vxNg, @xNg 
 * Rŕ\Wn̎BR͒ĂB<BR>
 * w}yP[ǂƃRx̋L <BR>
 * http://marupeke296.com/DXPS_S_No5_NormalMap.html<BR>
 * pĒ܂B<BR>
 * @param prm_vecTangent  ڃxNg(uPʃxNg)
 * @param prm_vecBinormal ]@xNg(vPʃxNg)
 * @param prm_vecNormal   @xNg
 **/
float4x4 getInvTangentMatrix(
    float3 prm_vecTangent,
    float3 prm_vecBinormal,
    float3 prm_vecNormal )
{
    float4x4 mat = { float4(prm_vecTangent , 0.0f),
                     float4(prm_vecBinormal, 0.0f),
                     float4(prm_vecNormal  , 0.0f)  ,
                     {  0.0f, 0.0f, 0.0f, 1.0f } };
    return transpose( mat );  // ]u(搳Kn̍s̋ts͓]usŗǂ)
}


OUT_VS_BM GgafDxVS_BumpMapping(
      float4 prm_posModel_Local    : POSITION,
      float3 prm_vecNormal_Local : NORMAL,
      float2 prm_uv     : TEXCOORD0,
      float3 prm_vecTangent_Local  : TEXCOORD1,
      float3 prm_vecBinormal_Local : TEXCOORD2
) {
    OUT_VS_BM out_vs = (OUT_VS_BM)0;

    //_vZ
    float4 posModel_World = mul(prm_posModel_Local, g_matWorld);
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //World*View*ˉe
    //UVvZ
    out_vs.uv = prm_uv;  //̂܂
    //@ World ϊĐK
    out_vs.vecNormal_World = normalize(mul(prm_vecNormal_Local, g_matWorld));
    // ڋԍs̋tsZo
    float4x4 matTangent = getInvTangentMatrix(prm_vecTangent_Local, prm_vecBinormal_Local, prm_vecNormal_Local );

    // WorldCgxNgڋԂɈڂ
    float3 vecLight_Local = mul(-g_vecLightFrom_World, g_matInvWorld); //[Jɖ߂āiTODO:͗\ߌvZłcj
    out_vs.vecLight_Tangent = mul(vecLight_Local, matTangent);         //ڋԍWn

    //[h_u_J_vxNgڋԂɈڂiXyLŎgpj
    out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);

    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        float3 vecHarf_World = normalize(out_vs.vecEye_World + (-g_vecLightFrom_World));
        //Worldn[txNgڋԂɈڂ
        float3 vecHarf_Local = mul(vecHarf_World, g_matInvWorld); //[Jɖ߂
        out_vs.vecHarf_Tangent = mul(vecHarf_Local, matTangent ); //ڋԍWn
    }

    out_vs.color = g_colMaterialDiffuse;
    //̓}eAŗDƂi㏑j
    out_vs.color.a = g_colMaterialDiffuse.a;
    //tHO
    if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
        out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
    }
//    if (out_vs.posModel_Proj.z > g_zf*0.98) {
//        out_vs.posModel_Proj.z = g_zf*0.98; //{OZłA`邽0.9ȓɏ㏑A
//    }
    return out_vs;
}


/**
 * GgafLib::DefaultMeshActor ov}bsOp̃sNZVF[_[ .
 * @param prm_uv               UVW
 * @param prm_color            Fi_J[ɂj
 * @param prm_vecNormal_World  @xNg(WorldWn)
 * @param prm_vecEye_World     (_->_)xNg(WorldWn)
 * @param prm_vecLight_Tangent gUxNg(ڋԍWn)
 * @param prm_vecHarf_Tangent  n[txNg(ڋԍWn)
 */
float4 GgafDxPS_BumpMapping(
    float2 prm_uv     : TEXCOORD0,
    float4 prm_color  : COLOR0,
    float3 prm_vecNormal_World  : TEXCOORD1,
    float3 prm_vecEye_World     : TEXCOORD2,   //_ -> _ xNg
    float3 prm_vecLight_Tangent : TEXCOORD3,  //ڋԍWnɕϊꂽgUxNg
    float3 prm_vecHarf_Tangent  : TEXCOORD4   //ڋԍWnɕϊꂽn[txNg
) : COLOR  {
    float a = prm_color.a; //ێ
    //@}bv̖@
    float3 vecNormal_Tangent = normalize(2.0f * tex2D( BumpMapTextureSampler, prm_uv ).xyz - 1.0);
    //@(@}bv̖@A܂ڋԍWn̖@ɂȂjƁA
    //gUxNg(_VF[_[ŐڋԍWnɗ\ߕϊς) ̓ς
    //Cgˊp߁Aʂɑ΂gǓ(power)߂
    float power = max(dot(vecNormal_Tangent, normalize(prm_vecLight_Tangent) ), 0);

    float4 colTexCube = texCUBE(CubeMapTextureSampler, reflect(-prm_vecEye_World, prm_vecNormal_World)); //@}bv̓ʉ͖lB   
    float4 colTex2D   = tex2D( MyTextureSampler, prm_uv);  //@}bv̓ʉ͖lB

    float s = 0.0f; //XyL
    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNg
        //ڋԍWnɗ\ߕϊς݁jƖ@(@}bv̖@A܂ڋԍWn̖@)̓ςXyLvZ
        s = pow( max(0.0f, dot(vecNormal_Tangent, prm_vecHarf_Tangent)), g_specular ) * g_specular_power; //@}bv̓ʉlB
    }

    //FvZ
    float4 colOut = colTex2D * ((g_colLightAmbient + ( g_colLightDiffuse * power)) * prm_color ) + (colTexCube*g_reflectance) +s; //prm_color == g_colMaterialDiffuse
    //TODO:FvZƒ_VF[_ŏłȂ̂EEE
    //float4 colOut = (colTex2D * prm_color) + (colTexCube*g_reflectance) + s;

    //Blinkerl
    if (colTex2D.r >= g_tex_blink_threshold || colTex2D.g >= g_tex_blink_threshold || colTex2D.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //+ (colTex2D * g_tex_blink_power);
    }

    colOut.a = prm_color.a * colTex2D.a * colTexCube.a * g_alpha_master;
    return colOut;
}

float4 PS_Flush(
    float2 prm_uv     : TEXCOORD0,
    float4 prm_color    : COLOR0,
    float3 prm_vecNormal_World : TEXCOORD1,
    float3 prm_vecEye_World    : TEXCOORD2   //_ -> _ xNg
) : COLOR  {
    float4 colTexCube = texCUBE(CubeMapTextureSampler, reflect(-prm_vecEye_World, prm_vecNormal_World));
    float4 colTex2D   = tex2D( MyTextureSampler, prm_uv);
    float4 colOut = ((colTex2D * prm_color) + (colTexCube*g_reflectance))  * FLUSH_COLOR;
    colOut.a = prm_color.a * colTex2D.a * colTexCube.a * g_alpha_master;
    return colOut;
}

/**
 * ʏeNjbN
 */
technique CubeMapMeshTechnique
{
    //pass P0ubVWVF[_[v
    //bV`悷
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_CubeMapMesh();
        PixelShader  = compile PS_VERSION GgafDxPS_CubeMapMesh();
    }
}

technique BumpMapping
{
    //pass P0ubVWVF[_[v
    //bV`悷
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_BumpMapping();
        PixelShader  = compile PS_VERSION GgafDxPS_BumpMapping();
    }
}


technique DestBlendOne
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_CubeMapMesh();
        PixelShader  = compile PS_VERSION GgafDxPS_CubeMapMesh();
    }
}

technique Flush
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_CubeMapMesh();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}

