#include "jp/ggaf/lib/actor/laserchip/WateringLaserChip.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

WateringLaserChip::WateringLaserChip(const char* prm_name, const char* prm_model, GgafStatus* prm_pStat) :
            LaserChip(prm_name, prm_model, prm_pStat) {
    _class_name = "WateringLaserChip";
    _tmpX = 0;
    _tmpY = 0;
    _tmpZ = 0;
}

void WateringLaserChip::onActive() {
    //[U[`bvo
    //Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
    //̍ ́A{NX onActive() \bhĂяoĂB
    LaserChip::onActive();
    _tmpX = _x;
    _tmpY = _y;
    _tmpZ = _z;
}

void WateringLaserChip::processBehavior() {
    //WRs[
    _tmpX = _x;
    _tmpY = _y;
    _tmpZ = _z;
}
void WateringLaserChip::processSettlementBehavior() {
    //ϋȐWݒB([U[炩ɂm[}CYj
    //processSettlementBehavior() ̃\bḧӋ`Ƃ͗čWړĂB
    //{ processBehaviorAfter() IȈӖ̏ł邪AS[U[`bvړłȂƈӖȂ̂
    //dȂ̂processSettlementBehavior()ɐHł܂B
    //Ė{NXpꍇApNXprocessSettlementBehavior()ł́A擪ŌĂяoǂB
    if (_was_paused_flg) {
        GgafDxGeometricActor::processSettlementBehavior();
    } else {
        WateringLaserChip* pF = (WateringLaserChip*)_pChip_front;
        WateringLaserChip* pB = (WateringLaserChip*)_pChip_behind;
        if (pF && pB && pF->_is_active_flg && pB->_is_active_flg) {
            //_pChip_behind == nullptr ̔肾ł͂߁B_pChip_behind->_is_active_flg Ɣ肷邱
            //ȂȂ dispatch ̏uԂ_pChip_behind != nullptr ƂȂ邪Aactive()ɂLɂȂ͎̂t[
            //_x,_y,_z ɂ͂܂ςȒlĂB

            //ԍWɍĐݒ
            _x = ((pF->_tmpX + pB->_tmpX)/2 + _tmpX)/2;
            _y = ((pF->_tmpY + pB->_tmpY)/2 + _tmpY)/2;
            _z = ((pF->_tmpZ + pB->_tmpZ)/2 + _tmpZ)/2;
        }
        LaserChip::processSettlementBehavior();
    }
}


WateringLaserChip::~WateringLaserChip() {
}

