#ifndef MYOPTION_H_
#define MYOPTION_H_
#include "jp/ggaf/lib/actor/DefaultMeshSetActor.h"


#define OPT_RADIUS_POS_MIN (PX_C(30))
#define OPT_RADIUS_POS_MAX (PX_C(1000))

namespace VioletVreath {

//class MyOption : public GgafLib::DefaultMorphMeshActor {
class MyOption : public GgafLib::DefaultMeshSetActor {


private:
    /**
     * ~aĐݒ肷 .
     * ̏ł̂݌Ăяo\B
     * @param prm_radius a
     */
    void setRadiusPosition(int prm_radius);

    /**
     * ~aōĐݒ肷 .
     * ̏ł̂݌Ăяo\B
     * @param prm_radius_offset a
     * @param prm_min_radius Œᔼa
     */
    void addRadiusPosition(int prm_radius_offset, int prm_min_radius = OPT_RADIUS_POS_MIN, int prm_max_radius = OPT_RADIUS_POS_MAX);

public:
    enum {
        SE_FIRE_LASER  ,
        SE_FIRE_SHOT   ,
        SE_FIRE_TORPEDO,
    };

    //ꎞϐB
    coord x_org_,y_org_,z_org_;

    /** [r]eAN^[ */
    MyOptionController* pOptionCtrler_;
    /** [r]g̃IvVԍ(O`EEE) */
    int no_;

    /** [r]bNIRg[[ */
    MyLockonController* pLockonCtrler_;
    /** [r]Rg[[ */
    MyTorpedoController* pTorpedoCtrler_;
    /** [r]˂郌[U[`bṽf|Wg */
    GgafLib::LaserChipDepository* pLaserChipDepo_;
    /** [r]˂Vbg̃f|Wg */
    GgafCore::GgafActorDepository* pDepo_MyOptionShot_;
    /** [r][U[˒̃GtFNg */
    GgafDxCore::GgafDxDrawableActor* pEffect_LaserIrradiate_;

    /** [r]vZꂽ݂̐~ړpxiǂݏopj */
    angvelo angveloMove_;
    /** [r]~㏉ʒupxi͊pjiinitialize()܂łɕύX^ftHg=0j */
    angle angPosition_;
    /** [r]݂̐~aiinitialize()܂łɕύX^ftHg=200000j */
    int radiusPosition_;
    /** [r/w]~ړxiύX^ftHg=1000j */
    velo veloMv_;
    /** [r/w]IvV̍L]piύX^ftHg=0 MyOptionControllerƓiOjĂj */
    angle angExpanse_;

    /** [r]~pxʒu */
    angle angPosition_base_;
    /** [r]~a */
    int radiusPosition_base_;
    /** [r]~ɖ߂ׂ~a */
    int radiusPosition_stopping_;
    /** [r]aړx(OPTION쎞) */
    int radiusPosition_velo_;

    /** [r]~ړx */
    velo veloMv_base_;
    /** [r]IvV̍L]p */
    angle angExpanse_default_;

    /** IvV̍L]pxiʏ펞j */
    angvelo angveloExpanseNomal_;
    /** IvV̍L]pxij */
    angvelo angveloExpanseSlow_;

    /** IvV̏ʒuɎ߂sĂŒ true */
    bool return_to_base_radiusPosition_seq_;
    /** IvV̏~aɎ߂sĂŒ true */
    bool return_to_base_angExpanse_seq_;


    /** [r]~pxʒu֎߂V[NGXiԍ */
    int adjust_angPos_seq_progress_;
    /** [r]~pxʒu֎߂V[NGXA^[Qbg~pxʒu */
    angle adjust_angPos_seq_new_angPosition_base_;
    /** [r]~pxʒu֎߂V[NGXA^[Qbg~pxʒuɓB܂łɔ₳t[ */
    frame adjust_angPos_seq_spent_frame_;

    //GgafDxCore::GgafDxQuaternion Q_;
    EffectMyOption* pEffect_;

    /** [r]~A~pxʒu֎߂V[NGX̎sKvǂtO */
    bool need_adjust_pos_flg_;

public:
    /**
     * RXgN^ .
     * @param prm_name
     * @param prm_no IvVԍi0`...)
     * @param prm_pOptCtrler eAN^[
     * @return
     */
    MyOption(const char* prm_name, uint32_t prm_no, MyOptionController* prm_pOptCtrler);

    /**
     * ݒp[^[ .
     * ォinitialize()܂łɐݒ肷邱ƂłA
     * IuWFNgŗLp[^łB
     * @param prm_radiusPosition @̔aw
     * @param prm_angPosition Lả~ɂĂ̈ʒu~pŎw
     * @param prm_angExpanse L̈ʒuł̃IvV́uOvwB0Ő
     * @param prm_veloMv ړxw
     */
    void config(
            angle prm_radiusPosition,
            angle prm_angPosition,
            angle prm_angExpanse,
            velo prm_veloMv)
    {
        angPosition_ = prm_angPosition;
        angExpanse_ = prm_angExpanse;
        veloMv_ = prm_veloMv;
        angPosition_base_ = prm_angPosition;
        radiusPosition_base_ = prm_radiusPosition;
        radiusPosition_ = radiusPosition_base_;
        radiusPosition_stopping_ = radiusPosition_base_;
        radiusPosition_velo_ = 3000 * (radiusPosition_base_/60000);
        angExpanse_default_ = prm_angExpanse;
        veloMv_base_ = prm_veloMv;
        reset();
    }
    void onCreateModel() override;

    void initialize() override;

    void onReset() override;

    void onActive() override;

    void processBehavior() override;

    void processJudgement() override;

    void onInactive() override;

    void onHit(GgafCore::GgafActor* prm_pOtherActor) override;

    virtual ~MyOption();


    void adjustAngPosition(angle prm_new_angPosition_base, frame prm_spent_frame);

};

}
#endif /*MYOPTION_H_*/

