#ifndef GGAFLIB_FIXEDFRAMESPLINEMANUFACTURE_H_
#define GGAFLIB_FIXEDFRAMESPLINEMANUFACTURE_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/lib/util/spline/SplineManufacture.h"

namespace GgafLib {

/**
 * ԌŒ莞ԁit[jړɂAXvCȐړ̂߂̏Zbg .
 * SẴAN^[ɋʂXvC̏͂ɏWB
 * @version 1.00
 * @since 2009/10/28
 * @author Masatoshi Tsuge
 */
class FixedFrameSplineManufacture : public SplineManufacture {

public:
    /** [r]PԂ̎gp\t[ */
    float _fFrame_of_segment;
    /** [r]̕⊮_BɕKvȈړx̃e[u */
    velo* _paSPMvVeloTo;
    /** [rw]1t[\ȉ]ppx */
    angvelo _angveloRzRyMv;
    /** [rw]@ */
    int _turn_way;
    /** [rw]œKL */
    bool _turn_optimize;
    /** [r]ŏIn_܂ł̃t[ */
    frame _spent_frame;

public:
    /**
     * RXgN^ .
     * @param prm_source_file XvCWt@C
     * @param prm_spent_frame n_(AN^[̌Wł͂Ȃ)`ŏIn_܂ł̃t[
     * @param prm_angveloRzRyMv AN^[̐px
     * @param prm_turn_way AN^[̐@(ftHg TURN_CLOSE_TO)
     * @param prm_turn_optimaize AN^[̐̍œKIvV(ftHg false)
     */
    FixedFrameSplineManufacture(const char* prm_source_file,
                                frame prm_spent_frame,
                                angvelo prm_angveloRzRyMv = (D90ANG/9),
                                int prm_turn_way = TURN_CLOSE_TO,
                                bool prm_turn_optimaize = false );

    /**
     * RXgN^ .
     * @param prm_pSplSrc XvCWIuWFNg
     * @param prm_spent_frame n_(AN^[̌Wł͂Ȃ)`ŏIn_܂ł̃t[
     * @param prm_angveloRzRyMv AN^[̐px
     * @param prm_turn_way AN^[̐@ (ftHg TURN_CLOSE_TO)
     * @param prm_turn_optimaize AN^[̐̍œKIvV(ftHg false)
     */
    FixedFrameSplineManufacture(SplineSource* prm_pSplSrc,
                                frame prm_spent_frame,
                                angvelo prm_angveloRzRyMv = (D90ANG/9),
                                int prm_turn_way = TURN_CLOSE_TO,
                                bool prm_turn_optimaize = false );
    /**
     * ivZj .
     * vpeBύXꍇAe[uXV邽߂
     * xsKv܂B
     */
    void calculate() override;

    /**
     * SplineKurokoLeaderIuWFNg̐ .
     * CX^X FixedFrameSplineManufacture łB
     * @param prm_pKuroko XvCړΏۃAN^[
     * @return SplineKurokoLeaderIuWFNg
     */
    SplineKurokoLeader* createKurokoLeader(GgafDxCore::GgafDxKuroko* const prm_pKuroko) override;

    virtual ~FixedFrameSplineManufacture();
};

}
#endif /*GGAFLIB_FIXEDFRAMESPLINEMANUFACTURE_H_*/
