#ifndef GGAFDXCORE_GGAFDXINPUT_H_
#define GGAFDXCORE_GGAFDXINPUT_H_
#include "GgafDxCommonHeader.h"

#include <dinput.h>

//PL[Ƃ_TRACE_(fobOp)
#define _PTRACE_(M) {if (GgafDxCore::GgafDxInput::isBeingPressedKey(DIK_P)) { _TRACE_(M); }}

namespace GgafDxCore {

/**
 * DirectInput [eBeBNX .
 * @version 1.00
 * @since 2006/01/10
 * @author Masatoshi Tsuge
 */
class GgafDxInput {

public:
    /** IDirectInput8C^[tFCX */
    static LPDIRECTINPUT8 _pIDirectInput8;
    /** L[{[hCvbgfoCX */
    static LPDIRECTINPUTDEVICE8 _pKeyboardInputDevice;
    /** WCXeBbNCvbgfoCX */
    static LPDIRECTINPUTDEVICE8 _pJoystickInputDevice;
    /** }EXCvbgfoCX */
    static LPDIRECTINPUTDEVICE8 _pMouseInputDevice;
    /** WCXeBbN̐\ */
    static DIDEVCAPS _devcap;

    //static const int BUFFER_SIZE;

    /** }EXԁi\Aj*/
    static DIMOUSESTATE2 _mouse_state[2];
    /** ݃ANeBuȃ}EXԂ̕\(0:\^1:) */
    static int _flip_ms;
    /** L[{[h̏ԁi\Aj */
    static char _keyboard_state[2][256];
    /** ݃ANeBuȃL[{[hԂ̕\(0:\^1:) */
    static int _flip_ks;
    /** WCXeBbN̏(0:\^1:)  */
    static DIJOYSTATE _joy_state[2];
    /** ݃ANeBuȃWCXeBbNԂ̕\(0:\^1:) */
    static int _flip_js;

public:
    /**
     *  .
     * gpOPxĂяoKvB
     */
    static HRESULT init();

    /**
     * {^񋓃R[obN֐ .
     * e̍Œl -255Aōl 255 ɐݒ
     * @param lpddoi
     * @param pvRef
     * @return
     */
    static BOOL CALLBACK enumPadAxisCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef);

    /**
     * Q[XeBbNfoCX񋓃R[obN֐ .
     * @param pDIDeviceInstance
     * @param pContext
     * @return
     */
    static BOOL CALLBACK enumGameCtrlCallback(const DIDEVICEINSTANCE *pDIDeviceInstance, VOID *pContext);

    /**
     * }EX̏ԂXV .
     * ʂ _mouse_state ̕\Ɋi[B
     */
    static void updateMouseState();

    /**
     * }EX̃{^̏Ԃ𒲂ׂ .
     * @param prm_button_no }EX{^ԍ
     * @return trueF̃{^͉ĂԂł^falseFł͖
     */
    static bool isBeingPressedMouseButton(int prm_button_no);

    /**
     * }EX̃{^ꂽ̏Ԃ𒲂ׂ .
     * @param prm_button_no }EX{^ԍ
     * @return trueF̃{^͉ꂽł^falseFł͖
     */
    static bool isPushedDownMouseButton(int prm_button_no);

    /**
     * }EX̃{^ꂽ̏Ԃ𒲂ׂ .
     * @param prm_button_no }EX{^ԍ
     * @return trueF̃{^͗ꂽł^falseFł͖
     */
    static bool isReleasedUpMouseButton(int prm_button_no);

    /**
     * }EX|C^̍W𒲂ׂ .
     * @param x [out]|C^XWԂ
     * @param y [out]|C^YWԂ
     * @param z [out]zC[̏ԂԂ
     */
    static void getMousePointer(long* x, long* y, long* z);

    /**
     * }EX|C^̈ړʂ𒲂ׂ .
     * @param dx [out]|C^XẄړʂԂ
     * @param dy [out]|C^YẄړʂԂ
     * @param dz [out]zC[̈ړʂԂ
     */
    static void getMousePointer_REL(long* dx, long* dy, long* dz);

    /**
     * L[{[h̏ԂXV .
     * ʂ _keyboard_state ̕\Ɋi[B
     */
    static void updateKeyboardState();

    /**
     * L[{[h̃L[̏Ԃ𒲂ׂ .
     * @param prm_DIK ׂL[(DIK_*)
     * @return trueF̃L[͉ĂԂł^falseFł͖
     */
    static inline bool isBeingPressedKey(int prm_DIK) {
        return (_keyboard_state[_flip_ks][prm_DIK] & 0x80) ? true : false;
    }

    /**
     * ĂL[{[h̃L[𒲂ׂ .
     * @return ꂽL[(DIK_* 萔) / -1:ĂȂ
     */
    static inline int getBeingPressedKey() {
        for (int i = 0x00; i <= 0xED; i ++) {
            if (_keyboard_state[_flip_ks][i] & 0x80) {
                return i;
            }
        }
        return -1;
    }

    /**
     * L[{[h̃L[ꂽ̏Ԃ𒲂ׂ .
     * @param prm_DIK ׂL[(DIK_*)
     * @return trueF̃L[͉ꂽł^falseFł͖
     */
    static bool isPushedDownKey(int prm_DIK);

    /**
     * L[{[h̉ꂽ̃L[𒲂ׂ .
     * @return ꂽ̃L[(DIK_*) / 0:ĂȂ
     */
    static int getPushedDownKey();

    /**
     * L[{[h̃L[ꂽ̏Ԃ𒲂ׂ .
     * @param prm_DIK prm_DIK ׂL[(DIK_*)
     * @return trueF̃L[͗ꂽł^falseFł͖
     */
    static bool isReleasedUpDownKey(int prm_DIK);

    /**
     * WCXeBbN̏ԂXV .
     * ʂ _joy_state Ɋi[B
     */
    static void updateJoystickState();

    /**
     * WCXeBbÑ{^̏Ԃ𒲂ׂ .
     * @param prm_rgb_button_no WCXeBbN{^ԍ
     * @return  trueF̃{^͉ĂԂł^falseFł͖
     */
    static inline bool isBeingPressedJoyRgbButton(int prm_rgb_button_no) {
        return (_joy_state[_flip_js].rgbButtons[prm_rgb_button_no] & 0x80) ? true : false;
    }

    /**
     * ĂWCXeBbÑ{^𒲂ׂ .
     * @return ꂽWCXeBbN{^ԍ(0`12) / -1:ĂȂ
     */
    static inline int getBeingPressedJoyRgbButton() {
        for (int i = 0; i < 13; i ++) {
            if (_joy_state[_flip_js].rgbButtons[i] & 0x80) {
                return i;
            }
        }
        return -1;
    }

    static bool isPushedDownJoyRgbButton(int prm_rgb_button_no);

    static int getPushedDownJoyRgbButton();

    /**
     * WCXeBbN̏̏Ԃ𒲂ׂ .
     * @return trueFWCXeBbN̏ONł^falseFł͖
     */
    static inline bool isBeingPressedJoyUp() {
        return (_joy_state[_flip_js].lY < -127) ? true : false;
    }

    /**
     * WCXeBbN̉̏Ԃ𒲂ׂ .
     * @return trueFWCXeBbN̉ONł^falseFł͖
     */
    static inline bool isBeingPressedJoyDown() {
        return (_joy_state[_flip_js].lY > 127) ? true : false;
    }

    /**
     * WCXeBbN̍̏Ԃ𒲂ׂ .
     * @return trueFWCXeBbN̍ONł^falseFł͖
     */
    static inline bool isBeingPressedJoyLeft() {
        return (_joy_state[_flip_js].lX < -127) ? true : false;
    }

    /**
     * WCXeBbN̉ȄԂ𒲂ׂ .
     * @return trueFWCXeBbN̉EONł^falseFł͖
     */
    static inline bool isBeingPressedJoyRight() {
        return (_joy_state[_flip_js].lX > 127) ? true : false;
    }

    /**
     * WCXeBbÑAiOXeBbN̏̕Ԃ𒲂ׂ .
     * @param prm_direction_no ׂԍ(WAeL[̔ԍɑΉ)
     * @return trueF̕ԍONł^falseFł͖
     */
    static bool isBeingPressedJoyDirection(int prm_direction_no);

    static void release();

};

}
#endif /*GGAFDXCORE_GGAFDXINPUT_H_*/
