#ifndef GGAFDXCORE_GGAFDXGEOMETRICACTOR_H_
#define GGAFDXCORE_GGAFDXGEOMETRICACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxBaseActor.h"

#include <D3dx9math.h>

namespace GgafDxCore {

/**
 * WA]AXP[AN^[.
 * [hWA͕ϊςݍW̉ꂩA<BR>
 * W֘A\bhAN^[łB<BR>
 * (GgafDxUntranceformedActor GgafDxTranceformedActor 𓝍)
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class GgafDxGeometricActor : public GgafDxBaseActor {

private:
    /**
     * ʂŎgp֎~ .
     */
    void processFinal() override {
    }

    /** [r] */
    GgafDxKuroko* const _pKuroko;
    /** [r]ʉǗIuWFNg */
    GgafDxSeTransmitterForActor* const _pSeTx;

public:
    /** [r] ϊςݍWł邩(true:{AN^[͕ϊςݍW/false:{AN^[̓[hW) */
    bool _is_2D;
    /** [r] ʊOʁBisOutOfView()ŎgpBvZ -1 */
    int _offscreen_kind;

    /** [r/w][hXW( _x : DirectXXW : Jʒuł̉ʏsNZ = 1000 : 0.1 :  1px  ) */
    coord _x;
    /** [r/w][hYW( _y : DirectXYW : Jʒuł̉ʏsNZ = 1000 : 0.1 :  1px  ) */
    coord _y;
    /** [r/w][hZW( _z : DirectXZW : Jʒuł̉ʏsNZ = 1000 : 0.1 :  1px  ) */
    coord _z;
    /** [r/w][hX]p(_rx : Degree = 1000 : 1x) */
    angle _rx;
    /** [r/w][hY]p(_ry : Degree = 1000 : 1x) */
    angle _ry;
    /** [r/w][hZ]p(_rz : Degree = 1000 : 1x) */
    angle _rz;
    /** [r/w][hXXP[(_sx : { = 1000 : 1.0{) */
    scale _sx;
    /** [r/w][hYXP[(_sy : { = 1000 : 1.0{) */
    scale _sy;
    /** [r/w][hZXP[(_sz : { = 1000 : 1.0{) */
    scale _sz;
    /** [r]`FbJ[ */
    GgafDxChecker* _pChecker;


    /** [r]E̔a(DirectX̒P)BʊOɎgp */
    dxcoord _bounding_sphere_radius;
    /** [r]f̋Ea{ */
    dxcoord _rate_of_bounding_sphere_radius;
    /** [r] _x vZDirectX̃[hXW(_x : _fX = 1000 : 0.1) */
    dxcoord _fX;
    /** [r] _y vZDirectỸ[hYW(_y : _fY = 1000 : 0.1) */
    dxcoord _fY;
    /** [r] _z vZDirectZ̃[hZW(_z : _fZ = 1000 : 0.1) */
    dxcoord _fZ;
    /** [r]ʂ王OɌĂ̎g̍W܂łDirectX̋A͕̋̒lɂȂ */
    dxcoord _dest_from_vppln_top;
    /** [r]䉺ʂ王OɌĂ̎g̍W܂łDirectX̋A͕̋̒lɂȂ */
    dxcoord _dest_from_vppln_bottom;
    /** [r]䍶ʂ王OɌĂ̎g̍W܂łDirectX̋A͕̋̒lɂȂ */
    dxcoord _dest_from_vppln_left;
    /** [r]Eʂ王OɌĂ̎g̍W܂łDirectX̋A͕̋̒lɂȂ */
    dxcoord _dest_from_vppln_right;
    /** [r]Oʂ王OɌĂ̎g̍W܂łDirectX̋A͕̋̒lɂȂ */
    dxcoord _dest_from_vppln_front;
    /** [r]䉜ʂ王OɌĂ̎g̍W܂łDirectX̋A͕̋̒lɂȂ */
    dxcoord _dest_from_vppln_back;
    /** [r/w]WORLDϊ(]~ړ)svZ֐ */
    void (*_pFunc_calc_rot_mv_world_matrix)(GgafDxGeometricActor*, D3DXMATRIX&);
    /** [r]ǧ݂Worldϊs(ʏ́ugk~]~ړv)By䂪ꍇ́A̓yƍs̐ςɂȂĂB */
    D3DXMATRIX _matWorld;
    /** [r]ǧ݂Worldϊśu]~ړv̂݁By䂪ꍇ́A̓yƍs̐ςɂȂĂB */
    D3DXMATRIX _matWorldRotMv;
    /** [r]ǧ݂Worldϊśu]~ړv̋ts(]~ړ̃Co[X) */
    D3DXMATRIX _matInvWorldRotMv;
    /** [r]Jgt[Ŏǧ݂Worldϊs̋ts(_matInvWorldRotMv)vZċ߂ǂ̃tOB */
    bool _was_calculated_matInvWorldRotMv;

    /** [r]yƂȂAN^[Ay䂪ꍇnullptriFKpj */
    GgafDxCore::GgafDxGeometricActor* _pActor_base;
    /** [r]yAN^[ł̃[hXW */
    coord _x_local;
    /** [r]yAN^[ł̃[hYW */
    coord _y_local;
    /** [r]yAN^[ł̃[hZW */
    coord _z_local;
    /** [r]yAN^[ł̃[hX]p */
    angle _rx_local;
    /** [r]yAN^[ł̃[hY]p */
    angle _ry_local;
    /** [r]yAN^[ł̃[hZ]p */
    angle _rz_local;

    coord _x_final;
    coord _y_final;
    coord _z_final;
    angle _rx_final;
    angle _ry_final;
    angle _rz_final;

    bool _is_local;

    //⑫
    //y_x, _y, _z ̒Pʂɂāz
    //{t[[Nł́AR̍WP(XP[)B
    //dxcoord  EEE DirectXWPʁB
    //coord    EEE AvP[VƎ̓WPʁBiꂪCj
    //pixcoord EEE JʒuAz=0  xyʂɃLꍇ́Aʏł̃sNZlP
    //Wl _x, _y, _z  coord (ꂪC)łB
    //DirectXW(float)n̒l1.0ɑ _x, _y, _z WĺALEN_UNIT(=1000){PX_UNIT(=10){̐lłB
    //܂ADirectXWnPʂ1.0́AQ[ʏ10px̑傫ɂȂi悤ɃJĂjB
    //Ⴆ΁A_x = 5000 ́AʂŏJʒu 5px ̕ɌADirectXWł0.5ɂȂi悤ɐ݌vĂjB
    //_x,_y,_z      sNZ ̕ϊB    EEE _x,_y,_z  LEN_UNIT(=1000)ŊB
    //DirectXW   sNZ ̕ϊB    EEE DirectXWAPX_UNIT(=10)|ZB
    //_x,_y,_z      DirectXW ̕ϊB EEE _x,_y,_z  LEN_UNIT*PX_UNIT(=10000)ŊB
    //́A`̒O_x,_y,_z ͂ƂāA LEN_UNIT*PX_UNIT ZA[hϊs̒lɎgpĂB
    //킴킴ȂƂĂ̂́AQ[̍WvZ͑SĐōsAłxグ߁B
    //(;)͂悭gĂ@Ǝv̂A݂ł œKĂ float  double łȂ葬̂ŁA
    //{ɂ̐݌vł悩̂낤cAAȂĂƐMB
    //
    //y_rx, _ry, _rz ̒Pʂɂāz
    //ƎPʂ́uAOlv̂B
    //uAOlvƂ 0~3600000 ̒lŁAڂł pxl(Degree) 1000{̐x̒lłB
    //(AAۂ͓ł Degree  10{̐xłB3600̒PʕxNge[uƑΉ݌v)
    //1x1000A0.5x500Bp̒l90000A180000łB
    //SpƓ3̕0ƂA̐ĔvɃAOl͑̂ƂB
    //
    //y_sx, _sy, _sz ̒Pʂɂāz
    //l10001.0{̃XP[ӖBăftHg1000ɂȂĂB
    //`̒O 1000 ŏZAgkɕϊgpB

public:
    /**
     * RXgN^ .
     * @param prm_name AN^[
     * @param prm_pStat Xe[^X(gpȂ nullptr)
     * @param prm_pChecker `FbJ[(gpȂ nullptr)
     * @return
     */
    GgafDxGeometricActor(const char* prm_name,
                         GgafCore::GgafStatus* prm_pStat,
                         GgafDxChecker* prm_pChecker);

    /**
     * ̃AN^[擾
     * @return ̃AN^[
     */
    virtual GgafDxGeometricActor* getPrev() override {
        return (GgafDxGeometricActor*)GgafActor::getPrev();
    }

    /**
     * ÕAN^[擾
     * @return ÕAN^[
     */
    virtual GgafDxGeometricActor* getNext() override {
        return (GgafDxGeometricActor*)GgafActor::getNext();
    }

    /**
     * 菈O .
     * processBehavior() AWvZ㏈ƂĎ̏s <BR>
     * @g̍W(_x,_y,_z)ȉ̃o̍XVsB <BR>
     *     _fX <BR>
     *     _fY <BR>
     *     _fZ <BR>
     *     _dest_from_vppln_top <BR>
     *     _dest_from_vppln_bottom <BR>
     *     _dest_from_vppln_left <BR>
     *     _dest_from_vppln_right <BR>
     *     _dest_from_vppln_front <BR>
     *     _dest_from_vppln_back <BR>
     * A g̍W񂩂烏[hϊs쐬_matWorldɕێ
     * B processJudgement() ĂяôߏƂāA <BR>
     *    g̍W񂩂`Wؔzւ̓o^sB <BR>
     * C gtH[[V̏ꍇA
     *    gS~֑ۂɁAtH[[Vێ鎩gւ̃|C^NA
     * {\bh̓I[o[Ch\Ƃ邪At[[N̕`┻Ɋւ
     * dvȎÔ߁AI[o[Ch͐łȂB<BR>
     * ǂĂI[o[ChKvȏꍇ́AI[o[ChŁA <BR>
     * GgafDxGeometricActor::processSettlementBehavior() ĂяoA <BR>
     * L@ABƓ̏s悤ɂׂłB
     * tɌʃGtFNgȂǁAL̍lsvȃAN^[̏ꍇ́A{\bhI[o[ChA
     * _fX,_fY,_fẐݍXV邱ƂɂAptH[}Xコ邱ƂłB <BR>
     */
    virtual void processSettlementBehavior() override;

    /**
     * 蔻胍WbN .
     * 蔻胍WbNĂB<BR>
     * `FbJ[IuWFNgꍇA<BR>
     * GgafDxChecker::isHit() Ŕ肷B<BR>
     * `FbJ[IuWFNgꍇA<BR>
     * qbgĂȂƂƂB<BR>
     * @param prm_pOtherActor ̃AN^[
     * @return trueFqbgĂ^falseFqbgĂȂ
     */
    virtual bool processHitChkLogic(GgafActor* prm_pOtherActor) override;

    /**
     * ʓɕ\Ă邩 .
     * @return 0(false):Viewport͈͓
     *         1       :Viewport̏㕽ʂŔ͈͊O
     *         2       :Viewport̉ʂ艺Ŕ͈͊O
     *         3       :Viewport̍ʂ荶Ŕ͈͊O
     *         4       :Viewport̉EʂEŔ͈͊O
     *         5       :Viewport̎OʂOŔ͈͊O
     *         6       :Viewport̉ʂ艜Ŕ͈͊O
     *         D揇ʏɕł܂BiF1  4  1 Ԃ܂j
     */
    virtual int isOutOfView();

    /**
     * ݂̍WQ[͈͓ǂ .
     * ʓAʊOƂ͖֌W
     * @return true:͈͊O/false:͈͓
     */
    virtual bool isOutOfUniverse();

    /**
     * [hWݒ .
     * @param x
     * @param y
     * @param z
     */
    virtual void position(coord x, coord y, coord z) {
        _x = x;
        _y = y;
        _z = z;
    }

    /**
     * [hWݒ .
     * @param x
     * @param y
     */
    virtual void position(coord x, coord y) {
        _x = x;
        _y = y;
    }


    virtual void positionAbout(coord x, coord y, coord z, coord margin) {
        _x = RND_AROUND(x, margin);
        _y = RND_AROUND(y, margin);
        _z = RND_AROUND(z, margin);
    }

    /**
     * XYZeXP[(_sx, _sy, _sz)𓯂lŐݒB
     * yӁz
     * pScaler_->behave(); ݂Ə㏑܂B
     * @param S XP[l(1000  1.0{)
     */
    virtual void setScale(scale s) {
        _sx = s;
        _sy = s;
        _sz = s;
        setBoundingSphereRadiusRate(SC_R(s));
    }

    /**
     * XYZXP[ _sx, _sy, _sz ꂼlŐݒB
     * yӁz
     * pScaler_->behave(); ݂Ə㏑܂IB
     * @param sx XXP[l(1000  1.0{)
     * @param sy YXP[l(1000  1.0{)
     * @param sz ZXP[l(1000  1.0{)
     */
    virtual void setScale(scale sx, scale sy, scale sz) {
        _sx = sx;
        _sy = sy;
        _sz = sz;
        setBoundingSphereRadiusRate(SC_R(MAX3(_sx,_sy,_sz)));
    }

    /**
     * XYXP[(_sx, _sy)݂̂lŐݒB
     * yӁz
     * pScaler_->behave(); ݂Ə㏑܂IB
     * @param sx XXP[l(1000  1.0{)
     * @param sy YXP[l(1000  1.0{)
     */
    virtual void setScale(scale sx, scale sy) {
        _sx = sx;
        _sy = sy;
        setBoundingSphereRadiusRate(SC_R(MAX3(_sx,_sy,_sz)));
    }

    /**
     * XYZSĂ̎XP[ŐݒB
     * 1.0  ̃f̑傫1.0{B
     * yӁz
     * pScaler_->behave(); ݂Ə㏑܂IB
     * @param prm_rate {
     */
    virtual void setScaleR(float prm_rate) {
        _sx = R_SC(prm_rate);
        _sy = R_SC(prm_rate);
        _sz = R_SC(prm_rate);
        setBoundingSphereRadiusRate(prm_rate);
    }

    /**
     * XYZeXP[ŐݒB
     * 1.0  ̃f̑傫1.0{B
     * yӁz
     * pScaler_->behave(); ݂Ə㏑܂IB
     * @param prm_x_rate X{
     * @param prm_y_rate Y{
     * @param prm_z_rate Z{
     */
    virtual void setScaleR(float prm_x_rate, float prm_y_rate, float prm_z_rate) {
        _sx = R_SC(prm_x_rate);
        _sy = R_SC(prm_y_rate);
        _sz = R_SC(prm_z_rate);
        setBoundingSphereRadiusRate(MAX3(prm_x_rate, prm_y_rate, prm_z_rate));
    }

    /**
     * XŶ݃XP[ŐݒB
     * 1.0  ̃f̑傫1.0{B
     * yӁz
     * pScaler_->behave(); ݂Ə㏑܂IB
     * @param prm_x_rate X{
     * @param prm_y_rate Y{
     */
    virtual void setScaleR(float prm_x_rate, float prm_y_rate) {
        _sx = R_SC(prm_x_rate);
        _sy = R_SC(prm_y_rate);
        setBoundingSphereRadiusRate(MAX3(prm_x_rate, prm_y_rate, SC_R(_sz)));
    }

    /**
     * XYZeXP[(_sx, _sy, _sz)𓯂lŉZB
     * yӁz
     * pScaler_->behave(); ݂Ə㏑܂IB
     * @param dS ZXP[l
     */
    virtual void addScale(scale dS) {
        _sx += dS;
        _sy += dS;
        _sz += dS;
        setBoundingSphereRadiusRate(SC_R(MAX3(_sx,_sy,_sz)));
    }

    /**
     * W(_x, _y, _z)Rs[Đݒ .
     * @param prm_pActor Rs[AN^[
     */
    virtual void positionAs(GgafDxGeometricActor* prm_pActor) {
        _x = prm_pActor->_x;
        _y = prm_pActor->_y;
        _z = prm_pActor->_z;
    }

    /**
     * W(_x, _y, _z)Rs[Đݒ .
     * @param prm_pGeoElem WIuWFNg
     */
    virtual void positionAs(GgafDxGeoElem* prm_pGeoElem);


    virtual void positionAboutAs(GgafDxGeometricActor* prm_pActor, coord margin) {
        _x = RND_AROUND(prm_pActor->_x, margin);
        _y = RND_AROUND(prm_pActor->_y, margin);
        _z = RND_AROUND(prm_pActor->_z, margin);
    }

    virtual void positionAboutAs(GgafDxGeoElem* prm_pGeoElem, coord margin);

    /**
     * ]px _rx, _ry, _rz Rs[Đݒ .
     * @param prm_pActor Rs[AN^[
     */
    virtual void setFaceAngAs(GgafDxGeometricActor* prm_pActor);

    /**
     * ]px _rx, _ry, _rz Rs[Đݒ .
     * @param prm_pGeoElem WIuWFNg
     */
    virtual void setFaceAngAs(GgafDxGeoElem* prm_pGeoElem);

    /**
     * Xp̃AOlݒ .
     * @param prm_angFace AOl(-360,000`360,000)
     */
    virtual void setRzFaceAng(angle prm_angFace);

    /**
     * Yp̃AOlݒ .
     * @param prm_angFace AOl(-360,000`360,000)
     */
    virtual void setRyFaceAng(angle prm_angFace);

    /**
     * Zp̃AOlݒ .
     * @param prm_angFace AOl(-360,000`360,000)
     */
    virtual void setRxFaceAng(angle prm_angFace);

    /**
     * Actor̐ʕpݒB<BR>
     * @param prm_axis_x_angFace Xp̃AOl(-360,000`360,000)
     * @param prm_axis_y_angFace Yp̃AOl(-360,000`360,000)
     * @param prm_axis_z_angFace Zp̃AOl(-360,000`360,000)
     */
    virtual void setFaceAng(angle prm_axis_x_angFace,
                            angle prm_axis_y_angFace,
                            angle prm_axis_z_angFace) {
        setRxFaceAng(prm_axis_x_angFace);
        setRyFaceAng(prm_axis_y_angFace);
        setRzFaceAng(prm_axis_z_angFace);
    }

    /**
     * Actor̎g̍WΏۍW_ɌɁAZ]pY]pݒ<BR>
     * @param prm_tx Ώۓ_XW
     * @param prm_ty Ώۓ_YW
     * @param prm_tz Ώۓ_ZW
     */
    virtual void setFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz);

    /**
     * XYZXP[ _sx, _sy, _sz Rs[Đݒ .
     * @param prm_pActor Rs[AN^[
     */
    virtual void scaleAs(GgafDxGeometricActor* prm_pActor);

    /**
     * g̓[hϊ(_matWorldRotMv) ̋ts𖢌vZȂvZAvZς݂Ȃ炻̂܂ܕԂ .
     * @return _matInvWorldRotMv
     */
    inline D3DXMATRIX* getInvMatWorldRotMv() {
        if (_was_calculated_matInvWorldRotMv) {
            return &_matInvWorldRotMv;
        } else {
            D3DXMatrixInverse(&_matInvWorldRotMv, nullptr, &_matWorldRotMv);
            _was_calculated_matInvWorldRotMv = true; //processSettlementBehavior()ŃZbg
            return &_matInvWorldRotMv;
        }
    }

    /**
     * ̃AN^[Ag̃TuAN^[ƂĒǉAptH[hLl}eBNXŐݒ肷B
     * ̏]AN^[́ÂQ̃\bh̎gp\ƂȂ܂B <BR>
     * _x,_y,_z,_rx,_ry,_rz [Jithis̑΁jɐ؂ւEEEchangeGeoLocal()<BR>
     * _x,_y,_z,_rx,_ry,_rz ΍Wɐ؂ւ                    EEEchangeGeoFinal()<BR>
     * yӁz<BR>
     * (getKuroko()) ́A[JWnł̂ݎgp\ƂȂ܂B<BR>
     * ]AN^[processBehavior() ̏𔲂Oɂ́AchangeGeoFinal() Ő΍Wɖ߂ĂKv܂B<BR>
     * @param prm_kind     
     * @param prm_pGeoActor ]AN^[
     * @param prm_x_init_local  ]AN^[̃[J(this)ʒuXWʒu
     * @param prm_y_init_local  ]AN^[̃[J(this)ʒuYWʒu
     * @param prm_z_init_local  ]AN^[̃[J(this)ʒuZWʒu
     * @param prm_rx_init_local ]AN^[̃[J(this)]X]l
     * @param prm_ry_init_local ]AN^[̃[J(this)]Y]l
     * @param prm_rz_init_local ]AN^[̃[J(this)]Z]l
     * @return ʃgbv̒c
     */
    virtual GgafCore::GgafGroupHead* addSubGroupAsFk(actorkind prm_kind,
                                                     GgafDxGeometricActor* prm_pGeoActor,
                                                     int prm_x_init_local,
                                                     int prm_y_init_local,
                                                     int prm_z_init_local,
                                                     int prm_rx_init_local,
                                                     int prm_ry_init_local,
                                                     int prm_rz_init_local);

    /**
     * ̃AN^[Ag̃TuAN^[ƂĒǉAptH[hLl}eBNXŐݒ肷B
     * ̏]AN^[́ÂQ̃\bh̎gp\ƂȂ܂B <BR>
     * _x,_y,_z,_rx,_ry,_rz [Jithis̑΁jɐ؂ւEEEchangeGeoLocal()<BR>
     * _x,_y,_z,_rx,_ry,_rz ΍Wɐ؂ւ                    EEEchangeGeoFinal()<BR>
     * yӁz<BR>
     * (getKuroko()) ́A[JWnł̂ݎgp\ƂȂ܂B<BR>
     * ]AN^[processBehavior() ̏𔲂Oɂ́AchangeGeoFinal() Ő΍Wɖ߂ĂKv܂B<BR>
     * @param prm_pGeoActor ]AN^[
     * @param prm_x_init_local  ]AN^[̃[J(this)ʒuXWʒu
     * @param prm_y_init_local  ]AN^[̃[J(this)ʒuYWʒu
     * @param prm_z_init_local  ]AN^[̃[J(this)ʒuZWʒu
     * @param prm_rx_init_local ]AN^[̃[J(this)]X]l
     * @param prm_ry_init_local ]AN^[̃[J(this)]Y]l
     * @param prm_rz_init_local ]AN^[̃[J(this)]Z]l
     * @return ʃgbv̒c
     */
    virtual GgafCore::GgafGroupHead* addSubGroupAsFk(GgafDxGeometricActor* prm_pGeoActor,
                                                     int prm_x_init_local,
                                                     int prm_y_init_local,
                                                     int prm_z_init_local,
                                                     int prm_rx_init_local,
                                                     int prm_ry_init_local,
                                                     int prm_rz_init_local);

    /**
     * WƉ] _x,_y,_z,_rx,_ry,_rz ΍WnޔāA[JW(y䂩̑΍W)ɒu .
     */
    inline void changeGeoLocal() {
#ifdef MY_DEBUG
        if (!_pActor_base) {
            throwGgafCriticalException("changeGeoLocal() : yAN^[܂BmFĉBthis="<<getName()<<"("<<this<<")");
        }
        if (_is_local) {
            throwGgafCriticalException("changeGeoLocal() : Ƀ[JWnłBΉmFĉBthis="<<getName()<<"("<<this<<")");
        }
#endif
        _x_final  = _x;
        _y_final  = _y;
        _z_final  = _z;
        _rx_final = _rx;
        _ry_final = _ry;
        _rz_final = _rz;
        _x  = _x_local;
        _y  = _y_local;
        _z  = _z_local;
        _rx = _rx_local;
        _ry = _ry_local;
        _rz = _rz_local;
        _is_local = true;
    }

    /**
     * WƉ] _x,_y,_z,_rx,_ry,_rz ޔĂ΍Wɖ߂ .
     * [JW̕ύXɔ΍W̍XV́AprocessSettlementBehavior()ōsɂȂĂB<BR>
     * processBehavior() ̏̍ŌŎs邱ƂzB<BR>
     * āAchangeGeoFinal() ōWXV킯ł͂Ȃ̂ŒӁB<BR>
     */
    inline void changeGeoFinal() {
#ifdef MY_DEBUG
        if (!_pActor_base) {
            throwGgafCriticalException("changeGeoFinal() : yAN^[܂BmFĉBthis="<<getName()<<"("<<this<<")");
        }
        if (!_is_local) {
            throwGgafCriticalException("changeGeoFinal() : Ƀ[JWnłBΉmFĉBthis="<<getName()<<"("<<this<<")");
        }
#endif
        _x_local = _x;
        _y_local = _y;
        _z_local = _z;
        _rx_local = _rx;
        _ry_local = _ry;
        _rz_local = _rz;
        _x  = _x_final;
        _y  = _y_final;
        _z  = _z_final;
        _rx = _rx_final;
        _ry = _ry_final;
        _rz = _rz_final;
        _is_local = false;
    }

//    void updateGeoFinalFromLocal();

    /**
     * {AN^[3D̏ꍇA ]~ړ̃[hϊsvZ֐` .
     * gk͂̃[hϊs̑Oɏ悶AŏIIȍsBigk~]~ړjB<BR>
     * ʏ̕`\ȃAN^[́AGgafDxUtil::setWorldMatrix_RxRzRyMv() ݒς݂̂
     * ĂяoKvȂB<BR>
     * `悳ȂAN^[Ar{[hsꍇ̏ꍇɕKvƖژ_ށB<BR>
     * @param prm_pFunc ]~ړ̍s쐬֐ւ̃|C^
     */
    void defineRotMvWorldMatrix(void (*prm_pFunc)(GgafDxGeometricActor*, D3DXMATRIX&));

    /**
     * f̋Ea̔{ݒB
     * EaƂ́A[JW̌_S_̋ōő̒ŁA
     * ̒ĺAʊOɗpĂ邽߁Af\ɓƎɊgsꍇB
     * ̒lXVȂƉʊO肪sȂB<BR>
     * Ⴆ΁A\ɂT{̊gŕ\ꍇA{\bh<BR>
     * <BR>
     * setBoundingSphereRadiusRate(5.0)<BR>
     * <BR>
     * ƂƁAʊO肪ȂB<BR>
     * ʊO肪ȂƂ́A̓Iɂ́AisOutOfView() ̔vZɉe^
     * ƂӖłB<BR>
     * @param prm_rate g嗦
     */
    inline void setBoundingSphereRadiusRate(FLOAT prm_rate) {
        _rate_of_bounding_sphere_radius = prm_rate;
    }

    /**
     * {AN^[̍߂擾 .
     * @return 
     */
    inline GgafDxKuroko* getKuroko() {
        return _pKuroko;
    }

    /**
     * {AN^[̃TEhGtFNgo͎xIuWFNg擾 .
     * @return TEhGtFNgo͎xIuWFNg
     */
    inline GgafDxSeTransmitterForActor* getSeTx() {
        return _pSeTx;
    }

    virtual void onEnd() override;

    /**
     * yƂȂAN^[擾B
     * yƂ́AaddSubGroupAsFk() ɂĒǉꂽ̃IuWFNgA
     * addSubGroupAsFk()sAN^[wB
     * @return yƂȂAN^[
     */
    inline GgafDxGeometricActor* getBaseActor() {
        return _pActor_base;
    }


    /**
     * fXgN^
     */
    virtual ~GgafDxGeometricActor();

    /**
     * fobOpFc[\\<BR>
     */
    virtual void dump();

    /**
     * fobOpFdump()gp<BR>
     */
    virtual void dump(std::string prm_parent);

};

}
#endif /*GGAFDXCORE_GGAFDXGEOMETRICACTOR_H_*/
