#include "MyOptionWateringLaserChip001.h"

#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"
#include "jp/gecchi/VioletVreath/actor/my/option/MyOption.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/core/util/GgafResourceConnection.hpp"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureConnection.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/texture/GgafDxTexture.h"
#include "jp/ggaf/lib/actor/laserchip/WateringLaserChip.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;



GgafDxCore::GgafDxModel* MyOptionWateringLaserChip001::pModel_  = nullptr;
char MyOptionWateringLaserChip001::aaTextureName[3][51];
int MyOptionWateringLaserChip001::tex_no_ = 0;

MyOptionWateringLaserChip001::MyOptionWateringLaserChip001(const char* prm_name) :
        WateringLaserChip(prm_name, "MyOptionWateringLaserChip001", STATUS(MyOptionWateringLaserChip001)) {
    _class_name = "MyOptionWateringLaserChip001";
    pAxsMver_ = NEW GgafDxAxesMover(this);
    default_stamina_ = getStatus()->get(STAT_Stamina);
    pOrg_ = nullptr;
    lockon_st_ = 0;
    is_lockon_ = false;
    max_acce_renge_ = 0;
    max_velo_renge_ = 160000; //̒l傫ƁAōxȂB
    r_max_acce_ = 20; //̒l傫ƁAJ[uɂȂ
    rr_max_acce_ = 1.0 / r_max_acce_; //vZȑfp
    GgafDxModel* pModel = getModel();
    if (!MyOptionWateringLaserChip001::pModel_) {
        if (pModel->_num_materials != 3) {
            throwGgafCriticalException("MyOptionWateringLaserChip001::onCreateModel() MyOptionWateringLaserChip001f́A}eARKvłB");
        }
        for (DWORD i = 0; i < pModel->_num_materials; i ++) {
            strcpy(MyOptionWateringLaserChip001::aaTextureName[i], pModel->_papTextureConnection[i]->peek()->getName());
        }
        MyOptionWateringLaserChip001::pModel_ = pModel;
    }
}

void MyOptionWateringLaserChip001::initialize() {
    getKuroko()->relateFaceByMvAng(true);
    registerHitAreaCube_AutoGenMidColli(80000);
    setHitAble(true);
    setScaleR(6.0);
    setAlpha(0.99);
}

void MyOptionWateringLaserChip001::onCreateModel() {

}

void MyOptionWateringLaserChip001::onActive() {
    getStatus()->reset();
    default_stamina_ = getStatus()->get(STAT_Stamina);
    WateringLaserChip::onActive();
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    if (pMainLockOnTarget && pMainLockOnTarget->isActiveInTheTree()) {
        if (getFrontChip() == nullptr) {
            //[`bv
            lockon_st_ = 1;
        } else {
            //[ȊO
            MyOptionWateringLaserChip001* pF = (MyOptionWateringLaserChip001*) getFrontChip();
            lockon_st_ = pF->lockon_st_;//ÕbNIp
        }
    } else {
        if (getFrontChip() == nullptr) {
            //[`bv
            lockon_st_ = 0;
        } else {
            //[ȊO
            MyOptionWateringLaserChip001* pF = (MyOptionWateringLaserChip001*) getFrontChip();
            lockon_st_ = pF->lockon_st_;//ÕbNIp
        }
    }
    pAxsMver_->setZeroVxyzMvAcce(); //xZbg
    //Vxyz̑x̓IvVŐݒ肳


    pAxsMver_->forceVxyzMvVeloRange(-max_velo_renge_, max_velo_renge_);
    max_acce_renge_ = max_velo_renge_/r_max_acce_;
    pAxsMver_->forceVxyzMvAcceRange(-max_acce_renge_, max_acce_renge_);
}

void MyOptionWateringLaserChip001::processBehavior() {
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    if (getActiveFrame() > 6) {
        if (lockon_st_ == 1) {
            if (pMainLockOnTarget && pMainLockOnTarget->isActiveInTheTree()) {
                moveChip(pMainLockOnTarget->_x,
                         pMainLockOnTarget->_y,
                         pMainLockOnTarget->_z );
            } else {
                //pAxsMver_->setZeroVxyzMvAcce();
                lockon_st_ = 2;
            }
        }

        if (lockon_st_ == 2) {
            if (_pLeader) {
                if (_pLeader == this) {
                    moveChip(_x + pAxsMver_->_velo_vx_mv*4+1,
                             _y + pAxsMver_->_velo_vy_mv*2+1,
                             _z + pAxsMver_->_velo_vz_mv*2+1 );
                } else {
                    moveChip(_pLeader->_x, _pLeader->_y, _pLeader->_z);
                }
            }
        }
    }
    pAxsMver_->behave();

    WateringLaserChip::processBehavior();//WړĂĂяo
    //烌[U[\̂ߋIɍW␳
    if (onChangeToActive()) {
        positionAs(pOrg_);
        _tmpX = _x;
        _tmpY = _y;
        _tmpZ = _z;
    }

}

void MyOptionWateringLaserChip001::moveChip(int tX, int tY, int tZ) {
    //    |                            vVT I                        |
    //    |                                ^                         |
    //    |                 |I| > 5*vM /    _  vVP I      |      I
    //    |                 ƂȂ悤 /       _                    |       
    //    |                 vVTݒ   /                            |      
    //    |                            /        ^vVM              |       
    //    |                           /       ^  (vVMx,vVMy,vVMz)     |       b
    //    |                          /      ^                         |       b
    //    |                         /     ^                           |       b
    //    |                        /    ^ || = 5*vM = lVM         |       b
    //    |                   vT I   ^                               |       I
    //    |                    ^  ^                                 |       
    //    |               _    / vM ݂̈ړxNg          |       b
    //    | vVP I  _ /^ (veloVxMv_,veloVyMv_,veloVzMv_)     |       b
    //    |                                                          |       
    // ---+------------------------------------------               ---+---------------------------
    //    |                                                            |
    //
    // vVP BvVP߂I

    //I
    int vTx = tX - _x;
    int vTy = tY - _y;
    int vTz = tZ - _z;

    //B} || = 5*vM
    int vVMx = pAxsMver_->_velo_vx_mv*5;
    int vVMy = pAxsMver_->_velo_vy_mv*5;
    int vVMz = pAxsMver_->_velo_vz_mv*5;

    //||
    int lVM = MAX3(ABS(vVMx), ABS(vVMy), ABS(vVMz)); //xNg傫ȈՔ
    //|I|
    int lT =  MAX3(ABS(vTx), ABS(vTy), ABS(vTz)); //IxNg傫ȈՔ
    //||/|I|      vT ̉{ vVT I ɂȂ̂߂B
    double r = (lVM*1.5) / lT;
    //* 2 E}̂悤Ɉ꒼ɕ񂾍ۂAisێ邽߂ɁA
    //|I| > || Ƃ֌Wێ邽߂ɂKȊ

    //vVP I ̉xݒ
    double accX = ((vTx * r) - vVMx) * rr_max_acce_;
    double accY = ((vTy * r) - vVMy) * rr_max_acce_;
    double accZ = ((vTz * r) - vVMz) * rr_max_acce_;

    if (getFrontChip() == nullptr) {
        //擪͂⑬߂ɁBSGN(accX)*5 Ẑ́Ax0ɂȂ
        pAxsMver_->setVxyzMvAcce(accX + SGN(accX)*5.0,
                                 accY + SGN(accY)*5.0,
                                 accZ + SGN(accZ)*5.0);
    } else {
        pAxsMver_->setVxyzMvAcce(accX + SGN(accX)*3.0,
                                 accY + SGN(accY)*3.0,
                                 accZ + SGN(accZ)*3.0);
    }
    //lW`悪ȂȂ悤ɉ]𐧌
    if (lVM > max_velo_renge_/2) {
        angle rz_temp, ry_temp;
        UTIL::convVectorToRzRy(vVMx, vVMy, vVMz, rz_temp, ry_temp);
        angle angDRZ = UTIL::getAngDiff(rz_temp, _rz);
        angle angDRY = UTIL::getAngDiff(ry_temp, _ry);
        if (-4000 <= angDRZ) {
            _rz -= 4000;
        } else if (angDRZ <= 4000) {
            _rz += 4000;
        } else {
            _rz += angDRZ;
        }
        if (-4000 <= angDRY) {
            _ry -= 4000;
        } else if (angDRY <= 4000) {
            _ry += 4000;
        } else {
            _ry += angDRY;
        }
        if (_rz >= D360ANG) {
            _rz -= D360ANG;
        }
        if (_rz < 0) {
            _rz += D360ANG;
        }
        if (_ry >= D360ANG) {
            _ry -= D360ANG;
        }
        if (_ry < 0) {
            _ry += D360ANG;
        }
    }

}

void MyOptionWateringLaserChip001::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*) prm_pOtherActor;
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    //qbgGtFNg
    UTIL::activateExplosionEffectOf(this); //GtFNgo

    if ((pOther->getKind() & KIND_ENEMY_BODY) ) {
        if (pMainLockOnTarget) { //ɃIvV̓bNI
            if (pOther == pMainLockOnTarget) {
                //IvṼbNIɌꍇ

                lockon_st_ = 2; //bNI߂B񃍃bNIibNI񃍃bNIj
                if (getFrontChip() && getFrontChip()->getFrontChip() == nullptr) {
                    //Ԑ擪`bvqbgꍇA[ɂ`([͓蔻ȂߒԐ擪Ɠlɂ)
                    ((MyOptionWateringLaserChip001*)getFrontChip())->lockon_st_ = 2;
                }
            } else {
                //IvṼbNIȊÕAN^[ɖꍇ
            }
        } else {
            //IvV񃍃bNIɖꍇ
        }

        int stamina = UTIL::calcMyStamina(this, pOther);
        if (stamina <= 0) {
            //ꌂŃ`bvł̍U
            //bNI\AN^[Ȃ烍bNI
            if (pOther->getStatus()->get(STAT_LockonAble) == 1) {
                pOrg_->pLockonCtrler_->lockon(pOther);
            }
            sayonara();
        } else {
            //ςȂ΁AʊтAX^~i񕜁iU100̎GȂΒʊсj
            getStatus()->set(STAT_Stamina, default_stamina_);
            //bNI\AN^[Ȃ烍bNI
            if (pOther->getStatus()->get(STAT_LockonAble) == 1) {
                pOrg_->pLockonCtrler_->lockon(pOther);
            }
        }
    } else if (pOther->getKind() & KIND_CHIKEI) {
        //n`͖悤Ȃ
        sayonara();
    }
}

void MyOptionWateringLaserChip001::onInactive() {
    WateringLaserChip::onInactive();
    lockon_st_ = 0;
}

void MyOptionWateringLaserChip001::chengeTex(int prm_tex_no) {
    if (MyOptionWateringLaserChip001::pModel_) {
        MyOptionWateringLaserChip001::tex_no_ = prm_tex_no;
        MyOptionWateringLaserChip001::pModel_->swapTopTextureOrder(aaTextureName[prm_tex_no]);
    }
}

MyOptionWateringLaserChip001::~MyOptionWateringLaserChip001() {
    GGAF_DELETE(pAxsMver_);
    MyOptionWateringLaserChip001::pModel_ = nullptr;
}

