package net.sf.jhpdf.pdfobject.font

import net.sf.jhpdf.io.HPdfFileReadStream
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;

import org.junit.*
import static org.junit.Assert.*
import static org.hamcrest.CoreMatchers.is


class HPdfTrueTypeFontDefTest {
    
    private HPdfTrueTypeFontDef fontDef
    
    @Before
    void setUp() {
        def s = new HPdfFileReadStream("build/resources/test/AidaSerif.ttf")
        fontDef = HPdfTrueTypeFontDef.load(s, false)
    }
    
    @Test
    void checkBaseName() {
        
        assertThat fontDef.fontDefAttr.getBaseFont(), is("AidaSerif")
        
    }
    
    @Test
    void checkFontDefType() {
        
        assertThat fontDef.getFontDefType(), is(HPdfFontDefType.TRUETYPE)
        
    }
    @After
    void tearDown() {
        fontDef.dispose()
    }
}
