/*
 * JHPdf Free PDF Library : HPdfMingLiUFontDef.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font.cnt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.pdfobject.font.HPdfCIDFontDef;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;

/**
 * Class represents PDF MingLiU Font definition.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfMingLiUFontDef extends HPdfCIDFontDef {

    private static final Logger logger = LoggerFactory.getLogger(HPdfMingLiUFontDef.class);
    
    // TODO width data loading required.
    private HPdfCIDWidth[] MING_LIU_W_ARRAY;
    
    public HPdfMingLiUFontDef() {
        super("MingLiU");
    }

    @Override
    public void init() {
        
        // MEMO: derived from MingLiU_Init in hpdf_fontdef_cnt.c
        logger.trace("HPdfMingLiUFontDef#init");
        
        this.setAscent(800);
        this.setDescent(-199);
        this.setCapHeight(769);
        this.setFontBbox(new HPdfRect(0, -199, 1000, 800));
        this.setFlag(HPDF_FONT_SYMBOLIC + HPDF_FONT_FIXED_WIDTH +
            HPDF_FONT_SERIF);
        this.setItalicAngle(0);
        this.setStemv(78);
        this.addWidth(MING_LIU_W_ARRAY);
        
        this.setFontDefType(HPdfFontDefType.CID);
        this.setValid(true);
    }

    @Override
    public void clean() {
        // TODO ꂽ\bhEX^u
        
    }

    @Override
    public void dispose() {
        // TODO ꂽ\bhEX^u
        
    }
    
}
