/*
 * JHPdf Free PDF Library : HPdfEncoder.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.encoder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder.HPdfByteType;
import net.sf.jhpdf.io.HPdfWriteStream;
import net.sf.jhpdf.pdfobject.HPdfArray;
import net.sf.jhpdf.pdfobject.HPdfFont.HPdfWritingMode;

/**
 * Abstract class represents various encoders.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public abstract class HPdfCMapEncoder extends HPdfEncoder {
    // TODO only stub, needs methods definition.

    private static final Logger logger = LoggerFactory.getLogger(HPdfCMapEncoder.class);
    
    protected HPdfCMapEncoder() {
        super();
        // TODO only stub
    }

    @Override
    protected HPdfByteType getByteTypeByParse(byte[] text, int index) {
        
        HPdfParseText parseState = new HPdfParseText();
        
        // TODO: check '+1' is for C-String NULL-term. 
        this.setParseText(parseState, text, index + 1);
        
        HPdfByteType btype = HPdfByteType.UNKNOWN;
        int pos = 0;
        for (;;){
            btype = this.getHeadByteType(parseState);
            if (index == 0) { 
                break;
            }
            ++pos;
            if (pos >= text.length) {
                break; // btype == HPdfByteType.UNKNOWN
            }
            --index;
        }
        return btype;
    }
    
    public int toCID(char code) {
        // TODO only stub
        return 0;
    }
    
    private String registry;
    
    public String getRegistry() {
        return this.registry;
    }
    
    protected void setRegistry(String registry) {
        this.registry = registry;
    }
    
    private String ordering;
    
    public String getOrdering() {
        return ordering;
    }

    protected void setOrdering(String ordering) {
        this.ordering = ordering;
    }
    
    private int suppliment;
    

    public int getSuppliment() {
        return suppliment;
    }

    protected void setSuppliment(int suppliment) {
        this.suppliment = suppliment;
    }

    protected abstract boolean isTrialByte(byte b);
    
    protected abstract boolean isLeadByte(byte b);
}
