/*
 * Copyright 2004-2012 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.extension.sql;

import org.seasar.framework.exception.SRuntimeException;

/**
 * SQLインジェクション対策のためセミコロンが入力された場合の例外です。
 * 
 * @author higa
 * 
 */
public class SemicolonNotAllowedRuntimeException extends SRuntimeException {

    private static final long serialVersionUID = 1L;

    /**
     * {@link SemicolonNotAllowedRuntimeException}を作成します。
     */
    public SemicolonNotAllowedRuntimeException() {
        super("ESSR0325");
    }
}