/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.ByteUtils;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueUuid
extends Value {
    public static final int PRECISION = 16;
    public static final int DISPLAY_SIZE = 36;
    private final long high;
    private final long low;

    private ValueUuid(long high, long low) {
        this.high = high;
        this.low = low;
    }

    public int hashCode() {
        return (int)(this.high >>> 32 ^ this.high ^ this.low >>> 32 ^ this.low);
    }

    public static ValueUuid getNewRandom() {
        long high = RandomUtils.getSecureLong();
        long low = RandomUtils.getSecureLong();
        high = high & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        low = low & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(high, low);
    }

    public static ValueUuid get(byte[] binary) {
        if (binary.length < 32) {
            return ValueUuid.get(ByteUtils.convertBytesToString(binary));
        }
        long high = ByteUtils.readLong(binary, 0);
        long low = ByteUtils.readLong(binary, 16);
        return (ValueUuid)Value.cache(new ValueUuid(high, low));
    }

    public static ValueUuid get(long high, long low) {
        return (ValueUuid)Value.cache(new ValueUuid(high, low));
    }

    public static ValueUuid get(String s) {
        char ch;
        int i;
        long high = 0L;
        long low = 0L;
        int j = 0;
        for (i = 0; i < s.length() && j < 16; ++i) {
            ch = s.charAt(i);
            if (ch == '-') continue;
            high = high << 4 | (long)Character.digit(ch, 16);
            ++j;
        }
        j = 0;
        while (i < s.length() && j < 16) {
            ch = s.charAt(i);
            if (ch != '-') {
                low = low << 4 | (long)Character.digit(ch, 16);
                ++j;
            }
            ++i;
        }
        return (ValueUuid)Value.cache(new ValueUuid(high, low));
    }

    public String getSQL() {
        return StringUtils.quoteStringSQL(this.getString());
    }

    public int getType() {
        return 20;
    }

    public long getPrecision() {
        return 16L;
    }

    private void appendHex(StringBuffer buff, long x, int bytes) {
        for (int i = bytes * 8 - 4; i >= 0; i -= 8) {
            buff.append(Integer.toHexString((int)(x >> i) & 0xF));
            buff.append(Integer.toHexString((int)(x >> i - 4) & 0xF));
        }
    }

    public String getString() {
        StringBuffer buff = new StringBuffer(36);
        this.appendHex(buff, this.high >> 32, 4);
        buff.append('-');
        this.appendHex(buff, this.high >> 16, 2);
        buff.append('-');
        this.appendHex(buff, this.high, 2);
        buff.append('-');
        this.appendHex(buff, this.low >> 48, 2);
        buff.append('-');
        this.appendHex(buff, this.low, 6);
        return buff.toString();
    }

    protected int compareSecure(Value o, CompareMode mode) {
        if (o == this) {
            return 0;
        }
        ValueUuid v = (ValueUuid)o;
        if (this.high == v.high) {
            return this.low == v.low ? 0 : (this.low > v.low ? 1 : -1);
        }
        return this.high > v.high ? 1 : -1;
    }

    public boolean equals(Object other) {
        return other instanceof ValueUuid && this.compareSecure((Value)other, null) == 0;
    }

    public Object getObject() {
        return new long[]{this.high, this.low};
    }

    public byte[] getBytes() {
        byte[] buff = new byte[16];
        for (int i = 0; i < 8; ++i) {
            buff[i] = (byte)(this.high >> 8 * (8 - i) & 0xFFL);
            buff[8 + i] = (byte)(this.low >> 8 * (8 - i) & 0xFFL);
        }
        return buff;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBytes(parameterIndex, this.getBytes());
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public int getDisplaySize() {
        return 36;
    }
}

