/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class ConvertTraceFile
extends Tool {
    private void showUsage() {
        this.out.println("Converts a .trace.db file to a SQL script and Java source code.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-traceFile <file>]  The trace file name (default: test.trace.db)\n" + " [-script <file>]     The script file name (default: test.sql)\n" + " [-javaClass <file>]  The Java directory and class file name (default: Test)");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] args) throws SQLException {
        new ConvertTraceFile().run(args);
    }

    public void run(String[] args) throws SQLException {
        String traceFile = "test.trace.db";
        String javaClass = "Test";
        String script = "test.sql";
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-traceFile")) {
                traceFile = args[++i];
                continue;
            }
            if (arg.equals("-javaClass")) {
                javaClass = args[++i];
                continue;
            }
            if (arg.equals("-script")) {
                script = args[++i];
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + arg);
            this.showUsage();
            return;
        }
        try {
            this.convertFile(traceFile, javaClass, script);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, traceFile);
        }
    }

    private void convertFile(String traceFileName, String javaClassName, String script) throws IOException, SQLException {
        String line;
        LineNumberReader reader = new LineNumberReader(IOUtils.getReader(FileUtils.openFileInputStream(traceFileName)));
        PrintWriter javaWriter = new PrintWriter(FileUtils.openFileWriter(javaClassName + ".java", false));
        PrintWriter scriptWriter = new PrintWriter(FileUtils.openFileWriter(script, false));
        javaWriter.println("import java.io.*;");
        javaWriter.println("import java.sql.*;");
        javaWriter.println("import java.math.*;");
        javaWriter.println("import java.util.Calendar;");
        String cn = javaClassName.replace('\\', '/');
        int idx = cn.lastIndexOf(47);
        if (idx > 0) {
            cn = cn.substring(idx + 1);
        }
        javaWriter.println("public class " + cn + " {");
        javaWriter.println("    public static void main(String[] args) throws Exception {");
        javaWriter.println("        Class.forName(\"org.h2.Driver\");");
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("/**/")) {
                line = "        " + line.substring(4);
                javaWriter.println(line);
                continue;
            }
            if (!line.startsWith("/*SQL*/")) continue;
            line = line.substring("/*SQL*/".length());
            scriptWriter.println(StringUtils.javaDecode(line));
        }
        javaWriter.println("    }");
        javaWriter.println("}");
        reader.close();
        javaWriter.close();
        scriptWriter.close();
    }
}

