/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcCallableStatement;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcDatabaseMetaData;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcSavepoint;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.ClassUtils;
import org.h2.util.JdbcConnectionListener;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class JdbcConnection
extends TraceObject
implements Connection {
    private String url;
    private String user;
    private int holdability = 1;
    private SessionInterface session;
    private CommandInterface commit;
    private CommandInterface rollback;
    private CommandInterface setAutoCommitTrue;
    private CommandInterface setAutoCommitFalse;
    private CommandInterface getAutoCommit;
    private CommandInterface getReadOnly;
    private CommandInterface getGeneratedKeys;
    private CommandInterface setLockMode;
    private CommandInterface getLockMode;
    private CommandInterface setQueryTimeout;
    private CommandInterface getQueryTimeout;
    private Exception openStackTrace;
    private int savepointId;
    private Trace trace;
    private JdbcConnectionListener listener;
    private boolean isInternal;
    private String catalog;
    private Statement executingStatement;
    static /* synthetic */ Class class$java$sql$Savepoint;

    public Statement createStatement() throws SQLException {
        try {
            int id = this.getNextId(8);
            if (this.debug()) {
                this.debugCodeAssign("Statement", 8, id, "createStatement()");
            }
            this.checkClosed();
            return new JdbcStatement(this.session, this, 1003, id, false);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = this.getNextId(8);
            if (this.debug()) {
                this.debugCodeAssign("Statement", 8, id, "createStatement(" + resultSetType + ", " + resultSetConcurrency + ")");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            return new JdbcStatement(this.session, this, resultSetType, id, false);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = this.getNextId(8);
            if (this.debug()) {
                this.debugCodeAssign("Statement", 8, id, "createStatement(" + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            this.checkHoldability(resultSetHoldability);
            return new JdbcStatement(this.session, this, resultSetType, id, false);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            int id = this.getNextId(3);
            if (this.debug()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + this.quote(sql) + ")");
            }
            this.checkClosed();
            sql = this.translateSQL(sql);
            return new JdbcPreparedStatement(this.session, this, sql, 1003, id, false);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    PreparedStatement prepareAutoCloseStatement(String sql) throws SQLException {
        try {
            int id = this.getNextId(3);
            if (this.debug()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + this.quote(sql) + ")");
            }
            this.checkClosed();
            sql = this.translateSQL(sql);
            return new JdbcPreparedStatement(this.session, this, sql, 1003, id, true);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            int id = this.getNextId(2);
            if (this.debug()) {
                this.debugCodeAssign("DatabaseMetaData", 2, id, "getMetaData()");
            }
            this.checkClosed();
            return new JdbcDatabaseMetaData(this, this.trace, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setJdbcConnectionListener(JdbcConnectionListener listener) {
        this.listener = listener;
    }

    public SessionInterface getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        JdbcConnection jdbcConnection = this;
        synchronized (jdbcConnection) {
            if (this.listener == null) {
                this.closeConnection();
            } else {
                this.listener.closed(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws SQLException {
        try {
            this.debugCodeCall("close");
            if (this.executingStatement != null) {
                this.executingStatement.cancel();
            }
            if (this.session == null) {
                return;
            }
            this.session.cancel();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                block13: {
                    try {
                        if (this.session.isClosed()) break block13;
                        try {
                            this.rollbackInternal();
                            this.commit = this.closeAndSetNull(this.commit);
                            this.rollback = this.closeAndSetNull(this.rollback);
                            this.setAutoCommitTrue = this.closeAndSetNull(this.setAutoCommitTrue);
                            this.setAutoCommitFalse = this.closeAndSetNull(this.setAutoCommitFalse);
                            this.getAutoCommit = this.closeAndSetNull(this.getAutoCommit);
                            this.getReadOnly = this.closeAndSetNull(this.getReadOnly);
                            this.getGeneratedKeys = this.closeAndSetNull(this.getGeneratedKeys);
                            this.getLockMode = this.closeAndSetNull(this.getLockMode);
                            this.setLockMode = this.closeAndSetNull(this.setLockMode);
                            this.getQueryTimeout = this.closeAndSetNull(this.getQueryTimeout);
                            this.setQueryTimeout = this.closeAndSetNull(this.setQueryTimeout);
                        }
                        finally {
                            this.session.close();
                        }
                    }
                    finally {
                        this.session = null;
                    }
                }
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    private CommandInterface closeAndSetNull(CommandInterface command) {
        if (command != null) {
            command.close();
        }
        return null;
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setAutoCommit(" + autoCommit + ");");
            }
            this.checkClosed();
            if (autoCommit) {
                this.setAutoCommitTrue = this.prepareCommand("SET AUTOCOMMIT TRUE", this.setAutoCommitTrue);
                this.setAutoCommitTrue.executeUpdate();
            } else {
                this.setAutoCommitFalse = this.prepareCommand("SET AUTOCOMMIT FALSE", this.setAutoCommitFalse);
                this.setAutoCommitFalse.executeUpdate();
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkClosed();
            this.debugCodeCall("getAutoCommit");
            return this.getInternalAutoCommit();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    private boolean getInternalAutoCommit() throws SQLException {
        this.getAutoCommit = this.prepareCommand("CALL AUTOCOMMIT()", this.getAutoCommit);
        ResultInterface result = this.getAutoCommit.executeQuery(0, false);
        result.next();
        boolean autoCommit = result.currentRow()[0].getBoolean();
        result.close();
        return autoCommit;
    }

    public synchronized void commit() throws SQLException {
        try {
            this.debugCodeCall("commit");
            this.checkClosed();
            this.commit = this.prepareCommand("COMMIT", this.commit);
            this.commit.executeUpdate();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            this.debugCodeCall("rollback");
            this.checkClosed();
            this.rollbackInternal();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.session == null || this.session.isClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            this.debugCodeCall("nativeSQL", sql);
            this.checkClosed();
            return this.translateSQL(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setReadOnly(" + readOnly + ");");
            }
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            this.checkClosed();
            this.getReadOnly = this.prepareCommand("CALL READONLY()", this.getReadOnly);
            ResultInterface result = this.getReadOnly.executeQuery(0, false);
            result.next();
            boolean readOnly = result.currentRow()[0].getBoolean();
            return readOnly;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            this.debugCodeCall("setCatalog", catalog);
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getCatalog() throws SQLException {
        try {
            this.debugCodeCall("getCatalog");
            this.checkClosed();
            if (this.catalog == null) {
                CommandInterface cat = this.prepareCommand("CALL DATABASE()", Integer.MAX_VALUE);
                ResultInterface result = cat.executeQuery(0, false);
                result.next();
                this.catalog = result.currentRow()[0].getString();
                cat.close();
            }
            return this.catalog;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = this.getNextId(3);
            if (this.debug()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + this.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ")");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            sql = this.translateSQL(sql);
            return new JdbcPreparedStatement(this.session, this, sql, resultSetType, id, false);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try {
            int lockMode;
            this.debugCodeCall("setTransactionIsolation", level);
            this.checkClosed();
            switch (level) {
                case 1: {
                    lockMode = 0;
                    break;
                }
                case 2: {
                    lockMode = 3;
                    break;
                }
                case 4: 
                case 8: {
                    lockMode = 1;
                    break;
                }
                default: {
                    throw Message.getInvalidValueException("" + level, "level");
                }
            }
            this.commit();
            this.setLockMode = this.prepareCommand("SET LOCK_MODE ?", this.setLockMode);
            ((ParameterInterface)this.setLockMode.getParameters().get(0)).setValue(ValueInt.get(lockMode));
            this.setLockMode.executeUpdate();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.commit();
            this.setQueryTimeout = this.prepareCommand("SET QUERY_TIMEOUT ?", this.setQueryTimeout);
            ((ParameterInterface)this.setQueryTimeout.getParameters().get(0)).setValue(ValueInt.get(seconds * 1000));
            this.setQueryTimeout.executeUpdate();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.getQueryTimeout = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", this.getQueryTimeout);
            ((ParameterInterface)this.getQueryTimeout.getParameters().get(0)).setValue(ValueString.get("QUERY_TIMEOUT"));
            ResultInterface result = this.getQueryTimeout.executeQuery(0, false);
            result.next();
            int queryTimeout = result.currentRow()[0].getInt();
            result.close();
            if (queryTimeout == 0) {
                return 0;
            }
            return (queryTimeout + 999) / 1000;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getTransactionIsolation() throws SQLException {
        try {
            void var3_4;
            this.debugCodeCall("getTransactionIsolation");
            this.checkClosed();
            this.getLockMode = this.prepareCommand("CALL LOCK_MODE()", this.getLockMode);
            ResultInterface result = this.getLockMode.executeQuery(0, false);
            result.next();
            int lockMode = result.currentRow()[0].getInt();
            result.close();
            switch (lockMode) {
                case 0: {
                    int transactionIsolationLevel = 1;
                    break;
                }
                case 3: {
                    int transactionIsolationLevel = 2;
                    break;
                }
                case 1: 
                case 2: {
                    int transactionIsolationLevel = 8;
                    break;
                }
                default: {
                    throw Message.getInternalError("lockMode:" + lockMode);
                }
            }
            return (int)var3_4;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        try {
            this.debugCodeCall("setHoldability", holdability);
            this.checkClosed();
            this.checkHoldability(holdability);
            this.holdability = holdability;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.holdability;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            this.debugCodeCall("getTypeMap");
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.debugCode("setTypeMap(" + this.quoteMap(map) + ");");
            this.checkMap(map);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            int id = this.getNextId(0);
            if (this.debug()) {
                this.debugCodeAssign("CallableStatement", 0, id, "prepareCall(" + this.quote(sql) + ")");
            }
            this.checkClosed();
            sql = this.translateSQL(sql);
            return new JdbcCallableStatement(this.session, this, sql, 1003, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = this.getNextId(0);
            if (this.debug()) {
                this.debugCodeAssign("CallableStatement", 0, id, "prepareCall(" + this.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ")");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            sql = this.translateSQL(sql);
            return new JdbcCallableStatement(this.session, this, sql, resultSetType, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = this.getNextId(0);
            if (this.debug()) {
                this.debugCodeAssign("CallableStatement", 0, id, "prepareCall(" + this.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            this.checkHoldability(resultSetHoldability);
            sql = this.translateSQL(sql);
            return new JdbcCallableStatement(this.session, this, sql, resultSetType, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            int id = this.getNextId(6);
            if (this.debug()) {
                this.debugCodeAssign("Savepoint", 6, id, "setSavepoint()");
            }
            this.checkClosed();
            CommandInterface set = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(null, this.savepointId), Integer.MAX_VALUE);
            set.executeUpdate();
            JdbcSavepoint savepoint = new JdbcSavepoint(this, this.savepointId, null, this.trace, id);
            ++this.savepointId;
            return savepoint;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            int id = this.getNextId(6);
            if (this.debug()) {
                this.debugCodeAssign("Savepoint", 6, id, "setSavepoint(" + this.quote(name) + ")");
            }
            this.checkClosed();
            CommandInterface set = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(name, 0), Integer.MAX_VALUE);
            set.executeUpdate();
            JdbcSavepoint savepoint = new JdbcSavepoint(this, 0, name, this.trace, id);
            return savepoint;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            JdbcSavepoint sp = this.convertSavepoint(savepoint);
            this.debugCode("rollback(" + sp.getTraceObjectName() + ");");
            this.checkClosed();
            sp.rollback();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.debugCode("releaseSavepoint(savepoint);");
            this.checkClosed();
            this.convertSavepoint(savepoint).release();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    private JdbcSavepoint convertSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw Message.getSQLException(90063, "" + savepoint);
        }
        return (JdbcSavepoint)savepoint;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = this.getNextId(3);
            if (this.debug()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + this.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            this.checkHoldability(resultSetHoldability);
            sql = this.translateSQL(sql);
            return new JdbcPreparedStatement(this.session, this, sql, resultSetType, id, false);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("prepareStatement(" + this.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            return this.prepareStatement(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("prepareStatement(" + this.quote(sql) + ", " + this.quoteIntArray(columnIndexes) + ");");
            }
            return this.prepareStatement(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("prepareStatement(" + this.quote(sql) + ", " + this.quoteArray(columnNames) + ");");
            }
            return this.prepareStatement(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public JdbcConnection(String url, Properties info) throws SQLException {
        this(new ConnectionInfo(url, info), true);
    }

    public JdbcConnection(ConnectionInfo ci, boolean useBaseDir) throws SQLException {
        try {
            this.checkJavaVersion();
            if (ci.isRemote()) {
                this.session = new SessionRemote().createSession(ci);
            } else {
                String baseDir;
                SessionInterface si = (SessionInterface)ClassUtils.loadSystemClass("org.h2.engine.Session").newInstance();
                if (useBaseDir && (baseDir = SysProperties.getBaseDir()) != null) {
                    ci.setBaseDir(baseDir);
                }
                this.session = si.createSession(ci);
            }
            this.trace = this.session.getTrace();
            int id = this.getNextId(1);
            this.setTrace(this.trace, 1, id);
            this.user = ci.getUserName();
            if (this.info()) {
                this.trace.infoCode("Connection " + this.getTraceObjectName() + " = DriverManager.getConnection(" + this.quote(ci.getOriginalURL()) + ", " + this.quote(this.user) + ", \"\")");
            }
            this.url = ci.getURL();
            this.openStackTrace = new Exception("Stack Trace");
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public JdbcConnection(SessionInterface session, String user, String url) throws SQLException {
        this.isInternal = true;
        this.session = session;
        this.trace = session.getTrace();
        int id = this.getNextId(1);
        this.setTrace(this.trace, 1, id);
        this.user = user;
        this.url = url;
    }

    private void checkJavaVersion() throws SQLException {
        try {
            Class clazz = class$java$sql$Savepoint == null ? (class$java$sql$Savepoint = JdbcConnection.class$("java.sql.Savepoint")) : class$java$sql$Savepoint;
            clazz.getClass();
        }
        catch (Throwable e) {
            throw Message.getSQLException(90092);
        }
    }

    CommandInterface prepareCommand(String sql, int fetchSize) throws SQLException {
        return this.session.prepareCommand(sql, fetchSize);
    }

    CommandInterface prepareCommand(String sql, CommandInterface old) throws SQLException {
        return old == null ? this.session.prepareCommand(sql, Integer.MAX_VALUE) : old;
    }

    private int translateGetEnd(String sql, int i, char c) throws SQLException {
        int len = sql.length();
        switch (c) {
            case '\'': {
                int j = sql.indexOf(39, i + 1);
                if (j < 0) {
                    throw Message.getSyntaxError(sql, i);
                }
                return j;
            }
            case '\"': {
                int j = sql.indexOf(34, i + 1);
                if (j < 0) {
                    throw Message.getSyntaxError(sql, i);
                }
                return j;
            }
            case '/': {
                this.checkRunOver(i + 1, len, sql);
                if (sql.charAt(i + 1) == '*') {
                    int j = sql.indexOf("*/", i + 2);
                    if (j < 0) {
                        throw Message.getSyntaxError(sql, i);
                    }
                    i = j + 1;
                } else if (sql.charAt(i + 1) == '/') {
                    i += 2;
                    while (i < len && (c = sql.charAt(i)) != '\r' && c != '\n') {
                        ++i;
                    }
                }
                return i;
            }
            case '-': {
                this.checkRunOver(i + 1, len, sql);
                if (sql.charAt(i + 1) == '-') {
                    i += 2;
                    while (i < len && (c = sql.charAt(i)) != '\r' && c != '\n') {
                        ++i;
                    }
                }
                return i;
            }
        }
        throw Message.getInternalError("c=" + c);
    }

    String translateSQL(String sql) throws SQLException {
        if (sql == null || sql.indexOf(123) < 0) {
            return sql;
        }
        int len = sql.length();
        char[] chars = null;
        int level = 0;
        block8: for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '-': 
                case '/': {
                    i = this.translateGetEnd(sql, i, c);
                    continue block8;
                }
                case '{': {
                    ++level;
                    if (chars == null) {
                        chars = sql.toCharArray();
                    }
                    chars[i] = 32;
                    while (Character.isSpaceChar(chars[i])) {
                        this.checkRunOver(++i, len, sql);
                    }
                    int start = i;
                    if (chars[i] >= '0' && chars[i] <= '9') {
                        chars[i - 1] = 123;
                        while (true) {
                            this.checkRunOver(i, len, sql);
                            c = chars[i];
                            if (c == '}') break;
                            switch (c) {
                                case '\"': 
                                case '\'': 
                                case '-': 
                                case '/': {
                                    i = this.translateGetEnd(sql, i, c);
                                    break;
                                }
                            }
                            ++i;
                        }
                        --level;
                        continue block8;
                    }
                    if (chars[i] == '?') {
                        chars[i++] = 32;
                        this.checkRunOver(i, len, sql);
                        while (Character.isSpaceChar(chars[i])) {
                            this.checkRunOver(++i, len, sql);
                        }
                        if (sql.charAt(i) != '=') {
                            throw Message.getSyntaxError(sql, i, "=");
                        }
                        chars[i++] = 32;
                        this.checkRunOver(i, len, sql);
                        while (Character.isSpaceChar(chars[i])) {
                            this.checkRunOver(++i, len, sql);
                        }
                    }
                    while (!Character.isSpaceChar(chars[i])) {
                        this.checkRunOver(++i, len, sql);
                    }
                    int remove = 0;
                    if (this.found(sql, start, "fn")) {
                        remove = 2;
                    } else {
                        if (this.found(sql, start, "escape") || this.found(sql, start, "call")) continue block8;
                        if (this.found(sql, start, "oj")) {
                            remove = 2;
                        } else if (this.found(sql, start, "ts")) {
                            remove = 2;
                        } else if (this.found(sql, start, "t")) {
                            remove = 1;
                        } else if (this.found(sql, start, "d")) {
                            remove = 1;
                        } else if (this.found(sql, start, "params")) {
                            remove = "params".length();
                        }
                    }
                    i = start;
                    while (remove > 0) {
                        chars[i] = 32;
                        ++i;
                        --remove;
                    }
                    continue block8;
                }
                case '}': {
                    if (--level < 0) {
                        throw Message.getSyntaxError(sql, i);
                    }
                    chars[i] = 32;
                    continue block8;
                }
            }
        }
        if (level != 0) {
            throw Message.getSyntaxError(sql, sql.length() - 1);
        }
        if (chars != null) {
            sql = new String(chars);
        }
        return sql;
    }

    private void checkRunOver(int i, int len, String sql) throws SQLException {
        if (i >= len) {
            throw Message.getSyntaxError(sql, i);
        }
    }

    private boolean found(String sql, int start, String other) {
        return sql.regionMatches(true, start, other, 0, other.length());
    }

    private void checkTypeAndConcurrency(int resultSetType, int resultSetConcurrency) throws SQLException {
    }

    private void checkHoldability(int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw Message.getInvalidValueException("" + resultSetHoldability, "resultSetHoldability");
        }
    }

    void checkClosed() throws SQLException {
        if (this.session == null) {
            throw Message.getSQLException(90007);
        }
        if (this.session.isClosed()) {
            throw Message.getSQLException(90121);
        }
    }

    String getURL() throws SQLException {
        this.checkClosed();
        return this.url;
    }

    String getUser() throws SQLException {
        this.checkClosed();
        return this.user;
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        if (this.isInternal) {
            return;
        }
        if (this.session != null) {
            this.trace.error("Connection not closed", this.openStackTrace);
            try {
                this.close();
            }
            catch (SQLException e) {
                this.trace.debug("finalize", e);
            }
        }
    }

    private void rollbackInternal() throws SQLException {
        this.rollback = this.prepareCommand("ROLLBACK", this.rollback);
        this.rollback.executeUpdate();
    }

    public int getPowerOffCount() {
        return this.session == null || this.session.isClosed() ? 0 : this.session.getPowerOffCount();
    }

    public void setPowerOffCount(int count) throws SQLException {
        if (this.session != null) {
            this.session.setPowerOffCount(count);
        }
    }

    public void setExecutingStatement(Statement stat) {
        this.executingStatement = stat;
    }

    ResultInterface getGeneratedKeys(JdbcStatement statement, int id) throws SQLException {
        this.getGeneratedKeys = this.prepareCommand("CALL IDENTITY()", this.getGeneratedKeys);
        return this.getGeneratedKeys.executeQuery(0, false);
    }

    public Clob createClob() throws SQLException {
        try {
            int id = this.getNextId(10);
            this.debugCodeAssign("Clob", 10, id, "createClob()");
            this.checkClosed();
            ValueLob v = ValueLob.createSmallLob(16, new byte[0]);
            return new JdbcClob(this.session, this, v, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Blob createBlob() throws SQLException {
        try {
            int id = this.getNextId(9);
            this.debugCodeAssign("Blob", 9, id, "createClob()");
            this.checkClosed();
            ValueLob v = ValueLob.createSmallLob(15, new byte[0]);
            return new JdbcBlob(this.session, this, v, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public synchronized boolean isValid(int timeout) {
        try {
            this.debugCodeCall("isValid", timeout);
            this.checkClosed();
            this.getInternalAutoCommit();
            return true;
        }
        catch (Throwable e) {
            this.logAndConvert(e);
            return false;
        }
    }

    public String getClientInfo(String name) throws SQLException {
        throw Message.getUnsupportedException();
    }

    Value createClob(Reader x, long length) throws SQLException {
        if (x == null) {
            return ValueNull.INSTANCE;
        }
        if (length <= 0L) {
            length = -1L;
        }
        ValueLob v = ValueLob.createClob(x, length, this.session.getDataHandler());
        return v;
    }

    Value createBlob(InputStream x, long length) throws SQLException {
        if (x == null) {
            return ValueNull.INSTANCE;
        }
        if (length <= 0L) {
            length = -1L;
        }
        ValueLob v = ValueLob.createBlob(x, length, this.session.getDataHandler());
        return v;
    }

    private void checkMap(Map map) throws SQLException {
        if (map != null && map.size() > 0) {
            throw Message.getUnsupportedException();
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

