/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.table.Table;

public abstract class RightOwner
extends DbObjectBase {
    private HashMap grantedRoles;
    private HashMap grantedRights;

    protected RightOwner(Database database, int id, String name, String traceModule) {
        this.initDbObjectBase(database, id, name, traceModule);
    }

    public boolean isRoleGranted(Role grantedRole) {
        if (grantedRole == this) {
            return true;
        }
        if (this.grantedRoles != null) {
            Iterator it = this.grantedRoles.keySet().iterator();
            while (it.hasNext()) {
                Role role = (Role)it.next();
                if (role == grantedRole) {
                    return true;
                }
                if (!role.isRoleGranted(grantedRole)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isRightGrantedRecursive(Table table, int rightMask) {
        Right right;
        if (this.grantedRights != null && (right = (Right)this.grantedRights.get(table)) != null && (right.getRightMask() & rightMask) == rightMask) {
            return true;
        }
        if (this.grantedRoles != null) {
            Iterator it = this.grantedRoles.keySet().iterator();
            while (it.hasNext()) {
                RightOwner role = (RightOwner)it.next();
                if (!role.isRightGrantedRecursive(table, rightMask)) continue;
                return true;
            }
        }
        return false;
    }

    public void grantRight(Table table, Right right) {
        if (this.grantedRights == null) {
            this.grantedRights = new HashMap();
        }
        this.grantedRights.put(table, right);
    }

    public void revokeRight(Table table) {
        if (this.grantedRights == null) {
            return;
        }
        this.grantedRights.remove(table);
        if (this.grantedRights.size() == 0) {
            this.grantedRights = null;
        }
    }

    public void grantRole(Session session, Role role, Right right) {
        if (this.grantedRoles == null) {
            this.grantedRoles = new HashMap();
        }
        this.grantedRoles.put(role, right);
    }

    public void revokeRole(Session session, Role role) throws SQLException {
        if (this.grantedRoles == null) {
            throw Message.getSQLException(90073);
        }
        Right right = (Right)this.grantedRoles.get(role);
        if (right == null) {
            throw Message.getSQLException(90073);
        }
        this.grantedRoles.remove(role);
        if (this.grantedRoles.size() == 0) {
            this.grantedRoles = null;
        }
    }

    public Right getRightForTable(Table table) {
        if (this.grantedRights == null) {
            return null;
        }
        return (Right)this.grantedRights.get(table);
    }

    public Right getRightForRole(Role role) {
        if (this.grantedRoles == null) {
            return null;
        }
        return (Right)this.grantedRoles.get(role);
    }
}

