/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;

public class CreateSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifNotExists;
    private Expression start;
    private Expression increment;
    private Expression cacheSize;
    private boolean belongsToTable;

    public CreateSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.getSchema().findSequence(this.sequenceName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90035, this.sequenceName);
        }
        int id = this.getObjectId(false, true);
        Sequence sequence = new Sequence(this.getSchema(), id, this.sequenceName, this.belongsToTable);
        sequence.setStartValue(this.getLong(this.start, 1L));
        sequence.setIncrement(this.getLong(this.increment, 1L));
        sequence.setCacheSize(this.getLong(this.cacheSize, 32L));
        db.addSchemaObject(this.session, sequence);
        return 0;
    }

    private long getLong(Expression expr, long defaultValue) throws SQLException {
        if (expr == null) {
            return defaultValue;
        }
        return expr.optimize(this.session).getValue(this.session).getLong();
    }

    public void setStartWith(Expression start) {
        this.start = start;
    }

    public void setIncrement(Expression increment) {
        this.increment = increment;
    }

    public void setBelongsToTable(boolean belongsToTable) {
        this.belongsToTable = belongsToTable;
    }

    public void setCacheSize(Expression cacheSize) {
        this.cacheSize = cacheSize;
    }
}

