#include "ViewTrap.h"

#include "./Sequence/MainGameSequence.h"
#include "./MainGameViewManager.h"
#include "./MainGameDataManager.h"

#include "TrapCSV.h"
#include "TrapTag.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ViewTrap::ViewTrap(MainGameViewManager* pViewManager)
	: mPViewManager(pViewManager)
	, mIsEnable(true)
	, mIsVisible(true)
{
	// 㩂̃fQ쐬
	for (int i = 0; i < TrapTag::eTRAP_COUNT; ++i)
	{
		const TrapCSV::SBase* kPBaseData = TrapCSV::GetInstance()->GetBaseData( static_cast<TrapTag::ETrapTag>(i) );

		mPModels[i].SetPointer(NEW StaticModelDX9());
		mPModels[i]->LoadMesh(kPBaseData->mModelFilePath);
	}

	// VF[_[ǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_CHARACTER));
}

/// fXgN^
ViewTrap::~ViewTrap()
{
}

/// XV
void ViewTrap::Update(float delta)
{
	if (!mIsEnable)
	{
		return;
	}

	// 㩂̃fXV
	const int kModelCount = SIZE_OF_ARRAY(mPModels);
	for (int i = 0; i < kModelCount; ++i)
	{
		ASSERT_PF(mPModels[i], _T("f܂B"));
		if (mPModels[i])
		{
			mPModels[i]->Update(delta);
		}
	}
}

/// `
void ViewTrap::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// 㩂̃f`
	const int kModelCount = SIZE_OF_ARRAY(mPModels);
	for (int i = 0; i < kModelCount; ++i)
	{
		// VF[_[BeginsĂBōsƂŁAf̎ނƂɈꊇ`悪łB
		// ǂ̃fl̃VF[_[gpꍇAނ𒴂Ĉꊇ`ɂ邱Ƃ\B
		unsigned passCount = 0;
		mPShader->Begin(&passCount);

			for (int trapIndex = 0; trapIndex < GetDataMgr()->GetTrapManager()->GetTrapCount(); ++trapIndex)
			{
				// 㩏̎擾
				SP<TrapManager::STrap> pSTrap = GetDataMgr()->GetTrapManager()->GetTrapAt(trapIndex);
				ASSERT_PF(pSTrap, _T("gbv擾ł܂łB"));
				if (!pSTrap)
				{
					continue;
				}

				// f̎擾
				SP<StaticModelDX9> pModel = mPModels[pSTrap->mETrapTag];
				ASSERT_PF(pModel, _T("f擾ł܂łB"));
				if (!pModel)
				{
					continue;
				}

				// ʒu
				const SP<TerrainGrid::STile> kPTile = GetDataMgr()->GetTerrainGrid()->GetTileAt(pSTrap->mGridPosition);
				ASSERT_PF(kPTile, _T("^C擾ł܂łB"));
				pModel->SetPosition(kPTile->mWorldPosition);

				// `
				pModel->SetCamera( GetDataMgr()->GetCamera() );
				pModel->SetShaderEffect(mPShader);
				pModel->SetBeganShader(true, passCount);
				pModel->Render();
			}

		mPShader->End();
	}
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// XVtO擾
bool ViewTrap::IsEnbale() const
{
	return mIsEnable;
}

/// XVtOݒ
void ViewTrap::SetEnbale(bool value)
{
	mIsEnable = value;
}

/// `tO擾
bool ViewTrap::IsVisible() const
{
	return mIsVisible;
}

/// `tOݒ
void ViewTrap::SetVisible(bool value)
{
	mIsVisible = value;
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainGameDataManager> ViewTrap::GetDataMgr()
{
	return mPViewManager->GetSequence()->GetDataManager();
}