#include "TitleDataManager.h"

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"

#include "Blast/Frontend/FEMenuEntryImage.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Frontend;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TitleDataManager::TitleDataManager()
{
	// J쐬
	mPCamera.SetPointer(NEW Camera2D());

	// XvCg쐬
	for (int i = 0; i < eSPRITE_COUNT; ++i)
	{
		mPSprites[i].SetPointer(NEW SpriteDX9());
	}
	const TCHAR* const kPSpriteTextureFileNames[eSPRITE_COUNT] =
	{
		_T("./Res/Sprite/BG/Title.jpg"),
		_T("./Res/Sprite/ImageFont/Title/PressAnyButton.png"),
	};
	for (int i = 0; i < eSPRITE_COUNT; ++i)
	{
		// eNX`ݒ
		SP<FileTexture2DDX9> pFileTex(NEW FileTexture2DDX9());
		if ( pFileTex->Load(kPSpriteTextureFileNames[i]) )
		{
			mPSprites[i]->SetTexture(pFileTex);
			mPSprites[i]->FitTextureSize();				// TCYݒ
			mPSprites[i]->FitTextureSourceRectangle();	// öݒ
		}
	}

	// ŃXvCg̏lݒ
	const int kHalfScreenWidth = SCREEN_SIZE_WIDTH / 2;
	const int kHalfScreenHeight = SCREEN_SIZE_HEIGHT / 2;
	const Vector3 kTitleLogoPos((float)kHalfScreenWidth, (float)kHalfScreenHeight, 0);
	mPSprites[eSPRITE_TITLELOGO]->SetPosition(kTitleLogoPos);
	mPSprites[eSPRITE_TITLELOGO]->SetSize(SCREEN_SIZE_WIDTH, SCREEN_SIZE_HEIGHT);
	mPSprites[eSPRITE_TITLELOGO]->SetOrigin(SpriteDX9::eORIGIN_CENTER);

	mPSprites[eSPRITE_PRESSANYBUTTON]->SetPosition((float)kHalfScreenWidth, (float)kHalfScreenHeight, 0);
	mPSprites[eSPRITE_PRESSANYBUTTON]->SetOrigin(SpriteDX9::eORIGIN_CENTER);


	// tF[h쐬
	mPFade.SetPointer(NEW Fade());

	// j[쐬
	mPMenu.SetPointer(NEW FEMenu());
	Vector3 menuPos(SCREEN_SIZE_WIDTH * 0.5f, 400.0f, 0);
	mPMenu->SetPosition(menuPos);
	mPMenu->SetLineSpacing(100.0f);

	// j[ڂ쐬
	const TCHAR* const kPItemImagePaths[eMENU_ENTRY_COUNT] =
	{
		_T("./Res/Sprite/ImageFont/Title/NewGame_Normal.jpg"),
		_T("./Res/Sprite/ImageFont/Title/LoadGame_Normal.jpg"),
	};
	for (int i = 0; i < eMENU_ENTRY_COUNT; ++i)
	{
		SP<FileTexture2DDX9> pTex(NEW FileTexture2DDX9());
		pTex->Load(kPItemImagePaths[i]);

		SP<SpriteDX9> pSprite(NEW SpriteDX9());
		pSprite->SetTexture(pTex);
		pSprite->FitTextureSize();
		pSprite->FitTextureSourceRectangle();
		pSprite->SetOrigin(SpriteDX9::eORIGIN_CENTER);

		SP<FEMenuEntryImage> pFEImage(NEW FEMenuEntryImage());
		pFEImage->SetSprite(pSprite);
		pFEImage->SetCamera(mPCamera);	//< FEMenuɓƊOANZXÂ炢̂ŁAŐݒ肷B

		mPMenu->AddItem(pFEImage);
	}
}
/// fXgN^
TitleDataManager::~TitleDataManager()
{
}

/// 
void TitleDataManager::HandleInput(float delta)
{
}

/// XV
void TitleDataManager::Update(float delta)
{
	mPCamera->Update(delta);
	for (int i = 0; i < eSPRITE_COUNT; ++i)
	{
		mPSprites[i]->Update(delta);
	}
	mPFade->Update(delta);
	mPMenu->Update(delta);
}

/// `
void TitleDataManager::Render()
{
	// XvCg̕\
	for (int i = 0; i < eSPRITE_COUNT; ++i)
	{
		mPSprites[i]->SetCamera(mPCamera);
		mPSprites[i]->Render();
	}

	// j[
	mPMenu->Render();

	// tF[h̕`
	mPFade->Render();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// J擾
SP<Camera2D> TitleDataManager::GetCamera2D()
{
	return mPCamera;
}

/// XvCgQ擾
SP<SpriteDX9>* TitleDataManager::GetSprites()
{
	return &mPSprites[0];
}

/// tF[h擾
SP<Fade> TitleDataManager::GetFade()
{
	return mPFade;
}

/// j[擾
SP<FEMenu> TitleDataManager::GetMenu()
{
	return mPMenu;
}
