#include "TerrainChipset.h"

#include "MapDataManager.h"
#include "ChipsetTag.h"

#include "TerrainGrid.h"	//< f[^̎擾ꏊRRƂłƂ肠p

using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TerrainChipset::TerrainChipset()
	: mETag(ChipsetTag::eCHIPSET_GLASSLAND)	//< l̓eLg[
{
}

/// fXgN^
TerrainChipset::~TerrainChipset()
{
}

/// `bvZbg쐬
void TerrainChipset::CreateChipset(ChipsetTag::EChipsetTag eTag)
{
	mChips.clear();

	mETag = eTag;

	// UNDONE:`bv̔z쐬B
	for (int i = 0; i < TerrainGrid::eTILE_CATEGORY_COUNT; ++i)
	{
		// fǂݍ
		const MapDataManager::SChipData& kRSData = MapDataManager::GetInstance()->GetChipData((ChipTag::EChipTag)eTag);

		SP<StaticModelDX9> pModel(NEW StaticModelDX9());
		pModel->LoadMesh(kRSData.mPModelFilePath);

		// zɒǉ
		SP<SChip> pSChip(NEW SChip());
		pSChip->mPModel = pModel;

		mChips.push_back(pSChip);
	}
}

/// `bv擾
SP<TerrainChipset::SChip> TerrainChipset::GetChipAt(int index)
{
	const bool kIsInRange = MathHelper::IsInOfRange<int>(index, mChips.size());
	ASSERT_PF(kIsInRange, _T("CfbNX͈͊OłB"));
	if (kIsInRange)
	{
		return mChips.at(index);
	}

	return SP<TerrainChipset::SChip>();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// `bṽXg擾BconsttB
const TerrainChipset::ChipList* TerrainChipset::GetChips() const
{
	return &mChips;
}

/// `bṽXg擾
TerrainChipset::ChipList* TerrainChipset::GetChips()
{
	return const_cast<ChipList*>( static_cast<const TerrainChipset*>(this)->GetChips() );
}