#include "DebugSequenceInputMouse.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Sequence::Debug::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceInputMouse::DebugSequenceInputMouse()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceInputMouse::~DebugSequenceInputMouse()
{
}


/// `
void DebugSequenceInputMouse::Render()
{
	// ̕`揈
	SequenceBase::Render();


	// }EX擾
	IMouse* pMouse = InputManagerHelper::GetMouse();

	// }EX|C^̍W擾
	int x = pMouse->GetPositionX();
	int y = pMouse->GetPositionY();

	// }EX|C^̈ړʂ擾
	int deltaX = pMouse->GetDeltaPositionX();
	int deltaY = pMouse->GetDeltaPositionY();

	// zC[̑ʂ擾
	long wheel = pMouse->GetWheel();

	// NbNǂ擾
	bool isLeftClick = pMouse->IsJustDown(Buttons::eBUTTON_LEFT);
	bool isRightClick = pMouse->IsJustDown(Buttons::eBUTTON_RIGHT);

	// {^Ă邩ǂ擾
	bool isLeftButtonDown = pMouse->IsDown(Buttons::eBUTTON_LEFT);
	bool isRightButtonDown = pMouse->IsDown(Buttons::eBUTTON_RIGHT);

	// `ʒu
	int renderX = 0;
	int renderY = 0;

	// sԍp
	int lineIndex = 0;

	// sԂp
	const int kLineSpacing = 12;

	// 
	renderY = kLineSpacing * lineIndex++;
	DP(renderX, renderY, 0xffffffff, _T("<}EX>"));

	// W`
	renderY = kLineSpacing * lineIndex++;
	renderY = kLineSpacing * lineIndex++;
	DP(renderX, renderY, 0xffffff00, _T("X, Y:(% 4d, % 4d)"), x, y);

	// ړʂ`
	renderY = kLineSpacing * lineIndex++;
	DP(renderX, renderY, 0xffffff00, _T("DX, DY:(% 3d, % 3d)"), deltaX, deltaY);

	// zC[̑ʂ`
	renderY = kLineSpacing * lineIndex++;
	DP(renderX, renderY, 0xffff0000, _T("Wheel:% d"), wheel);

	// NbNǂ`
	renderY = kLineSpacing * lineIndex++;
	DP(renderX, renderY, 0xffff8888, _T("LeftClick:%s"), (isLeftClick ? _T("True") : _T("")));

	renderY = kLineSpacing * lineIndex++;
	DP(renderX, renderY, 0xffff8888, _T("RightClick:%s"), (isRightClick ? _T("True") : _T("")));

	// {^Ă邩ǂ`
	renderY = kLineSpacing * lineIndex++;
	DP(renderX, renderY, 0xffff8888, _T("LeftButtonDown:%s"),  (isLeftButtonDown ? _T("True") : _T("False")));

	renderY = kLineSpacing * lineIndex++;
	DP(renderX, renderY, 0xffff8888, _T("RightButtonDown:%s"),  (isRightButtonDown ? _T("True") : _T("False")));
}