#include "Sequence/Debug/Input/DebugSequenceInputKeyboard.h"

#include "Blast/Base/DebugMenuEntryStrings.h"
#include "Blast/Base/MenuEntryNumeric.h"
#include "Blast/Base/MenuEntryNumeric.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::String;
using namespace Sequence::Debug::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceInputKeyboard::DebugSequenceInputKeyboard()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceInputKeyboard::~DebugSequenceInputKeyboard()
{
}

/// 
void DebugSequenceInputKeyboard::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// ĂL[QNA
	mEDownKeys.clear();

	// fobOj[쐬
	CreateDebugMenu();
}

/// 
void DebugSequenceInputKeyboard::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();

	// ĂL[ێ
	pKB->GetDownKeys(&mEDownKeys);
}

/// `
void DebugSequenceInputKeyboard::Render()
{
	// ̕`揈
	SequenceBase::Render();


	// ʒu
	int x = 10;
	int y = 50;

	// s
	int lineSpacing = 12;

	// sCfbNX
	int lineIndex = 0;

	// ĂL[
	++lineIndex;
	++lineIndex;
	DP(x, y + lineSpacing * lineIndex, 0xff00ffff, _T("ĂL["));

	// ĂL[̐Ń[v
	int size = mEDownKeys.size();
	for (int i = 0; i < size; ++i)
	{
		Keys::EKey eKey = mEDownKeys.at(i);

		++lineIndex;
		DP(x, y + lineSpacing * lineIndex, 0xffffffff, _T("%-#4x"), eKey);
	}
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// MEMO:eXgpłB[lȂǂłB
int gTest = 0;

/// fobOj[\z
void DebugSequenceInputKeyboard::CreateDebugMenu()
{
	// I\ȃGg[Xg쐬
	SP<MenuEntryListScroll> pDMEL = SP<MenuEntryListScroll>(NEW MenuEntryListScroll());

	// Gg[ǉ
	MenuEntryNumeric<int>* pDSMEN = NEW MenuEntryNumeric<int>();
	pDSMEN->SetText(_T("EŒl܂B"));
	pDSMEN->SetNumericPointer(&gTest);
	pDSMEN->SetStep(7);

	pDMEL->AddMenuEntry(SP<IMenuEntry>(pDSMEN));

	// j[ɃGg[Xgǉ
	mPDebugMenu->AddMenuEntryList(SP<MenuEntryListScroll>(pDMEL));
}