#include "Sequence/Debug/DebugSequenceGameWindow.h"

#include "Camera2D.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Blast::String;
using namespace Sequence::Debug;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceGameWindow::DebugSequenceGameWindow()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceGameWindow::~DebugSequenceGameWindow()
{
}

/// 
void DebugSequenceGameWindow::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// JQ[R|[lgɒǉ
	SP<Camera2D> pCamera2D(NEW Camera2D());
	mPCamera = pCamera2D;

	mPGameComponents->Add(pCamera2D, mPGameComponents);


	// EBhE쐬
	for (int i = 0; i < stKWindowCount; ++i)
	{
		mPGameWindows[i].SetPointer(NEW GameWindow());

		mPGameWindows[i]->SetCamera(mPCamera);
		mPGameWindows[i]->SetSize(Vector2::One() * 200);
		mPGameWindows[i]->SetPosition(Vector3(SCREEN_SIZE_WIDTH / 4, SCREEN_SIZE_HEIGHT / 4, 0));
	}

	
#if _DEBUG

	// fobOj[쐬
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("DebugSequenceGameWindow");

	// Xg쐬
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("Q[EBhE");
	mPDebugMenu->AddMenuEntryList(pMEL);

	for (int count = 0; count < stKWindowCount; ++count)
	{
		// ʒuύX̃Gg쐬
		SP<MenuEntry> pMEPosition(NEW MenuEntry());
		pMEPosition->SetText(_T("ʒu"));
		pMEL->AddMenuEntry(pMEPosition);

		// ԂȂ̂ŗ\߈ʒu߂Ă
		mDebugWindowPositions[count] = Vector3::One() * 300.0f * static_cast<float>(count + 1);
		mDebugWindowPositions[count].mZ = 0;

		const int kPositionFactorCount = 3;
		for (int i = 0; i < kPositionFactorCount; ++i)
		{
			SP<MenuEntryNumeric<float>> pMENPosition(NEW MenuEntryNumeric<float>());
			pMENPosition->SetText(_T("Position"));
			pMENPosition->SetNumericPointer(&mDebugWindowPositions[count][i]);
			pMEL->AddMenuEntry(pMENPosition);
		}

		// TCYύX̃Gg쐬
		SP<MenuEntry> pMESize(NEW MenuEntry());
		pMESize->SetText(_T("TCY"));
		pMEL->AddMenuEntry(pMESize);

		// ԂȂ̂ŗ\߃TCY߂Ă
		mDebugWindowSizes[count] = Vector2::One() * 100.0f * static_cast<float>(count + 1);

		const int kSizeFactorCount = 2;
		for (int i = 0; i < kSizeFactorCount; ++i)
		{
			SP<MenuEntryNumeric<float>> pMENSize(NEW MenuEntryNumeric<float>());
			pMENSize->SetText(_T("Size"));
			pMENSize->SetNumericPointer(&mDebugWindowSizes[count][i]);
			pMEL->AddMenuEntry(pMENSize);
		}


		// Ԃɉs}
		if (count != stKWindowCount)
		{
			SP<MenuEntry> pMENewLine(NEW MenuEntry());
			pMENewLine->SetText(_T("-------------------"));
			pMEL->AddMenuEntry(pMENewLine);
		}
	}

#endif // _DEBUG
}

/// 
void DebugSequenceGameWindow::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);
}

/// XV
void DebugSequenceGameWindow::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);


#if _DEBUG

	// fobOp̒l
	for (int i = 0; i < stKWindowCount; ++i)
	{
		mPGameWindows[i]->SetPosition(mDebugWindowPositions[i]);
		mPGameWindows[i]->SetSize(mDebugWindowSizes[i]);
	}

#endif // _DEBUG


	// EBhE̍XV
	for (int i = 0; i < stKWindowCount; ++i)
	{
		if (mPGameWindows[i])
		{
			mPGameWindows[i]->Update(delta);
		}
	}
}

/// `
void DebugSequenceGameWindow::Render()
{
	// ̕`揈
	SequenceBase::Render();


	// EBhE̕`
	for (int i = 0; i < stKWindowCount; ++i)
	{
		if (mPGameWindows[i])
		{
			mPGameWindows[i]->Render();
		}
	}
}