#include "Sequence/Debug/DebugSequenceFrontend.h"

#include "Blast/Frontend/FEMenuEntryText.h"
#include "Blast/Frontend/FEMenuEntryImage.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;
using namespace Blast::Frontend;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceFrontend::DebugSequenceFrontend()
	: SequenceBase(false)
{
	// 2DJ쐬
	mPCamera2D.SetPointer(NEW Camera2D());

	// tgGh̃j[쐬
	mPMenu.SetPointer(NEW FEMenu());
	mPMenu->SetPosition( Vector3::One() * 50.0f );
	mPMenu->SetLineSpacing(0.0f);

	// 
	const TCHAR* const kPTexts[] =
	{
		_T("ꂪ1"),
		_T("ꂪ2"),
		_T("ꂪ3"),
	};
	const int kTextCount = SIZE_OF_ARRAY(kPTexts);
	for (int i = 0; i < kTextCount; ++i)
	{
		SP<FEMenuEntryText> pFEText(NEW FEMenuEntryText());
		pFEText->SetCamera(mPCamera2D);
		pFEText->SetText(kPTexts[i]);

		mPMenu->AddItem(pFEText);
	}

	// 摜
	const TCHAR* const kPSpriteFilePaths[] =
	{
		_T("./Res/Sprite/__TEST__/Undine_Normal.png"),
		_T("./Res/Sprite/__TEST__/Undine_Selected.png"),

		_T("./Res/Sprite/__TEST__/Dryad_Normal.png"),
		_T("./Res/Sprite/__TEST__/Dryad_Selected.png"),
	};
	const int kSpriteCount = SIZE_OF_ARRAY(kPSpriteFilePaths);
	for (int i = 0; i < kSpriteCount; i += 2)
	{
		// ʏ
		SP<FileTexture2DDX9> pTex(NEW FileTexture2DDX9());
		pTex->Load(kPSpriteFilePaths[i]);

		SP<SpriteDX9> pSprite(NEW SpriteDX9());
		pSprite->SetTexture(pTex);
		pSprite->FitTextureSize();
		pSprite->FitTextureSourceRectangle();
		pSprite->SetOrigin(SpriteDX9::eORIGIN_UP_LEFT);

		// Ip
		SP<FileTexture2DDX9> pTex2(NEW FileTexture2DDX9());
		pTex2->Load(kPSpriteFilePaths[i + 1]);

		SP<SpriteDX9> pSprite2(NEW SpriteDX9());
		pSprite2->SetTexture(pTex2);
		pSprite2->FitTextureSize();
		pSprite2->FitTextureSourceRectangle();
		pSprite2->SetOrigin(SpriteDX9::eORIGIN_UP_LEFT);


		SP<FEMenuEntryImage> pFEImage(NEW FEMenuEntryImage());
		pFEImage->SetSprite(pSprite);
		pFEImage->SetCamera(mPCamera2D);
		pFEImage->SetSelectedColorReflection(false);
		pFEImage->SetSelectedImageReflection(true);
		pFEImage->SetSelectedSprite(pSprite2);

		mPMenu->AddItem(pFEImage);
	}
}

/// fXgN^
DebugSequenceFrontend::~DebugSequenceFrontend()
{
}


/// 
void DebugSequenceFrontend::Initialize()
{
	// ̏
	SequenceBase::Initialize();
}

/// 
void DebugSequenceFrontend::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);

	mPMenu->HandleInput(delta);
}

/// XV
void DebugSequenceFrontend::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);

	mPCamera2D->Update(delta);
	mPMenu->Update(delta);
}

/// `
void DebugSequenceFrontend::Render()
{
	// ̕`揈
	SequenceBase::Render();

	mPMenu->Render();
}